/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.joal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.xith3d.sound.BufferFormat;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.drivers.joal.SoundDriverImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundBufferImpl
implements SoundBuffer {
    protected SoundDriverImpl driver;
    protected int handle;

    protected SoundBufferImpl(SoundDriverImpl driver) {
        this.driver = driver;
        int[] ret = new int[1];
        driver.getAL().alGenBuffers(1, ret, 0);
        this.handle = ret[0];
        X3DLog.debug("A new buffer with handle ", this.handle, " has been allocated");
    }

    public void setData(BufferFormat format, int size, int frequency, ByteBuffer data) {
        X3DLog.debug(new Object[]{"buffer is size=", size, ", freq=", frequency, ", format", format});
        int f = 0;
        if (format == BufferFormat.MONO16) {
            f = 4353;
        } else if (format == BufferFormat.MONO8) {
            f = 4352;
        } else if (format == BufferFormat.STEREO16) {
            f = 4355;
        } else if (format == BufferFormat.STEREO8) {
            f = 4354;
        }
        data.rewind();
        this.driver.getAL().alBufferData(this.handle, f, (Buffer)data, size, frequency);
    }
}

