/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.lwjgl;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundException;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.drivers.lwjgl.SoundBufferImpl;
import org.xith3d.sound.drivers.lwjgl.SoundSourceImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundDriverImpl
implements SoundDriver {
    private List<SoundSource> sources;
    private List<SoundBufferImpl> buffers;
    private List<SoundSource> availableSources;
    private float listenerVolume = 1.0f;
    private float dopplerVelocity = 1.0f;
    private float dopplerFactor = 0.0f;
    private boolean isOnline;

    protected String decodeSoundError(int error) {
        switch (error) {
            case 0: {
                return "NO ERROR";
            }
            case 40962: {
                return "INVALID ENUM";
            }
            case 40963: {
                return "INVALID VALUE";
            }
            case 40961: {
                return "INVALID NAME";
            }
            case 40964: {
                return "INVALID OPERATION";
            }
            case 40965: {
                return "OUT OF MEMORY";
            }
        }
        return "UNKNOWN ERROR";
    }

    protected void checkError() {
        int error = AL10.alGetError();
        if (error != 0) {
            throw new Error(this.decodeSoundError(error));
        }
    }

    public void newFrameSync() {
        int[] sourceList = new int[this.sources.size()];
        for (int i = 0; i < sourceList.length; ++i) {
            SoundSourceImpl ss = (SoundSourceImpl)this.sources.get(i);
            sourceList[i] = ss.handle;
            ss.stop();
        }
    }

    public void newFrameAsync() {
    }

    public void setListenerVelocity(Tuple3f velocity) {
        AL10.alListener3f((int)4102, (float)velocity.getX(), (float)velocity.getY(), (float)velocity.getZ());
        this.checkError();
    }

    public void setListenerPosition(Tuple3f position) {
        AL10.alListener3f((int)4100, (float)position.getX(), (float)position.getY(), (float)position.getZ());
        this.checkError();
    }

    public void setListenerOrientation(Tuple3f direction, Tuple3f up) {
        FloatBuffer orientation = BufferUtils.createFloatBuffer((int)6).put(new float[]{direction.getX(), direction.getY(), direction.getZ(), up.getX(), up.getY(), up.getZ()});
        orientation.rewind();
        AL10.alListener((int)4111, (FloatBuffer)orientation);
    }

    public void setListenerVolume(float gain) {
        AL10.alListenerf((int)4106, (float)gain);
        this.checkError();
        this.listenerVolume = gain;
    }

    public float getListenerVolume() {
        return this.listenerVolume;
    }

    public void setDopplerVelocity(float velocity) {
        AL10.alDopplerVelocity((float)velocity);
        this.checkError();
        this.dopplerVelocity = velocity;
    }

    public float getDopplerVelocity() {
        return this.dopplerVelocity;
    }

    public void setDopplerFactor(float factor) {
        AL10.alDopplerFactor((float)factor);
        this.dopplerFactor = factor;
    }

    public float getDopplerFactor() {
        return this.dopplerFactor;
    }

    public SoundSource allocateSoundSource() throws SoundException {
        if (this.availableSources.size() == 0) {
            throw new SoundException("no sound sources available");
        }
        SoundSource s = this.availableSources.remove(this.availableSources.size() - 1);
        this.sources.add(s);
        return s;
    }

    public SoundBuffer allocateSoundBuffer() {
        return new SoundBufferImpl();
    }

    public void delete(SoundSource source) {
        this.sources.remove(source);
        ((SoundSourceImpl)source).releaseCachedResources();
        this.availableSources.add(source);
    }

    public void delete(SoundBuffer buffer) {
    }

    public int getNumAvailableSources() {
        return this.availableSources.size();
    }

    public int getNumSources() {
        return this.sources.size() + this.availableSources.size();
    }

    public void shutdown() {
        SoundSourceImpl ss;
        int j;
        if (!this.isOnline()) {
            return;
        }
        int[] sourceList = new int[this.sources.size() + this.availableSources.size()];
        int i = 0;
        for (j = 0; j < this.sources.size(); ++j) {
            ss = (SoundSourceImpl)this.sources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        for (j = 0; j < this.availableSources.size(); ++j) {
            ss = (SoundSourceImpl)this.availableSources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        if (sourceList.length > 0) {
            IntBuffer sources = BufferUtils.createIntBuffer((int)sourceList.length).put(sourceList);
            sources.rewind();
            AL10.alDeleteSources((IntBuffer)sources);
            this.checkError();
        }
        int[] bufferList = new int[this.buffers.size()];
        int j2 = 0;
        while (i < bufferList.length) {
            SoundBufferImpl ss2 = this.buffers.get(j2);
            bufferList[j2] = ss2.handle;
            ++j2;
        }
        if (bufferList.length > 0) {
            IntBuffer buffers = BufferUtils.createIntBuffer((int)bufferList.length).put(bufferList);
            buffers.rewind();
            AL10.alDeleteBuffers((IntBuffer)buffers);
            this.checkError();
        }
        this.isOnline = false;
    }

    public final boolean isOnline() {
        return this.isOnline;
    }

    public SoundDriverImpl() {
        try {
            AL.create((String)System.getProperty("XITH3D_OPENAL_DEVICE"), (int)44100, (int)60, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.checkError();
        this.sources = new ArrayList<SoundSource>();
        this.buffers = new ArrayList<SoundBufferImpl>();
        this.availableSources = new ArrayList<SoundSource>();
        AL10.alDistanceModel((int)53249);
        this.checkError();
        boolean done = false;
        int n = 0;
        while (!done) {
            try {
                SoundSourceImpl ss = new SoundSourceImpl(this);
                this.availableSources.add(ss);
                if (n++ != 60) continue;
                break;
            }
            catch (Error e) {
                X3DLog.print(e);
                done = true;
            }
        }
        this.setListenerVolume(1.0f);
        this.isOnline = true;
        X3DLog.debug("LWJGL OpenAL sound driver initialized with ", this.availableSources.size(), " available sources");
    }
}

