/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.spatial.clipping;

import java.util.List;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.spatial.clipping.Polygon;
import org.xith3d.utility.logging.X3DLog;

public class PolygonSplitter {
    void clipLineToPlane(Tuple3f va, Tuple3f vb, Polygon frontPolygon, Polygon backPolygon, Plane p) {
        float da = va.getX() * p.getNormal().getX() + va.getY() * p.getNormal().getY() + va.getZ() * p.getNormal().getZ() - p.getD();
        float db = vb.getX() * p.getNormal().getX() + vb.getY() * p.getNormal().getY() + vb.getZ() * p.getNormal().getZ() - p.getD();
        X3DLog.debug("distance from ", va, " to ", p, " is ", Float.valueOf(da));
        X3DLog.debug("distance from ", vb, " to ", p, " is ", Float.valueOf(db));
        if (da >= 0.0f && db >= 0.0f) {
            X3DLog.debug("both are positive, adding points ");
            if (!frontPolygon.contains(va)) {
                frontPolygon.add(va);
            }
            if (!frontPolygon.contains(vb)) {
                frontPolygon.add(vb);
            }
        } else if (da < 0.0f && db < 0.0f) {
            X3DLog.debug("both are negative, placeing in back ");
            if (!backPolygon.contains(va)) {
                backPolygon.add(va);
            }
            if (!backPolygon.contains(vb)) {
                backPolygon.add(vb);
            }
        } else if (da < 0.0f) {
            X3DLog.debug("A is negative, adding point + intersection ");
            Vector3f intersect = new Vector3f();
            float s = da / (da - db);
            intersect.setX(va.getX() + s * (vb.getX() - va.getX()));
            intersect.setY(va.getY() + s * (vb.getY() - va.getY()));
            intersect.setZ(va.getZ() + s * (vb.getZ() - va.getZ()));
            if (!frontPolygon.contains((Tuple3f)intersect)) {
                frontPolygon.add((Tuple3f)intersect);
            }
            if (!frontPolygon.contains(vb)) {
                frontPolygon.add(vb);
            }
            if (!backPolygon.contains(va)) {
                backPolygon.add(va);
            }
            if (!backPolygon.contains((Tuple3f)intersect)) {
                backPolygon.add((Tuple3f)intersect);
            }
        } else if (db < 0.0f) {
            X3DLog.debug("B is negative, adding point + intersection ");
            Vector3f intersect = new Vector3f();
            float s = da / (da - db);
            intersect.setX(va.getX() + s * (vb.getX() - va.getX()));
            intersect.setY(va.getY() + s * (vb.getY() - va.getY()));
            intersect.setZ(va.getZ() + s * (vb.getZ() - va.getZ()));
            X3DLog.debug(" i calc intersection is ", intersect);
            if (!frontPolygon.contains(va)) {
                frontPolygon.add(va);
            }
            if (!frontPolygon.contains((Tuple3f)intersect)) {
                frontPolygon.add((Tuple3f)intersect);
            }
            if (!backPolygon.contains((Tuple3f)intersect)) {
                backPolygon.add((Tuple3f)intersect);
            }
            if (!backPolygon.contains(vb)) {
                backPolygon.add(vb);
            }
        }
        X3DLog.debug("");
    }

    void splitToPlane(Polygon polygon, Plane p, Polygon frontPolygon, Polygon backPolygon) {
        List<Tuple3f> vertices = polygon.getVertices();
        for (int i = 0; i < vertices.size(); ++i) {
            Tuple3f a = vertices.get(i);
            Tuple3f b = vertices.get((i + 1) % vertices.size());
            this.clipLineToPlane(a, b, frontPolygon, backPolygon, p);
        }
    }
}

