/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.net.URL;
import org.xith3d.terrain.GridResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridResourceSpec<Type extends GridResource> {
    private int detail;
    private int refCount;
    private URL[] locations;
    private float s1;
    private float t1;
    private float s2;
    private float t2;
    private float min;
    private float max;
    private Type cachedResource;

    public GridResourceSpec(int detail, URL location, float s1, float t1, float s2, float t2) {
        this(detail, new URL[]{location}, s1, t1, s2, t2);
    }

    public GridResourceSpec(int detail, URL location, float s1, float t1, float s2, float t2, float min, float max) {
        this(detail, new URL[]{location}, s1, t1, s2, t2, min, max);
    }

    public GridResourceSpec(int detail, URL[] locations, float s1, float t1, float s2, float t2) {
        this(detail, locations, s1, t1, s2, t2, Float.MAX_VALUE, Float.MIN_VALUE);
    }

    public GridResourceSpec(int detail, URL[] locations, float s1, float t1, float s2, float t2, float min, float max) {
        this.locations = locations;
        this.detail = detail;
        this.s1 = s1;
        this.t1 = t1;
        this.s2 = s2;
        this.t2 = t2;
        this.min = min;
        this.max = max;
        this.refCount = 0;
        this.cachedResource = null;
    }

    public void setDetail(int detail) {
        this.detail = detail;
    }

    public int getDetail() {
        return this.detail;
    }

    public URL[] getLocations() {
        return this.locations;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public float getS1() {
        return this.s1;
    }

    public float getS2() {
        return this.s2;
    }

    public float getT1() {
        return this.t1;
    }

    public float getT2() {
        return this.t2;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public Type getCachedResource() {
        return this.cachedResource;
    }

    public void setCachedResource(Type cachedResource) {
        this.cachedResource = cachedResource;
    }

    public void addReference() {
        ++this.refCount;
    }

    public boolean release() {
        --this.refCount;
        if (this.refCount < 0) {
            throw new IllegalStateException("Refcounter underflow! Probably a severe problem with the terrain resource handling!");
        }
        if (this.refCount == 0) {
            this.cachedResource = null;
            return true;
        }
        return false;
    }
}

