/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class HF2Map {
    private String fileId;
    private int version;
    private long width;
    private long height;
    private int tileSize;
    private float precision;
    private float horizontalScale;
    private float min;
    private float max;
    private float[][] data;

    public float[][] getData() {
        return this.data;
    }

    public String getFileId() {
        return this.fileId;
    }

    public long getHeight() {
        return this.height;
    }

    public float getHorizontalScale() {
        return this.horizontalScale;
    }

    public float getPrecision() {
        return this.precision;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getVersion() {
        return this.version;
    }

    public long getWidth() {
        return this.width;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL location) throws IOException {
        InputStream in = null;
        try {
            in = location.openStream();
            String loc = location.toString().toLowerCase();
            this.load(in, loc.endsWith(".hfz") || loc.endsWith(".gz") ? Compression.GZIP : Compression.NONE);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream in, Compression compression) throws IOException {
        MemoryCacheImageInputStream stream = null;
        try {
            stream = new MemoryCacheImageInputStream(compression == Compression.NONE ? in : new GZIPInputStream(in));
            stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[] id = new byte[]{stream.readByte(), stream.readByte(), stream.readByte()};
            if (stream.readByte() != 0 || !"HF2".equals(this.fileId = new String(id, "ISO-8859-15"))) {
                throw new IOException("Unsupported format '" + this.fileId + "'!");
            }
            this.version = stream.readUnsignedShort();
            if (this.version != 0) {
                throw new IOException("Unsupported version '" + this.version + "'!");
            }
            this.width = stream.readUnsignedInt();
            this.height = stream.readUnsignedInt();
            this.tileSize = stream.readUnsignedShort();
            this.precision = stream.readFloat();
            this.horizontalScale = stream.readFloat();
            long extHeaderLength = stream.readUnsignedInt();
            if (this.width % (long)this.tileSize > 0L || this.height % (long)this.tileSize > 0L) {
                throw new IOException("Currently only files are supported, which tile size is a whole number divisor of the map size.");
            }
            stream.skipBytes(extHeaderLength);
            stream.flush();
            int htiles = (int)(this.width / (long)this.tileSize) + (this.width % (long)this.tileSize > 0L ? 1 : 0);
            int vtiles = (int)(this.height / (long)this.tileSize) + (this.height % (long)this.tileSize > 0L ? 1 : 0);
            this.data = new float[(int)this.width][(int)this.height];
            this.min = Float.MAX_VALUE;
            this.max = Float.MIN_VALUE;
            for (int v = 0; v < vtiles; ++v) {
                for (int h = 0; h < htiles; ++h) {
                    float vScale = stream.readFloat();
                    float vOffset = stream.readFloat();
                    for (int z = 0; z < this.tileSize; ++z) {
                        byte bDepth = stream.readByte();
                        long currentValue = stream.readUnsignedInt();
                        float value = (float)currentValue * vScale + vOffset;
                        if (value < this.min) {
                            this.min = value;
                        }
                        if (value > this.max) {
                            this.max = value;
                        }
                        this.data[h * this.tileSize][v * this.tileSize + z] = value;
                        for (int x = 1; x < this.tileSize; ++x) {
                            value = (float)(currentValue += bDepth == 4 ? (long)stream.readInt() : (long)(bDepth == 2 ? stream.readShort() : (short)stream.readByte())) * vScale + vOffset;
                            if (value < this.min) {
                                this.min = value;
                            }
                            if (value > this.max) {
                                this.max = value;
                            }
                            this.data[h * this.tileSize + x][v * this.tileSize + z] = value;
                        }
                        stream.flush();
                    }
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public HF2Map(InputStream in, Compression compression) throws IOException {
        this.load(in, compression);
    }

    public HF2Map(URL location) throws IOException {
        this.load(location);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compression {
        NONE,
        GZIP;

    }
}

