/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.net.URL;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.vecmath2.TexCoord2f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.terrain.GridResourceSpec;
import org.xith3d.terrain.GridSurface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureSurface
implements GridSurface {
    private Appearance appearance;
    private float detailRepeat = 4.0f;
    private boolean hasDetailTexture;
    private float s1 = 0.0f;
    private float t1 = 0.0f;
    private float s2 = 1.0f;
    private float t2 = 1.0f;
    private float as = 1.0f;
    private float at = 1.0f;

    public TextureSurface(URL mainTexture) {
        this(mainTexture, null, 0.0f, null);
    }

    public TextureSurface(URL mainTexture, Material material) {
        this(mainTexture, null, 0.0f, null, material);
    }

    public TextureSurface(GridResourceSpec<GridSurface> spec) {
        this(spec.getLocations()[0], spec.getLocations().length < 2 ? null : spec.getLocations()[1], 16.0f, TextureMode.BLEND);
        this.s1 = spec.getS1();
        this.s2 = spec.getS2();
        this.t1 = spec.getT1();
        this.t2 = spec.getT2();
        this.as = 1.0f / (this.s2 - this.s1);
        this.at = 1.0f / (this.t2 - this.t1);
    }

    public TextureSurface(URL mainTexture, URL detailTexture, float detailRepeat, TextureMode blendMode) {
        this(mainTexture, detailTexture, detailRepeat, blendMode, new Material());
        this.getAppearance().getMaterial().setLightingEnabled(false);
    }

    public TextureSurface(URL mainTexture, URL detailTexture, float detailRepeat, TextureMode blendMode, Material material) {
        Appearance a = new Appearance();
        a.setMaterial(material);
        this.detailRepeat = detailRepeat;
        TextureLoader tl = TextureLoader.getInstance();
        Texture2D texture = tl.loadTexture(mainTexture, Texture.MipmapMode.BASE_LEVEL);
        texture.removeFromCache();
        texture.setBoundaryModes(TextureBoundaryMode.CLAMP_TO_EDGE, TextureBoundaryMode.CLAMP_TO_EDGE);
        texture.setFilter(TextureFilter.TRILINEAR);
        TextureAttributes colorAttrs = new TextureAttributes(TextureAttributes.REPLACE, null, null, TextureAttributes.NICEST);
        TextureUnit color = new TextureUnit(texture, colorAttrs);
        boolean bl = this.hasDetailTexture = detailTexture != null;
        if (this.hasDetailTexture) {
            texture = tl.loadTexture(detailTexture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
            texture.setBoundaryModes(TextureBoundaryMode.WRAP, TextureBoundaryMode.WRAP);
            texture.setFilter(TextureFilter.TRILINEAR);
            TextureAttributes detailAttrs = new TextureAttributes(blendMode, null, null, TextureAttributes.NICEST);
            TextureUnit details = new TextureUnit(texture, detailAttrs);
            a.setTextureUnits(color, details);
        } else {
            a.setTextureUnits(color);
        }
        a.setPolygonAttributes(new PolygonAttributes(FaceCullMode.FRONT));
        this.appearance = a;
    }

    @Override
    public void release() {
    }

    @Override
    public Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    public int getTextureUnits() {
        return this.hasDetailTexture ? 2 : 1;
    }

    @Override
    public TexCoord2f map(float s, float t, int unit) {
        float s_ = this.as * (s - this.s1);
        float t_ = this.at * (t - this.t1);
        return unit == 0 ? new TexCoord2f(s_, t_) : new TexCoord2f(s_ * this.detailRepeat, t_ * this.detailRepeat);
    }
}

