/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain.legacy;

import org.xith3d.terrain.legacy.TerrainDataBank;
import org.xith3d.utility.logging.X3DLog;

public class TerrainSquareHandle {
    int bank;
    int node;
    boolean deleted = false;
    TerrainDataBank b;

    public void delete() {
        this.checkBank();
        this.b.delete(this.node);
        this.deleted = true;
    }

    private void checkBank() {
        while (this.b.newBank != null) {
            this.b = this.b.newBank;
        }
        if (this.deleted) {
            throw new Error("attempt to access a deleted node");
        }
        if (this.b.handles[this.node] < 0) {
            X3DLog.error("terrain square handle for bank ", this.bank, " node ", this.node, " is invalid");
            throw new Error("attempt to access a deleted node (2)");
        }
    }

    public float getY(int index) {
        this.checkBank();
        return this.b.getY(this.node, index);
    }

    public void setY(int index, float val) {
        this.checkBank();
        this.b.setY(this.node, index, val);
    }

    public short getError(int index) {
        this.checkBank();
        return this.b.getError(this.node, index);
    }

    public void setError(int index, short val) {
        this.checkBank();
        this.b.setError(this.node, index, val);
    }

    public int getChild(int index) {
        this.checkBank();
        return this.b.getChild(this.node, index);
    }

    public int getChildBank(int index) {
        this.checkBank();
        return this.b.getChildBank(this.node, index);
    }

    public void setChild(int index, int val) {
        this.checkBank();
        this.b.setChild(this.node, index, val);
    }

    public void setChildBank(int index, int val) {
        this.checkBank();
        this.b.setChildBank(this.node, index, val);
    }

    public void incSubEnabledCount(int index) {
        this.checkBank();
        this.setSubEnabledCount(index, (byte)(this.getSubEnabledCount(index) + 1));
    }

    public byte getSubEnabledCount(int index) {
        this.checkBank();
        return this.b.getSubEnabledCount(this.node, index);
    }

    public void setSubEnabledCount(int index, byte val) {
        this.checkBank();
        this.b.setSubEnabledCount(this.node, index, val);
    }

    public short getMinY() {
        this.checkBank();
        return this.b.getMinY(this.node);
    }

    public void setMinY(short val) {
        this.checkBank();
        this.b.setMinY(this.node, val);
    }

    public void andEnabledFlags(byte val) {
        this.checkBank();
        this.setEnabledFlags((byte)(this.getEnabledFlags() & val));
    }

    public byte getEnabledFlags() {
        this.checkBank();
        return this.b.getEnabledFlags(this.node);
    }

    public void setEnabledFlags(byte val) {
        this.checkBank();
        this.b.setEnabledFlags(this.node, val);
    }

    public short getMaxY() {
        this.checkBank();
        return this.b.getMaxY(this.node);
    }

    public void setMaxY(short val) {
        this.checkBank();
        this.b.setMaxY(this.node, val);
    }

    public boolean getStatic() {
        this.checkBank();
        return this.b.getStatic(this.node);
    }

    public void setStatic(boolean val) {
        this.checkBank();
        this.b.setStatic(this.node, val);
    }

    public boolean getDirty() {
        this.checkBank();
        return this.b.getDirty(this.node);
    }

    public void setDirty(boolean val) {
        this.checkBank();
        this.b.setDirty(this.node, val);
    }
}

