/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain.legacy.heightmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;

public class HeightMap
implements Serializable {
    private static final long serialVersionUID = -3199715473452121495L;
    public static final int ZIGZAG_ROWS = 1;
    public static final int ZIGZAG_COLS = 2;
    public static final int FLIP_STARTING = 4;
    protected float[][] heightmap;

    protected HeightMap() {
    }

    public HeightMap(float[][] heightmap) {
        this.heightmap = heightmap;
    }

    public HeightMap(float[] heights, int nodesPerSide) {
        this.heightmap = new float[nodesPerSide][heights.length / nodesPerSide];
        for (int i = 0; i < heights.length; ++i) {
            this.heightmap[i % nodesPerSide][i / nodesPerSide] = heights[i];
        }
    }

    public String generateUTF() {
        StringWriter sw = new StringWriter();
        try {
            BufferedWriter bw = new BufferedWriter(sw);
            for (int i = 0; i < this.heightmap.length; ++i) {
                for (int j = 0; j < this.heightmap[i].length; ++j) {
                    bw.write((int)Math.abs(this.heightmap[i][j]));
                }
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public BufferedImage generate2D() {
        BufferedImage terrainmap = new BufferedImage(this.heightmap.length, this.heightmap[0].length, 1);
        Graphics2D g = terrainmap.createGraphics();
        for (int i = 0; i < this.heightmap.length; ++i) {
            for (int j = 0; j < this.heightmap[i].length; ++j) {
                int rgb = (int)this.heightmap[i][j] + 128;
                if (rgb < 0) {
                    rgb = 0;
                }
                if (rgb > 255) {
                    rgb = 255;
                }
                g.setColor(new Color(rgb, rgb, rgb));
                g.fillRect(i, j, 1, 1);
            }
        }
        return terrainmap;
    }

    public Geometry generate3D(float startX, float startY, float stepX, float stepY) {
        return this.generate3D(startX, startY, stepX, stepY, 1);
    }

    public IndexedTriangleArray generate3D(float startX, float startY, float stepX, float stepY, int flags) {
        Point3f[][] coords = this.calculateCoords(startX, startY, stepX, stepY);
        Point3f[] verticies = HeightMap.flatten2DArray(coords);
        int[] indices = HeightMap.calculateIndicies(coords.length, coords[0].length, flags);
        IndexedTriangleArray ita = new IndexedTriangleArray(verticies.length, indices.length);
        ita.setCoordinates(0, (Tuple3f[])verticies);
        ita.setIndex(indices);
        ita.setInitialIndexIndex(0);
        ita.calculateFaceNormals();
        ita.setIndex(indices);
        ita.setValidIndexCount(indices.length);
        ita.calculateFaceNormals();
        return ita;
    }

    public Point3f[][] calculateCoords(float startX, float startY, float stepX, float stepY) {
        Point3f[][] pts = new Point3f[this.heightmap.length][this.heightmap[0].length];
        for (int i = 0; i < this.heightmap.length; ++i) {
            for (int j = 0; j < this.heightmap[i].length; ++j) {
                pts[i][j] = new Point3f(startX + stepX * (float)i, startY + stepY * (float)j, this.heightmap[i][j]);
            }
        }
        return pts;
    }

    public static Point3f[] unIndex(Point3f[] vertices, int[] indices) {
        Point3f[] points = new Point3f[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            points[i] = vertices[indices[i]];
        }
        return points;
    }

    public static int[] calculateIndicies(int width, int height, int flags) {
        int[] indices = new int[(width - 1) * (height - 1) * 6];
        int alternate = 0;
        if ((flags & 4) == 4) {
            alternate = 1;
        }
        int indicies = 0;
        for (int i = 0; i < width - 1; ++i) {
            for (int j = 0; j < height - 1; ++j) {
                if (alternate == 0) {
                    indices[indicies++] = HeightMap.flattenCoordinate(i + 1, j, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i, j, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i, j + 1, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i + 1, j + 1, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i + 1, j, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i, j + 1, width);
                } else {
                    indices[indicies++] = HeightMap.flattenCoordinate(i + 1, j + 1, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i, j, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i, j + 1, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i + 1, j + 1, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i + 1, j, width);
                    indices[indicies++] = HeightMap.flattenCoordinate(i, j, width);
                }
                if ((flags & 2) != 2) continue;
                ++alternate;
                alternate %= 2;
            }
            if ((flags & 1) != 1) continue;
            ++alternate;
            alternate %= 2;
        }
        return indices;
    }

    private static int flattenCoordinate(int x, int y, int width) {
        return y * width + x;
    }

    public static Point3f[] flatten2DArray(Point3f[][] vertices) {
        Point3f[] vert2 = new Point3f[vertices.length * vertices[0].length];
        int vertCount = 0;
        for (int i = 0; i < vertices.length; ++i) {
            for (int j = 0; j < vertices[i].length; ++j) {
                vert2[vertCount++] = vertices[i][j];
            }
        }
        return vert2;
    }

    public static float[] point2float(Point3f[] coords) {
        float[] vertices = new float[coords.length * 3];
        int vertex = 0;
        for (int i = 0; i < coords.length; ++i) {
            vertices[vertex++] = coords[i].getX();
            vertices[vertex++] = coords[i].getY();
            vertices[vertex++] = coords[i].getZ();
        }
        return vertices;
    }
}

