/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain.legacy.heightmap;

import java.util.Random;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.terrain.legacy.heightmap.HeightMap;
import org.xith3d.terrain.legacy.heightmap.Terrain;

public class MillerFractal
extends HeightMap
implements Terrain {
    private static final long serialVersionUID = -7931928839066644505L;
    private float roughness;
    private int stride;
    private int size;
    private Random rg;

    public MillerFractal(int powerOfTwo, float startingHeight, float roughness, Random rg) {
        this.size = (int)Math.pow(2.0, powerOfTwo) + 1;
        this.heightmap = new float[this.size][this.size];
        this.heightmap[0][0] = startingHeight;
        this.heightmap[0][this.size - 1] = startingHeight;
        this.heightmap[this.size - 1][0] = startingHeight;
        this.heightmap[this.size - 1][this.size - 1] = startingHeight;
        this.stride = (this.size - 1) / 2;
        this.rg = rg;
        this.roughness = roughness;
        this.generateTerrain();
    }

    public void generateTerrain() {
        while (this.stride >= 1) {
            for (int i = this.stride; i < this.size; i += this.stride * 2) {
                for (int j = this.stride; j < this.size; j += this.stride * 2) {
                    this.calculateDiamondValue(i, j);
                    this.calculateSquareValue(i, j - this.stride);
                    this.calculateSquareValue(i, j + this.stride);
                    this.calculateSquareValue(i - this.stride, j);
                    this.calculateSquareValue(i + this.stride, j);
                }
            }
            this.stride /= 2;
        }
    }

    private float randomNumber() {
        return (this.rg.nextFloat() - 0.5f) * this.roughness;
    }

    private void calculateDiamondValue(int x, int y) {
        this.heightmap[x][y] = (this.heightmap[x - this.stride][y - this.stride] + this.heightmap[x + this.stride][y - this.stride] + this.heightmap[x - this.stride][y + this.stride] + this.heightmap[x + this.stride][y + this.stride]) / 4.0f;
        this.heightmap[x][y] = this.heightmap[x][y] + this.randomNumber();
    }

    private void calculateSquareValue(int x, int y) {
        int yMinus = y - this.stride;
        int yPlus = y + this.stride;
        int xMinus = x - this.stride;
        int xPlus = x + this.stride;
        if (yMinus < 0) {
            yMinus += this.size - 1;
        }
        if (yPlus >= this.size) {
            yPlus -= this.size - 1;
        }
        if (xMinus < 0) {
            xMinus += this.size - 1;
        }
        if (xPlus >= this.size) {
            xPlus -= this.size - 1;
        }
        this.heightmap[x][y] = (this.heightmap[x][yPlus] + this.heightmap[x][yMinus] + this.heightmap[xMinus][y] + this.heightmap[xPlus][y]) / 4.0f;
        this.heightmap[x][y] = this.heightmap[x][y] + this.randomNumber();
    }

    public Geometry generateGeometry(float startX, float startY, float stepX, float stepY) {
        return this.generate3D(startX, startY, stepX, stepY, 0);
    }
}

