/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud;

import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyStateEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.events.MouseButtonClickedEvent;
import org.jagatoo.input.events.MouseButtonEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseStoppedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.listeners.InputListener;
import org.jagatoo.input.listeners.InputStateListener;
import org.xith3d.ui.hud.HUD;

class HUDInputSystemConnection
implements InputListener,
InputStateListener {
    private static final int MOUSE_Y_CORRECTION = -3;
    private final HUD hud;
    long nextAcceptedMouseEventTime = -1L;

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (!this.hud.isVisible()) {
            return;
        }
        if (!e.getMouse().isAbsolute()) {
            return;
        }
        if (System.currentTimeMillis() < this.nextAcceptedMouseEventTime) {
            return;
        }
        this.hud.onMouseButtonPressed(button, e.getX(), e.getY() + -3, e.getWhen(), e.getLastWhen());
    }

    public void onMouseButtonReleased(MouseButtonReleasedEvent e, MouseButton button) {
        if (!this.hud.isVisible()) {
            return;
        }
        if (!e.getMouse().isAbsolute()) {
            return;
        }
        if (System.currentTimeMillis() < this.nextAcceptedMouseEventTime) {
            return;
        }
        this.hud.onMouseButtonReleased(button, e.getX(), e.getY() + -3, e.getWhen(), e.getLastWhen());
    }

    public void onMouseButtonClicked(MouseButtonClickedEvent e, MouseButton button, int clickCount) {
    }

    public void onMouseButtonStateChanged(MouseButtonEvent e, MouseButton button, boolean state) {
    }

    public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
        if (!this.hud.isVisible()) {
            return;
        }
        if (!e.getMouse().isAbsolute()) {
            return;
        }
        if (System.currentTimeMillis() < this.nextAcceptedMouseEventTime) {
            return;
        }
        this.hud.onMouseMoved(x, y + -3, e.getMouse().getButtonsState(), e.getWhen(), e.getLastWhen());
    }

    public long getMouseStopDelay() {
        return 500000000L;
    }

    public void onMouseStopped(MouseStoppedEvent e, int x, int y) {
        if (!this.hud.isVisible()) {
            return;
        }
        if (!e.getMouse().isAbsolute()) {
            return;
        }
        if (System.currentTimeMillis() < this.nextAcceptedMouseEventTime) {
            return;
        }
        this.hud.onMouseStopped(x, y + -3, e.getMouse().getButtonsState(), e.getWhen());
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
        if (!this.hud.isVisible()) {
            return;
        }
        if (!e.getMouse().isAbsolute()) {
            return;
        }
        if (System.currentTimeMillis() < this.nextAcceptedMouseEventTime) {
            return;
        }
        this.hud.onMouseWheelMoved(wheelDelta, e.getMouse().getCurrentX(), e.getMouse().getCurrentY() + -3, e.getWhen(), e.isPageMove());
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        if (!this.hud.isVisible()) {
            return;
        }
        this.hud.onKeyPressed(key, e.getModifierMask(), e.getWhen());
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        if (!this.hud.isVisible()) {
            return;
        }
        this.hud.onKeyReleased(key, e.getModifierMask(), e.getWhen());
    }

    public void onKeyStateChanged(KeyStateEvent e, Key key, boolean state) {
    }

    public void onKeyTyped(KeyTypedEvent e, char keyChar) {
        if (!this.hud.isVisible()) {
            return;
        }
        this.hud.onKeyTyped(keyChar, e.getModifierMask(), e.getWhen());
    }

    public void onControllerButtonPressed(ControllerButtonPressedEvent e, ControllerButton button) {
        if (!this.hud.isVisible()) {
            return;
        }
        this.hud.onControllerButtonPressed(button, e.getWhen());
    }

    public void onControllerButtonReleased(ControllerButtonReleasedEvent e, ControllerButton button) {
        if (!this.hud.isVisible()) {
            return;
        }
        this.hud.onControllerButtonReleased(button, e.getWhen());
    }

    public void onControllerButtonStateChanged(ControllerButtonEvent e, ControllerButton button, boolean state) {
    }

    public void onControllerAxisChanged(ControllerAxisChangedEvent e, ControllerAxis axis, float axisDelta) {
        if (!this.hud.isVisible()) {
            return;
        }
        this.hud.onControllerAxisChanged(axis, axisDelta, e.getWhen());
    }

    public void onInputStateChanged(InputEvent e, DeviceComponent comp, int delta, int state) {
        if (!this.hud.isVisible()) {
            return;
        }
        if (e.getType() == InputEvent.Type.MOUSE_EVENT && System.currentTimeMillis() < this.nextAcceptedMouseEventTime) {
            return;
        }
        this.hud.onInputStateChanged(comp, delta, state, e.getWhen());
    }

    HUDInputSystemConnection(HUD hud) {
        this.hud = hud;
    }
}

