/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.base.AutoSizable;
import org.xith3d.ui.hud.base.StateButton;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LabeledStateButton
extends StateButton
implements TextWidget,
AutoSizable {
    protected static final boolean DEFAULT_HEAVYWEIGHT = false;
    private Description desc;
    private Texture2D buttonTex;
    private Label label;
    private boolean autoSize = false;

    public void setBackgroundColor(Colorf color) {
        this.label.setBackgroundColor(color);
    }

    public final Colorf getBackgroundColor() {
        return this.label.getBackgroundColor();
    }

    public void setBackgroundTexture(Texture2D texture) {
        this.label.setBackgroundTexture(texture);
    }

    public void setBackgroundTexture(String texture) {
        this.label.setBackgroundTexture(texture);
    }

    public final void setBackground(Colorf color, Texture2D texture, TileMode tileMode) {
        this.label.setBackground(color, texture, tileMode);
    }

    public final void setBackground(Colorf color, String texture) {
        this.label.setBackground(color, texture);
    }

    public final void setNoBackground() {
        this.label.setNoBackground();
    }

    public final Texture2D getBackgroundTexture() {
        return this.label.getBackgroundTexture();
    }

    public void setBackgroundTileMode(TileMode mode) {
        this.label.setBackgroundTileMode(mode);
    }

    public final TileMode getBackgroundTileMode() {
        return this.label.getBackgroundTileMode();
    }

    @Override
    public void setText(String text) {
        this.label.setText(text);
    }

    @Override
    public final String getText() {
        return this.label.getText();
    }

    @Override
    public void setAlignment(TextAlignment alignment) {
        this.label.setAlignment(alignment);
    }

    @Override
    public final TextAlignment getAlignment() {
        return this.label.getAlignment();
    }

    @Override
    public void setFont(HUDFont font) {
        this.label.setFont(font);
    }

    @Override
    public final HUDFont getFont() {
        return this.label.getFont();
    }

    public void setFontDisabled(HUDFont font) {
        this.label.setFontDisabled(font);
    }

    public final HUDFont getFontDisabled() {
        return this.label.getFontDisabled();
    }

    @Override
    public void setFontColor(Colorf color) {
        this.label.setFontColor(color);
    }

    @Override
    public final Colorf getFontColor() {
        return this.label.getFontColor();
    }

    public void setFontColorDisabled(Colorf color) {
        this.label.setFontColorDisabled(color);
    }

    public final Colorf getFontColorDisabled() {
        return this.label.getFontColorDisabled();
    }

    @Override
    protected void setEnabledImpl(boolean enabled) {
        this.label.setEnabled(enabled);
    }

    @Override
    protected void onExtendedStateChanged(boolean state, boolean hovered) {
        this.buttonTex = this.desc.getTexture(state, hovered);
        this.setTextureDirty();
    }

    @Override
    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        this.label.setSize(newWidth, newHeight);
    }

    @Override
    public void setAutoSizeEnabled(boolean enabled) {
        this.autoSize = enabled;
    }

    @Override
    public final boolean isAutoSizeEnabled() {
        return this.autoSize;
    }

    @Override
    public final <Dim2f_ extends Dim2f> Dim2f_ getMinimalSize(Dim2f_ buffer) {
        float minWidth = 0.0f;
        float minHeight = 0.0f;
        if (this.buttonTex != null) {
            this.getSizePixels2HUD_(HUDTextureUtils.getTextureWidth(this.buttonTex), HUDTextureUtils.getTextureHeight(this.buttonTex), buffer);
            minWidth += buffer.getWidth();
            minHeight = Math.max(minHeight, buffer.getHeight());
            if (this.label != null) {
                this.getSizePixels2HUD_(this.desc.getSpace(), 0, buffer);
                minWidth += buffer.getWidth();
            }
        }
        if (this.label != null) {
            this.label.getMinimalSize(buffer);
            minWidth += buffer.getWidth();
            minHeight = Math.max(minHeight, buffer.getHeight());
        }
        buffer.set(minWidth, minHeight);
        return buffer;
    }

    @Override
    public final void setMinimalSize() {
        Dim2f newSize = Dim2f.fromPool();
        this.getMinimalSize(newSize);
        this.setSize((Sized2fRO)newSize);
        Dim2f.toPool((Dim2f)newSize);
    }

    @Override
    public final float getMinimalWidth() {
        Dim2f buffer = Dim2f.fromPool();
        this.getMinimalSize(buffer);
        float minWidth = buffer.getWidth();
        Dim2f.toPool((Dim2f)buffer);
        return minWidth;
    }

    @Override
    public final float getMinimalHeight() {
        Dim2f buffer = Dim2f.fromPool();
        this.getMinimalSize(buffer);
        float minHeight = buffer.getHeight();
        Dim2f.toPool((Dim2f)buffer);
        return minHeight;
    }

    protected boolean isMouseOverStateImage(float mouseX, float mouseY) {
        Dim2f buffer2 = Dim2f.fromPool();
        this.getSizePixels2HUD_(HUDTextureUtils.getTextureWidth(this.buttonTex), HUDTextureUtils.getTextureHeight(this.buttonTex), buffer2);
        float iconWidth = buffer2.getWidth();
        float iconHeight = buffer2.getHeight();
        Dim2f.toPool((Dim2f)buffer2);
        float iconTop = (this.getContentHeight() - iconHeight) / 2.0f;
        if (mouseX < 0.0f || 0.0f + iconWidth < mouseX) {
            return false;
        }
        return !(mouseY < iconTop) && !(iconTop + iconHeight < mouseY);
    }

    @Override
    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    @Override
    protected void drawWidgetAfterWidgetAssembler(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        super.drawWidgetAfterWidgetAssembler(texCanvas, offsetX, offsetY, width, height, drawsSelf);
        int y = (height - HUDTextureUtils.getTextureHeight(this.buttonTex)) / 2;
        DrawUtils.drawImage(null, this.buttonTex, null, texCanvas, offsetX, offsetY + y, width, height - y);
    }

    @Override
    protected void initSize() {
        if (this.autoSize) {
            this.setMinimalSize();
        }
    }

    @Override
    protected void init() {
        if (this.label != null) {
            this.getWidgetAssembler().reposition(this.label, 0.0f, 0.0f);
        }
    }

    public LabeledStateButton(boolean isHeavyWeight, float width, float height, String text, Description desc) {
        super(isHeavyWeight, true, Math.max(0.0f, width), Math.max(0.0f, height));
        this.autoSize = width <= 0.0f || height <= 0.0f;
        this.desc = desc.clone();
        this.buttonTex = desc.getTexture(this.getState(), this.isHovered());
        this.label = desc.getLabelDescription() != null && text != null ? new Label(false, Math.max(0.1f, width), Math.max(0.1f, height), text, desc.getLabelDescription()) : new Label(false, Math.max(0.1f, width), Math.max(0.1f, height), "");
        this.getWidgetAssembler().addWidget(this.label, 0.0f, 0.0f);
        this.label.setTextOffset(HUDTextureUtils.getTextureWidth(desc.getTexture(false, false)) + desc.getSpace(), 0);
    }

    public static class Description
    extends Widget.DescriptionBase {
        private Texture2D texDeactivatedNormal;
        private Texture2D texDeactivatedHovered;
        private Texture2D texActivatedNormal;
        private Texture2D texActivatedHovered;
        private int space;
        private Label.Description labelDesc;

        public void setTexture(boolean state, boolean hovered, Texture2D texture) {
            if (state) {
                if (hovered) {
                    this.texActivatedNormal = texture;
                } else {
                    this.texActivatedHovered = texture;
                }
            } else if (hovered) {
                this.texDeactivatedNormal = texture;
            } else {
                this.texDeactivatedHovered = texture;
            }
        }

        public void setTexture(boolean state, boolean hovered, String name) {
            this.setTexture(state, hovered, HUDTextureUtils.getTextureOrNull(name, true));
        }

        public final Texture2D getTexture(boolean state, boolean hovered) {
            if (state) {
                if (hovered) {
                    return this.texActivatedHovered;
                }
                return this.texActivatedNormal;
            }
            if (hovered) {
                return this.texDeactivatedHovered;
            }
            return this.texDeactivatedNormal;
        }

        public void setSpace(int space) {
            this.space = space;
        }

        public final int getSpace() {
            return this.space;
        }

        public void setLabelDescription(Label.Description labelDesc) {
            this.labelDesc = labelDesc;
        }

        public final Label.Description getLabelDescription() {
            return this.labelDesc;
        }

        public void set(Description desc) {
            this.texDeactivatedNormal = desc.texDeactivatedNormal;
            this.texDeactivatedHovered = desc.texDeactivatedHovered;
            this.texActivatedNormal = desc.texActivatedNormal;
            this.texActivatedHovered = desc.texActivatedHovered;
            this.space = desc.space;
            this.labelDesc = desc.labelDesc.clone();
        }

        public Description clone() {
            return new Description(this);
        }

        public Description(Description desc) {
            this.set(desc);
        }

        public Description(Texture2D texDeactivatedNormal, Texture2D texDeactivatedHovered, Texture2D texActivatedNormal, Texture2D texActivatedHovered, int space, Label.Description labelDesc) {
            this.texDeactivatedNormal = texDeactivatedNormal;
            this.texDeactivatedHovered = texDeactivatedHovered;
            this.texActivatedNormal = texActivatedNormal;
            this.texActivatedHovered = texActivatedHovered;
            this.space = space;
            this.labelDesc = labelDesc;
        }

        public Description(String texDeactivatedNormal, String texDeactivatedHovered, String texActivatedNormal, String texActivatedHovered, int space, Label.Description labelDesc) {
            this(HUDTextureUtils.getTexture(texDeactivatedNormal, true), HUDTextureUtils.getTexture(texDeactivatedHovered, true), HUDTextureUtils.getTexture(texActivatedNormal, true), HUDTextureUtils.getTexture(texActivatedHovered, true), space, labelDesc);
        }
    }
}

