/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2i;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector2i;
import org.xith3d.render.ScissorRect;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.__HUD_PrivilegedAccess;
import org.xith3d.ui.hud.base.BackgroundSettableWidget;
import org.xith3d.ui.hud.base.PaddingSettable;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.layout.LayoutManager;
import org.xith3d.ui.hud.utils.HUDPickResult;
import org.xith3d.ui.hud.utils.LocalZIndexComparator;
import org.xith3d.ui.hud.utils.TileMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WidgetContainer
extends BackgroundSettableWidget
implements PaddingSettable {
    private static final LocalZIndexComparator Z_INDEX_COMPARATOR = new LocalZIndexComparator();
    private final GroupNode childrenGroup;
    private Tuple2f resolution = null;
    protected final Vector2f childrenOffset_HUD = new Vector2f(0.0f, 0.0f);
    protected final Vector2i childrenOffset_PX = new Vector2i(0, 0);
    private Window parentWindow = null;
    private final ArrayList<Widget> widgets = new ArrayList();
    private boolean widgetsSorted = true;
    private Boolean hasOverlappingWidgets = null;
    private Widget topMostWidget = null;
    private Widget currentHoveredWidget = null;
    private Widget currentFocusedWidget = null;
    private final ArrayList<HUDPickResult> pickedWidgets = new ArrayList();
    private LayoutManager layoutManager = null;
    private boolean layoutDirty = false;
    private int paddingBottom = 0;
    private int paddingRight = 0;
    private int paddingTop = 0;
    private int paddingLeft = 0;

    protected final GroupNode getSGGroup() {
        return this.childrenGroup;
    }

    void setContentPaneOf(Window window) {
        this.parentWindow = window;
    }

    public final boolean isContentPane() {
        return this.parentWindow != null;
    }

    @Override
    public final Window getParentWindow() {
        if (this.parentWindow != null) {
            return this.parentWindow;
        }
        if (this.getContainer() == null) {
            return null;
        }
        return this.getContainer().getParentWindow();
    }

    protected final float getEqualHeight(float width) {
        float resAspect = this.getResAspect();
        if (resAspect == 0.0f) {
            return 0.0f;
        }
        return width * this.getContentAspect() / resAspect;
    }

    protected final float getEqualWidth(float height) {
        float contentAspect = this.getContentAspect();
        if (contentAspect == 0.0f) {
            return 0.0f;
        }
        return height * this.getResAspect() / contentAspect;
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizePixels2HUD(int w, int h, Dim2f_ buffer) {
        if (this.getContainer() != null) {
            this.getContainer().getSizePixels2HUD(w, h, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getSizePixels2HUD(w, h, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        buffer.scale(this.transformWidth_Pixels2HUD, this.transformHeight_Pixels2HUD);
        return buffer;
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getLocationPixels2HUD(int x, int y, Tuple2f_ buffer) {
        x -= this.getContentLeftPX();
        y -= this.getContentTopPX();
        if (this.getContainer() != null) {
            this.getContainer().getLocationPixels2HUD(x, y, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationPixels2HUD(x, y, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        if (this.getContentWidthPX() == 0) {
            buffer.setX(0.0f);
        } else {
            buffer.subX(this.getLeft());
            buffer.mulX(this.getResX() / this.getContentWidth());
        }
        if (this.getContentHeightPX() == 0) {
            buffer.setY(0.0f);
        } else {
            buffer.subY(this.getTop());
            buffer.mulY(this.getResY() / this.getContentHeight());
        }
        buffer.add(-this.childrenOffset_HUD.getX(), this.childrenOffset_HUD.getY());
        return buffer;
    }

    protected final <Dim2i_ extends Dim2i> Dim2i_ getSizeHUD2Pixels(float w, float h, Dim2i_ buffer) {
        if (this.getHUD() == null) {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        if (this.transformWidth_Pixels2HUD == 0.0f || this.transformHeight_Pixels2HUD == 0.0f) {
            w = 0.0f;
            h = 0.0f;
        } else {
            w /= this.transformWidth_Pixels2HUD;
            h /= this.transformHeight_Pixels2HUD;
        }
        if (this.getContainer() != null) {
            this.getContainer().getSizeHUD2Pixels(w, h, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getSizeHUD2Pixels(w, h, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        return buffer;
    }

    protected final <Tuple2i_ extends Tuple2i> Tuple2i_ getRelLocationHUD2Pixels(float x, float y, Tuple2i_ buffer) {
        x = this.getResX() == 0.0f ? 0.0f : (x *= this.getContentWidth() / this.getResX());
        y = this.getResY() == 0.0f ? 0.0f : (y *= this.getContentHeight() / this.getResY());
        if (this.getContainer() != null) {
            this.getContainer().getRelLocationHUD2Pixels(x, y, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationHUD2Pixels(x, y, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        return buffer;
    }

    protected final <Tuple2i_ extends Tuple2i> Tuple2i_ getLocationHUD2Pixels(float x, float y, Tuple2i_ buffer) {
        if (this.getContainer() != null) {
            this.getContainer().getLocationHUD2Pixels(this.getLeft(), this.getTop(), buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationHUD2Pixels(this.getLeft(), this.getTop(), buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        float left = buffer.getX();
        float top = buffer.getY();
        if (this.getBorder() != null) {
            x += (float)this.getBorder().getLeftWidth();
        }
        x += (float)this.getPaddingLeft();
        x = this.getResX() == 0.0f ? 0.0f : (x *= this.getContentWidth() / this.getResX());
        if (this.getBorder() != null) {
            y += (float)this.getBorder().getTopHeight();
        }
        y += (float)this.getPaddingTop();
        y = this.getResY() == 0.0f ? 0.0f : (y *= this.getContentHeight() / this.getResY());
        Dim2i dim = Dim2i.fromPool();
        if (this.getContainer() != null) {
            this.getContainer().getSizeHUD2Pixels(x, y, dim);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getSizeHUD2Pixels(x, y, dim);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        buffer.set(dim.getWidth(), dim.getHeight());
        Dim2i.toPool((Dim2i)dim);
        buffer.addX((int)left);
        buffer.addY((int)top);
        return buffer;
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizeHUD2SG(float w, float h, Dim2f_ buffer) {
        if (this.getHUD() == null) {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        if (this.transformWidth_Pixels2HUD == 0.0f || this.transformHeight_Pixels2HUD == 0.0f) {
            w = 0.0f;
            h = 0.0f;
        } else {
            w /= this.transformWidth_Pixels2HUD;
            h /= this.transformHeight_Pixels2HUD;
        }
        if (this.getContainer() != null) {
            this.getContainer().getSizeHUD2SG(w, h, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getSizeHUD2SG(w, h, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        return buffer;
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getLocationHUD2SG(float x, float y, Tuple2f_ buffer) {
        x = this.getResX() == 0.0f ? 0.0f : (x *= this.getContentWidth() / this.getResX());
        y = this.getResY() == 0.0f ? 0.0f : (y *= this.getContentHeight() / this.getResY());
        x += this.getLeft();
        y += this.getTop();
        if (this.getBorder() != null) {
            x += (float)this.getBorder().getLeftWidth();
            y += (float)this.getBorder().getTopHeight();
        }
        x += (float)this.getPaddingLeft();
        y += (float)this.getPaddingTop();
        if (this.getContainer() != null) {
            this.getContainer().getLocationHUD2SG(x, y, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationHUD2SG(x, y, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        buffer.subX(((TransformGroup)this.getSGNode()).getTransform().getMatrix4f().m03());
        buffer.subY(((TransformGroup)this.getSGNode()).getTransform().getMatrix4f().m13());
        return buffer;
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizeSG2HUD(float w, float h, Dim2f_ buffer) {
        if (this.getContainer() != null) {
            this.getContainer().getSizeSG2HUD(w, h, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getSizeSG2HUD(w, h, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        if (this.getContentWidthPX() == 0) {
            buffer.setWidth(0.0f);
        } else {
            buffer.scale(this.getResX() / this.getContentWidth(), 1.0f);
        }
        if (this.getContentHeightPX() == 0) {
            buffer.setHeight(0.0f);
        } else {
            buffer.scale(1.0f, this.getResY() / this.getContentHeight());
        }
        return buffer;
    }

    protected final <Tuple2f_ extends Tuple2f> Tuple2f_ getLocationSG2HUD(float x, float y, Tuple2f_ buffer) {
        x += ((TransformGroup)this.getSGNode()).getTransform().getMatrix4f().m03();
        y += ((TransformGroup)this.getSGNode()).getTransform().getMatrix4f().m13();
        if (this.getContainer() != null) {
            this.getContainer().getLocationSG2HUD(x, y, buffer);
        } else if (this.getHUD() != null) {
            this.getHUD().getCoordinatesConverter().getLocationSG2HUD(x, y, buffer);
        } else {
            throw new Error("This method can't be executed on a widget, that is not attached to the HUD.");
        }
        buffer.subX(this.getLeft());
        buffer.subY(this.getTop());
        if (this.getBorder() != null) {
            buffer.subX((float)this.getBorder().getLeftWidth());
            buffer.subY((float)this.getBorder().getTopHeight());
        }
        buffer.subX((float)this.getPaddingLeft());
        buffer.subY((float)this.getPaddingTop());
        if (this.getResX() == 0.0f) {
            buffer.setX(0.0f);
        } else {
            buffer.divX(this.getContentWidth() / this.getResX());
        }
        if (this.getResY() == 0.0f) {
            buffer.setY(0.0f);
        } else {
            buffer.divY(this.getContentHeight() / this.getResY());
        }
        return buffer;
    }

    protected final <Dim2f_ extends Dim2f> Dim2f_ getSizeOfPixels(int x, int y, Dim2f_ buffer) {
        this.getSizeSG2HUD(x, y, buffer);
        return buffer;
    }

    public void setResolution(float resX, float resY) {
        if (resX < 0.0f || resY < 0.0f) {
            if (this.resolution == null) {
                return;
            }
            this.resolution = null;
        }
        if (this.resolution == null) {
            this.resolution = new Tuple2f(resX, resY);
        } else {
            this.resolution.set(resX, resY);
        }
        this.update();
    }

    public final float getResX() {
        if (this.resolution == null) {
            if (this.getHUD() == null) {
                float resX = this.getWidth();
                if (this.getBorder() != null) {
                    resX -= (float)(this.getBorder().getLeftWidth() - this.getBorder().getRightWidth());
                }
                return resX -= (float)(this.getPaddingLeft() + this.getPaddingRight());
            }
            return this.getContentWidth();
        }
        return this.resolution.getX();
    }

    public final float getResY() {
        if (this.resolution == null) {
            if (this.getHUD() == null) {
                float resY = this.getHeight();
                if (this.getBorder() != null) {
                    resY -= (float)(this.getBorder().getTopHeight() - this.getBorder().getBottomHeight());
                }
                return resY -= (float)(this.getPaddingTop() + this.getPaddingBottom());
            }
            return this.getContentHeight();
        }
        return this.resolution.getY();
    }

    public final Tuple2f getResolution() {
        return new Tuple2f(this.getResX(), this.getResY());
    }

    public final float getResAspect() {
        if (this.getResY() == 0.0f) {
            return 0.0f;
        }
        return this.getResX() / this.getResY();
    }

    public final boolean hasCustomResolution() {
        return this.resolution != null;
    }

    @Override
    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        this.layoutDirty = true;
        this.updateLight(true);
    }

    @Override
    public boolean setPadding(int paddingBottom, int paddingRight, int paddingTop, int paddingLeft) {
        if (this.paddingBottom == paddingBottom && this.paddingRight == paddingRight && this.paddingTop == paddingTop && this.paddingLeft == paddingLeft) {
            return false;
        }
        this.paddingBottom = paddingBottom;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingLeft = paddingLeft;
        this.update();
        return true;
    }

    @Override
    public final boolean setPadding(int padding) {
        return this.setPadding(padding, padding, padding, padding);
    }

    @Override
    public final int getPaddingBottom() {
        return this.paddingBottom;
    }

    @Override
    public final int getPaddingRight() {
        return this.paddingRight;
    }

    @Override
    public final int getPaddingTop() {
        return this.paddingTop;
    }

    @Override
    public final int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setLayout(LayoutManager layout) {
        if (this.layoutManager == layout) {
            return;
        }
        if (this.layoutManager != null) {
            this.layoutManager.clear();
        }
        this.layoutManager = layout;
        if (this.layoutManager != null) {
            this.layoutManager.clear();
            for (int i = 0; i < this.widgets.size(); ++i) {
                this.layoutManager.addWidget(this.widgets.get(i), null);
            }
            HUD hud = this.getHUD();
            if (this.layoutManager != null && this.layoutDirty && this.isVisible() && hud != null && hud.isVisible() && hud.isConnected()) {
                this.layoutManager.doLayout(this);
                this.layoutDirty = false;
            } else {
                this.layoutDirty = this.widgets.size() > 0;
            }
        } else {
            this.layoutDirty = false;
        }
    }

    public final LayoutManager getLayout() {
        return this.layoutManager;
    }

    void onChildMovedOrResized(Widget child) {
        this.hasOverlappingWidgets = null;
    }

    final boolean hasOverlappingWidgets() {
        if (this.hasOverlappingWidgets == null) {
            this.hasOverlappingWidgets = Boolean.FALSE;
            for (int i = 0; i < this.widgets.size(); ++i) {
                Widget w0 = this.widgets.get(i);
                for (int j = i + 1; j < this.widgets.size(); ++j) {
                    Widget w1 = this.widgets.get(j);
                    if (w1.getLeft() + w1.getWidth() < w0.getLeft() || w1.getTop() + w1.getHeight() < w0.getTop() || w1.getLeft() > w0.getLeft() + w0.getWidth() || w1.getTop() > w0.getTop() + w0.getHeight()) continue;
                    this.hasOverlappingWidgets = Boolean.TRUE;
                    return true;
                }
            }
        }
        return this.hasOverlappingWidgets;
    }

    protected void setZIndexSortingDirty() {
        this.widgetsSorted = false;
    }

    private void ensureWidgetsSortedByZIndex() {
        if (this.widgetsSorted) {
            return;
        }
        Collections.sort(this.widgets, Z_INDEX_COMPARATOR);
        this.widgetsSorted = true;
    }

    public Widget addWidget(Widget widget, float locX, float locY, int zIndex, Object constraints) {
        if (widget.getContainer() != null || widget.getHUD() != null) {
            throw new Error("This Widget is already added to the HUD.");
        }
        this.widgets.add(widget);
        this.widgetsSorted = false;
        HUD hud = this.getHUD();
        widget.setLocation(locX, locY);
        widget.setZIndex(zIndex);
        widget.setContainer(this, null);
        if (!widget.isHeavyWeight()) {
            widget.setHostWidget(this);
            this.setTextureDirty();
        }
        widget.setHUD(hud);
        if (this.topMostWidget == null || this.topMostWidget.getZIndex() <= widget.getZIndex()) {
            this.topMostWidget = widget;
        }
        if (constraints != LayoutManager.IGNORED_BY_LAYOUT && this.layoutManager != null) {
            this.layoutManager.addWidget(widget, constraints);
            if (this.isVisible() && hud != null && hud.isVisible() && hud.isConnected()) {
                this.layoutManager.doLayout(this);
                this.layoutDirty = false;
            } else {
                this.layoutDirty = true;
            }
        }
        this.hasOverlappingWidgets = null;
        return widget;
    }

    public final Widget addWidget(Widget widget, float locX, float locY, int zIndex) {
        return this.addWidget(widget, locX, locY, zIndex, null);
    }

    public final Widget addWidget(Widget widget, float locX, float locY, Object constraints) {
        return this.addWidget(widget, locX, locY, widget.getZIndex(), constraints);
    }

    public final Widget addWidget(Widget widget, float locX, float locY) {
        return this.addWidget(widget, locX, locY, widget.getZIndex(), null);
    }

    public final Widget addWidget(Widget widget, Object constraints) {
        return this.addWidget(widget, widget.getLeft(), widget.getTop(), widget.getZIndex(), constraints);
    }

    public final Widget addWidget(Widget widget) {
        return this.addWidget(widget, widget.getLeft(), widget.getTop(), widget.getZIndex(), null);
    }

    public final Widget addWidgetCentered(Widget widget, int zIndex) {
        float posUpperLeftY;
        float posUpperLeftX;
        if (this.getHUD() == null && !this.hasCustomResolution()) {
            posUpperLeftX = Math.round((this.getWidth() - widget.getWidth()) / 2.0f);
            posUpperLeftY = Math.round((this.getHeight() - widget.getHeight()) / 2.0f);
        } else {
            posUpperLeftX = Math.round((this.getResX() - widget.getWidth()) / 2.0f);
            posUpperLeftY = Math.round((this.getResY() - widget.getHeight()) / 2.0f);
        }
        return this.addWidget(widget, posUpperLeftX, posUpperLeftY, zIndex);
    }

    public final Widget addWidgetCentered(Widget widget) {
        return this.addWidgetCentered(widget, widget.getZIndex());
    }

    public void removeWidget(Widget widget) {
        if (widget.getContainer() != this) {
            throw new Error("the given Widget is not held in this Container.");
        }
        HUD hud = this.getHUD();
        this.widgets.remove(widget);
        widget.setContainer(null, null);
        widget.setHUD(null);
        widget.setHostWidget(null);
        if (this.topMostWidget == widget) {
            this.topMostWidget = null;
        }
        if (this.layoutManager != null) {
            this.layoutManager.removeWidget(widget);
            if (this.isVisible() && hud != null && hud.isVisible() && hud.isConnected()) {
                this.layoutManager.doLayout(this);
                this.layoutDirty = false;
            } else {
                this.layoutDirty = true;
            }
        }
        this.hasOverlappingWidgets = null;
    }

    public void clear() {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            this.removeWidget(this.widgets.get(i));
        }
    }

    public final int getWidgetsCount() {
        return this.widgets.size();
    }

    public final Widget getWidget(int index) {
        this.ensureWidgetsSortedByZIndex();
        return this.widgets.get(index);
    }

    public final List<Widget> getWidgets() {
        return Collections.unmodifiableList(this.widgets);
    }

    @Override
    protected void onVisibilityChanged(boolean visible) {
        super.onVisibilityChanged(visible);
        if (visible) {
            if (this.layoutManager != null && this.layoutDirty && this.getHUD() != null && this.getHUD().isVisible() && this.getHUD().isConnected()) {
                this.layoutManager.doLayout(this);
                this.layoutDirty = false;
            }
            for (int i = 0; i < this.widgets.size(); ++i) {
                this.widgets.get(i).update();
            }
        }
    }

    @Override
    public void setTransparency(float transparency, boolean childrenToo) {
        super.setTransparency(transparency, childrenToo);
        if (childrenToo) {
            List<Widget> children = this.getWidgets();
            for (int i = 0; i < children.size(); ++i) {
                Widget child = children.get(i);
                if (child instanceof WidgetContainer) {
                    ((WidgetContainer)child).setTransparency(transparency, childrenToo);
                    continue;
                }
                child.setTransparency(transparency);
            }
        }
    }

    @Override
    protected HUDPickResult pick(int canvasX, int canvasY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        int i;
        if (!this.pickConditionsMatch(pickReason)) {
            return null;
        }
        Tuple2f locP = Tuple2f.fromPool();
        this.getLocationPixels2HUD_(canvasX, canvasY, locP);
        float pickXHUD = locP.getX();
        float pickYHUD = locP.getY();
        Tuple2f.toPool((Tuple2f)locP);
        boolean isInternal = (flags & 1) != 0;
        boolean eventsSuppressed = (flags & 2) != 0;
        HUDPickResult thisPick = super.pick(canvasX, canvasY, pickReason, button, when, meta, flags);
        if (thisPick == null) {
            return null;
        }
        HUDPickResult topMost = thisPick;
        HUDPickResult tmpHPR = null;
        this.ensureWidgetsSortedByZIndex();
        this.pickedWidgets.clear();
        for (i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isPickable() || (tmpHPR = widget.pick(canvasX, canvasY, pickReason, button, when, meta, flags)) == null) continue;
            this.pickedWidgets.add(tmpHPR);
            if (topMost == null || topMost.compareTo(tmpHPR) <= 0) {
                topMost = tmpHPR;
            }
            if (!this.hasOverlappingWidgets()) break;
        }
        if (this.currentHoveredWidget != null && this.currentHoveredWidget != topMost.getWidget()) {
            if (this.currentHoveredWidget.getContainer() != null) {
                this.currentHoveredWidget.onMouseExited(true, false);
            }
            this.currentHoveredWidget = null;
        }
        for (i = 0; i < this.pickedWidgets.size(); ++i) {
            HUDPickResult hpr = this.pickedWidgets.get(i);
            Widget pickedWidget = hpr.getWidget();
            boolean isTopMost = pickedWidget == topMost.getWidget();
            boolean hasFocus = pickedWidget == this.currentFocusedWidget;
            float pickXHUD_ = pickXHUD - pickedWidget.getLeft();
            float pickYHUD_ = pickYHUD - pickedWidget.getTop();
            if (isInternal && !eventsSuppressed) {
                switch (pickReason) {
                    case BUTTON_PRESSED: {
                        if (isTopMost && this.currentFocusedWidget != pickedWidget) {
                            this.focus(pickedWidget);
                            hasFocus = true;
                        }
                        pickedWidget.onMouseButtonPressed(button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        break;
                    }
                    case BUTTON_RELEASED: {
                        pickedWidget.onMouseButtonReleased(button, pickXHUD_, pickYHUD_, when, meta, isTopMost, hasFocus);
                        break;
                    }
                    case MOUSE_MOVED: {
                        pickedWidget.onMouseMoved(pickXHUD_, pickYHUD_, (int)meta, when, isTopMost, hasFocus);
                        if (this.currentHoveredWidget != null || !isTopMost) break;
                        this.currentHoveredWidget = pickedWidget;
                        this.currentHoveredWidget.onMouseEntered(isTopMost, hasFocus);
                        break;
                    }
                    case MOUSE_WHEEL_MOVED_UP: {
                        pickedWidget.onMouseWheelMoved(1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                        break;
                    }
                    case MOUSE_WHEEL_MOVED_DOWN: {
                        pickedWidget.onMouseWheelMoved(-1, meta != 0L, pickXHUD_, pickYHUD_, when, isTopMost);
                    }
                }
            }
            if (topMost == hpr || topMost == thisPick) continue;
            HUDPickResult.toPool(hpr);
        }
        this.pickedWidgets.clear();
        if (topMost != thisPick) {
            thisPick.setSubResult(topMost);
        }
        return thisPick;
    }

    public Widget focus(Widget widget) {
        Widget pfw = this.currentFocusedWidget;
        if (this.getContainer() != null) {
            this.getContainer().focus(this);
        } else {
            __HUD_PrivilegedAccess.focus(this.getHUD(), widget);
        }
        if (pfw == widget || !widget.isFocussable()) {
            return pfw;
        }
        if (this.currentFocusedWidget != null && this.currentFocusedWidget.getContainer() != null) {
            this.currentFocusedWidget.onFocusLost();
        }
        this.currentFocusedWidget = widget;
        this.currentFocusedWidget.onFocusGained();
        return pfw;
    }

    public final Widget getCurrentFocusedWidget(boolean getLeaf) {
        Widget cfw = this.currentFocusedWidget;
        if (getLeaf && cfw != null && cfw instanceof WidgetContainer) {
            Widget cfw2 = ((WidgetContainer)cfw).getCurrentFocusedWidget(getLeaf);
            if (cfw2 != null) {
                return cfw2;
            }
            return cfw;
        }
        return cfw;
    }

    public final Widget getCurrentFocusedWidget() {
        return this.currentFocusedWidget;
    }

    public final Widget getCurrentHoveredWidget(boolean getLeaf) {
        Widget chw = this.currentHoveredWidget;
        if (getLeaf && chw != null && chw instanceof WidgetContainer) {
            Widget chw2 = ((WidgetContainer)chw).getCurrentHoveredWidget(getLeaf);
            if (chw2 != null) {
                return chw2;
            }
            return chw;
        }
        return chw;
    }

    protected final Widget getCurrentHoveredWidget() {
        return this.currentHoveredWidget;
    }

    protected final void resetCurrentHoveredWidget() {
        this.currentHoveredWidget = null;
    }

    Widget moveFocus(HUD.FocusMoveDirection direction) {
        if (this.currentFocusedWidget == null) {
            return this.currentFocusedWidget;
        }
        if (this.widgets.size() < 2) {
            return this.currentFocusedWidget;
        }
        float currMidX = this.currentFocusedWidget.getLeft() + this.currentFocusedWidget.getWidth() / 2.0f;
        float currMidY = this.currentFocusedWidget.getTop() + this.currentFocusedWidget.getHeight() / 2.0f;
        float nextMidX = 0.0f;
        float nextMidY = 0.0f;
        Widget nextWidget = null;
        block7: for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isFocussable() || widget == this.currentFocusedWidget) continue;
            switch (direction) {
                case UP: {
                    float midY = widget.getTop() + widget.getHeight() / 2.0f;
                    if (!(midY < currMidY) || nextWidget != null && !(midY > nextMidY)) continue block7;
                    nextWidget = widget;
                    nextMidY = midY;
                    continue block7;
                }
                case LEFT: {
                    float midX = widget.getLeft() + widget.getWidth() / 2.0f;
                    if (!(midX < currMidX) || nextWidget != null && !(midX > nextMidX)) continue block7;
                    nextWidget = widget;
                    nextMidY = midX;
                    continue block7;
                }
                case RIGHT: {
                    float midX = widget.getLeft() + widget.getWidth() / 2.0f;
                    if (!(midX > currMidX) || nextWidget != null && !(midX < nextMidX)) continue block7;
                    nextWidget = widget;
                    nextMidY = midX;
                    continue block7;
                }
                case DOWN: {
                    float midY = widget.getTop() + widget.getHeight() / 2.0f;
                    if (!(midY > currMidY) || nextWidget != null && !(midY < nextMidY)) continue block7;
                    nextWidget = widget;
                    nextMidY = midY;
                    continue block7;
                }
                case NEXT: {
                    float midX = widget.getLeft() + widget.getWidth() / 2.0f;
                    if (midX > currMidX && (nextWidget == null || midX < nextMidX)) {
                        nextWidget = widget;
                        nextMidY = midX;
                    }
                    if (nextWidget != this.currentFocusedWidget) continue block7;
                    currMidX = 0.0f;
                    float midY = widget.getTop() + widget.getHeight() / 2.0f;
                    if (!(midY > currMidY) || nextWidget != null && !(midY < nextMidY)) continue block7;
                    nextWidget = widget;
                    nextMidY = midY;
                    continue block7;
                }
            }
        }
        if (nextWidget != null) {
            nextWidget.requestFocus();
        }
        return nextWidget;
    }

    @Override
    protected void onFocusGained() {
        super.onFocusGained();
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onFocusGained();
        }
    }

    @Override
    protected void onFocusLost() {
        super.onFocusLost();
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onFocusLost();
        }
    }

    private static void forwardOnMouseLeft(Widget widget, boolean isTopMost, boolean hasFocus) {
        if (widget == null) {
            return;
        }
        if (widget instanceof WidgetContainer) {
            WidgetContainer.forwardOnMouseLeft(((WidgetContainer)widget).getCurrentHoveredWidget(), isTopMost, hasFocus);
        }
        widget.onMouseExited(isTopMost, false);
        if (widget instanceof WidgetContainer) {
            ((WidgetContainer)widget).resetCurrentHoveredWidget();
        }
    }

    @Override
    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        WidgetContainer.forwardOnMouseLeft(this.currentHoveredWidget, isTopMost, hasFocus);
        this.resetCurrentHoveredWidget();
        super.onMouseExited(isTopMost, hasFocus);
    }

    @Override
    protected void onKeyPressed(Key key, int modifierMask, long when) {
        super.onKeyPressed(key, modifierMask, when);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onKeyPressed(key, modifierMask, when);
        }
    }

    @Override
    protected void onKeyReleased(Key key, int modifierMask, long when) {
        super.onKeyReleased(key, modifierMask, when);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onKeyReleased(key, modifierMask, when);
        }
    }

    @Override
    protected void onKeyTyped(char ch, int modifierMask, long when) {
        super.onKeyTyped(ch, modifierMask, when);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onKeyTyped(ch, modifierMask, when);
        }
    }

    @Override
    protected void onControllerButtonPressed(ControllerButton button, long when) {
        super.onControllerButtonPressed(button, when);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onControllerButtonPressed(button, when);
        }
    }

    @Override
    protected void onControllerButtonReleased(ControllerButton button, long when) {
        super.onControllerButtonReleased(button, when);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onControllerButtonReleased(button, when);
        }
    }

    @Override
    protected void onControllerAxisChanged(ControllerAxis axis, int axisDelta, long when) {
        super.onControllerAxisChanged(axis, axisDelta, when);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onControllerAxisChanged(axis, axisDelta, when);
        }
    }

    @Override
    protected void onInputStateChanged(DeviceComponent comp, int delta, int state, long when, boolean isTopMost, boolean hasFocus) {
        super.onInputStateChanged(comp, delta, state, when, isTopMost, hasFocus);
        if (this.currentFocusedWidget != null) {
            this.currentFocusedWidget.onInputStateChanged(comp, delta, state, when, isTopMost, hasFocus);
        }
    }

    @Override
    protected void updateAbsZIndex() {
        super.updateAbsZIndex();
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).updateAbsZIndex();
        }
    }

    private final void updateLight(boolean updateChildren) {
        this.updateSizeFactors();
        HUD hud = this.getHUD();
        if (hud != null) {
            Tuple2i loc = Tuple2i.fromPool();
            this.getLocationHUD2Pixels(0.0f, 0.0f, loc);
            loc.setY((int)hud.getHeight() - loc.getY() - this.getContentHeightPX());
            if (this.childrenGroup.getScissorRect() != null) {
                this.childrenGroup.getScissorRect().init(loc.getX(), loc.getY(), this.getContentWidthPX(), this.getContentHeightPX());
            }
            Tuple2i.toPool((Tuple2i)loc);
        }
        if (updateChildren) {
            for (int i = 0; i < this.widgets.size(); ++i) {
                this.widgets.get(i).update();
            }
        }
    }

    public void setClippingEnabled(boolean clippingEnabled) {
        if (clippingEnabled == this.isClippingEnbaled()) {
            return;
        }
        if (clippingEnabled) {
            this.childrenGroup.setScissorRect(new ScissorRect(0, 0, 0, 0));
            this.updateLight(false);
        } else {
            this.childrenGroup.setScissorRect(null);
        }
    }

    public final boolean isClippingEnbaled() {
        return this.childrenGroup.getScissorRect() != null;
    }

    @Override
    protected float calculateTransformWidth_Pixels2HUD(float contentWidth) {
        if (this.hasCustomResolution()) {
            return this.getResX() / contentWidth;
        }
        return super.calculateTransformWidth_Pixels2HUD(contentWidth);
    }

    @Override
    protected float calculateTransformHeight_Pixels2HUD(float contentHeight) {
        if (this.hasCustomResolution()) {
            return this.getResY() / contentHeight;
        }
        return super.calculateTransformHeight_Pixels2HUD(contentHeight);
    }

    @Override
    protected void updateTranslation() {
        super.updateTranslation();
        this.updateLight(false);
    }

    @Override
    public void update() {
        super.update();
        if (this.getHUD() != null && this.layoutManager != null) {
            this.layoutManager.doLayout(this);
            this.layoutDirty = false;
        }
    }

    @Override
    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        if (hud.isVisible()) {
            this.update();
        }
    }

    @Override
    void setHUD(HUD hud) {
        super.setHUD(hud);
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).setHUD(hud);
        }
    }

    @Override
    protected void setWidgetDirty() {
        super.setWidgetDirty();
        this.setHostedWidgetDirty();
        if (this.widgets != null) {
            for (int i = 0; i < this.widgets.size(); ++i) {
                if (this.widgets.get(i).isHeavyWeight()) continue;
                this.widgets.get(i).setWidgetDirty();
            }
        }
    }

    void drawParentBackground(Widget forWidget, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        int ox = 0;
        int oy = 0;
        Dim2i tmp = Dim2i.fromPool();
        this.getSizeHUD2Pixels(forWidget.getLeft(), forWidget.getTop(), tmp);
        Dim2i.toPool((Dim2i)tmp);
        width = this.getWidthPX();
        height = this.getHeightPX();
        this.drawBackground(texCanvas, offsetX -= (ox += tmp.getWidth()), offsetY -= (oy += tmp.getHeight()), width, height);
    }

    protected void drawChildWidgets(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        if (!this.isAHostedWidgetDirty()) {
            return;
        }
        Point2i p = Point2i.fromPool();
        Dim2i d = Dim2i.fromPool();
        this.ensureWidgetsSortedByZIndex();
        offsetX += this.childrenOffset_PX.getX();
        offsetY -= this.childrenOffset_PX.getY();
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (widget.isHeavyWeight() || !widget.isVisible()) continue;
            this.getRelLocationHUD2Pixels_(widget.getLeft(), widget.getTop(), p);
            this.getSizeHUD2Pixels(widget.getWidth(), widget.getHeight(), d);
            widget.drawAndUpdateWidget(texCanvas, offsetX + p.getX(), offsetY + p.getY(), d.getWidth(), d.getHeight(), false);
        }
        Dim2i.toPool((Dim2i)d);
        Point2i.toPool((Point2i)p);
    }

    @Override
    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        this.drawChildWidgets(texCanvas, offsetX, offsetY, width, height, drawsSelf);
    }

    protected GroupNode createChildrenGroup() {
        return new Group();
    }

    protected WidgetContainer(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height, Colorf backgroundColor, Texture2D backgroundTex, TileMode backgroundTileMode) {
        super(isHeavyWeight, hasWidgetAssembler, width, height, backgroundColor, backgroundTex, backgroundTileMode);
        Node.pushGlobalIgnoreBounds(true);
        this.childrenGroup = this.createChildrenGroup();
        Node.popGlobalIgnoreBounds();
        ((TransformGroup)this.getSGNode()).addChild(this.childrenGroup);
        this.childrenGroup.setScissorRect(new ScissorRect(0, 0, 0, 0));
    }
}

