/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.borders;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.Widget;

public class ColoredBorder
extends Border {
    private final Colorf color = new Colorf();

    public void setColor(Colorf color) {
        this.color.set(color);
    }

    public final Colorf getColor() {
        return this.color.getReadOnly();
    }

    public void drawBorder(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, Widget hostWidget) {
        Colorf oldColor = texCanvas.getColorf();
        texCanvas.setColor(this.getColor());
        if (this.getBottomHeight() > 0) {
            texCanvas.fillRect(offsetX, offsetY + height - this.getBottomHeight(), width + 0, this.getBottomHeight() + 0);
        }
        if (this.getRightWidth() > 0) {
            texCanvas.fillRect(offsetX + width - this.getRightWidth(), offsetY + this.getTopHeight(), this.getRightWidth() + 0, height - this.getTopHeight() - this.getBottomHeight() + 0);
        }
        if (this.getTopHeight() > 0) {
            texCanvas.fillRect(offsetX, offsetY, width + 0, this.getTopHeight() + 0);
        }
        if (this.getLeftWidth() > 0) {
            texCanvas.fillRect(offsetX, offsetY + this.getTopHeight(), this.getLeftWidth() + 0, height - this.getTopHeight() - this.getBottomHeight() + 0);
        }
        texCanvas.setColor(oldColor);
    }

    public ColoredBorder(int bottomHeight, int rightWidth, int topHeight, int leftWidth, Colorf color) {
        super(bottomHeight, rightWidth, topHeight, leftWidth);
        if (color == null) {
            throw new NullPointerException("color parameter MUST NOT be null.");
        }
        this.setColor(color);
    }

    public ColoredBorder(int width, Colorf color) {
        this(width, width, width, width, color);
    }
}

