/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.layout;

import java.util.ArrayList;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.layout.LayoutManagerBase;

public class CenterLayout
extends LayoutManagerBase {
    private Orientation orientation;
    private float gap;

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        this.orientation = orientation;
    }

    public final Orientation getOrientation() {
        return this.orientation;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    public final float getGap() {
        return this.gap;
    }

    protected void doLayout(float left0, float top0, float containerResX, float containerResY) {
        block6: {
            float centerY;
            float centerX;
            ArrayList<Widget> widgets;
            block7: {
                widgets = this.getWidgets();
                if (widgets.size() <= 0) break block6;
                centerX = left0 + containerResX / 2.0f;
                centerY = top0 + containerResY / 2.0f;
                if (this.getOrientation() != Orientation.HORIZONTAL) break block7;
                float totalWidth = 0.0f;
                for (int i = 0; i < widgets.size(); ++i) {
                    Widget widget = widgets.get(i);
                    if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                    if (i > 0) {
                        totalWidth += this.getGap();
                    }
                    totalWidth += widget.getWidth();
                }
                float left = centerX - totalWidth / 2.0f;
                for (int i = 0; i < widgets.size(); ++i) {
                    Widget widget = widgets.get(i);
                    if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                    widget.setLocation(left, centerY - widget.getHeight() / 2.0f);
                    left += widget.getWidth() + this.getGap();
                }
                break block6;
            }
            if (this.getOrientation() != Orientation.VERTICAL) break block6;
            float totalHeight = 0.0f;
            for (int i = 0; i < widgets.size(); ++i) {
                Widget widget = widgets.get(i);
                if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                if (i > 0) {
                    totalHeight += this.getGap();
                }
                totalHeight += widget.getHeight();
            }
            float top = centerY - totalHeight / 2.0f;
            for (int i = 0; i < widgets.size(); ++i) {
                Widget widget = widgets.get(i);
                if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                widget.setLocation(centerX - widget.getWidth() / 2.0f, top);
                top += widget.getHeight() + this.getGap();
            }
        }
    }

    public CenterLayout(Orientation orientation, float gap) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("gap must be >= 0");
        }
        this.orientation = orientation;
        this.gap = gap;
    }

    public CenterLayout(Orientation orientation) {
        this(orientation, 0.0f);
    }

    public CenterLayout(float gap) {
        this(Orientation.VERTICAL, gap);
    }

    public CenterLayout() {
        this(Orientation.VERTICAL, 0.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

