/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.layout;

import java.util.ArrayList;
import org.openmali.types.twodee.Dim2f;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.layout.BorderSettableLayoutManagerBase;
import org.xith3d.ui.hud.layout.LayoutManager;

public class HullLayout
extends BorderSettableLayoutManagerBase {
    private final LayoutManager innerLayout;
    private Window window = null;
    private WidgetContainer container = null;
    private boolean stopper = false;

    public final LayoutManager getInnerLayout() {
        return this.innerLayout;
    }

    public void addWidget(Widget widget, Object constraints) {
        super.addWidget(widget, constraints);
        if (this.innerLayout != null) {
            this.innerLayout.addWidget(widget, constraints);
        }
    }

    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        if (this.innerLayout != null) {
            this.innerLayout.removeWidget(widget);
        }
    }

    public void clear() {
        super.clear();
        if (this.innerLayout != null) {
            this.innerLayout.clear();
        }
    }

    protected void doLayout(float left0, float top0, float containerResX, float containerResY) {
        if (this.stopper) {
            return;
        }
        if (this.innerLayout != null) {
            this.innerLayout.doLayout(this.container);
        }
        ArrayList<Widget> widgets = this.getWidgets();
        float leftMost = Float.MAX_VALUE;
        float topMost = Float.MAX_VALUE;
        float rightMost = -3.4028235E38f;
        float bottomMost = -3.4028235E38f;
        int numVisibleWidgets = 0;
        for (int i = 0; i < widgets.size(); ++i) {
            float bottom;
            float right;
            float top;
            Widget widget = widgets.get(i);
            if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
            float left = widget.getLeft();
            if (left < leftMost) {
                leftMost = left;
            }
            if ((top = widget.getTop()) < topMost) {
                topMost = top;
            }
            if ((right = widget.getLeft() + widget.getWidth()) > rightMost) {
                rightMost = right;
            }
            if ((bottom = widget.getTop() + widget.getHeight()) > bottomMost) {
                bottomMost = bottom;
            }
            ++numVisibleWidgets;
        }
        this.stopper = true;
        if (numVisibleWidgets > 0) {
            float deltaLeft = left0 - leftMost;
            float deltaTop = top0 - topMost;
            if (deltaLeft != 0.0f || deltaTop != 0.0f) {
                for (int i = 0; i < widgets.size(); ++i) {
                    Widget widget = widgets.get(i);
                    if (!widget.isVisible() && this.getInvisibleWidgetsHidden()) continue;
                    widget.setLocation(widget.getLeft() + deltaLeft, widget.getTop() + deltaTop);
                }
            }
            float borderWidth = left0 + this.getBorderRight();
            float borderHeight = top0 + this.getBorderBottom();
            Dim2f buffer = Dim2f.fromPool();
            __HUD_base_PrivilegedAccess.getBorderAndPaddingSizeInHUDSpace(this.container, buffer);
            borderWidth += buffer.getWidth();
            borderHeight += buffer.getHeight();
            Dim2f.toPool((Dim2f)buffer);
            if (this.window == null) {
                this.container.setSize(borderWidth + rightMost - leftMost, borderHeight + bottomMost - topMost);
            } else {
                this.window.setContentSize(borderWidth + rightMost - leftMost, borderHeight + bottomMost - topMost);
            }
            if (this.innerLayout != null) {
                this.innerLayout.doLayout(this.container);
            }
        } else if (this.window == null) {
            this.container.setSize(0.0f, 0.0f);
        } else {
            this.window.setContentSize(0.0f, 0.0f);
        }
        this.stopper = false;
    }

    public void doLayout(WidgetContainer container) {
        this.container = container;
        Widget assemlby = __HUD_base_PrivilegedAccess.getAssembly(container);
        this.window = assemlby != null && assemlby instanceof Window ? (Window)assemlby : null;
        super.doLayout(container);
    }

    public HullLayout(LayoutManager innerLayout, float borderBottom, float borderRight, float borderTop, float borderLeft) {
        super(borderBottom, borderRight, borderTop, borderLeft);
        this.innerLayout = innerLayout;
    }

    public HullLayout(float borderBottom, float borderRight, float borderTop, float borderLeft) {
        this(null, borderBottom, borderRight, borderTop, borderLeft);
    }

    public HullLayout(LayoutManager innerLayout, float border) {
        this(innerLayout, border, border, border, border);
    }

    public HullLayout(float border) {
        this(null, border, border, border, border);
    }

    public HullLayout(LayoutManager innerLayout) {
        this(innerLayout, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public HullLayout() {
        this(null);
    }
}

