/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.listmodels;

import java.util.ArrayList;
import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.xith3d.ui.hud.base.LabeledStateButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.listmodels.TextListModel;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Checkbox;
import org.xith3d.ui.hud.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateButtonListModel
extends TextListModel {
    private ArrayList<Boolean> states = null;

    public void setItemState(int itemIndex, boolean state) {
        if (this.states == null) {
            this.states = new ArrayList();
        }
        if (this.states.size() < this.getItemsCount()) {
            for (int i = this.states.size(); i < this.getItemsCount(); ++i) {
                this.states.add(null);
            }
        }
        this.states.set(itemIndex, state);
    }

    public final boolean getItemState(int itemIndex) {
        if (this.states == null || itemIndex >= this.states.size()) {
            return false;
        }
        Boolean state = this.states.get(itemIndex);
        if (state == null) {
            return false;
        }
        return state;
    }

    @Override
    protected void prepareWidgetImpl(float listContentWidth, Widget widget, Object item, int itemIndex) {
        LabeledStateButton sb = (LabeledStateButton)widget;
        if (this.getList() instanceof List) {
            sb.setAlignment(((List)this.getList()).getAlignment());
        }
        Colorf textColor = this.getItemColor(itemIndex);
        HUDFont font = this.getItemFont(itemIndex);
        if (textColor == null) {
            textColor = ((List)this.getList()).getFontColor();
        }
        if (font == null) {
            font = ((List)this.getList()).getFont();
        }
        sb.setFontColor(textColor);
        sb.setFont(font);
        if (this.isSelected(itemIndex) && ((List)this.getList()).getSelectionFontColor() != null) {
            sb.setFontColor(((List)this.getList()).getSelectionFontColor());
        }
        sb.setState(this.getItemState(itemIndex));
        this.applyValueToWidget(item, sb);
    }

    @Override
    public boolean hoverNeedsRedraw() {
        return true;
    }

    @Override
    public boolean checkOnMouseButtonPressedImpl(int itemIndex, float itemTop, float itemBottom, float mouseX, float mouseY) {
        LabeledStateButton sb = (LabeledStateButton)this.getWidgetImpl(itemIndex);
        if (__HUD_base_PrivilegedAccess.isMouseOverStateImage(sb, mouseX, mouseY - itemTop)) {
            this.setItemState(itemIndex, !this.getItemState(itemIndex));
            this.markListDirty();
            return false;
        }
        return true;
    }

    @Override
    protected float getItemHeightImpl(int itemIndex) {
        LabeledStateButton sb = (LabeledStateButton)this.getWidgetImpl(itemIndex);
        this.applyValueToWidget(String.valueOf(this.getItem(itemIndex)), sb);
        Dim2f buffer = Dim2f.fromPool();
        sb.getMinimalSize(buffer);
        float minHeight = buffer.getHeight();
        Dim2f.toPool((Dim2f)buffer);
        return minHeight;
    }

    @Override
    protected float getMinItemWidthImpl(int itemIndex) {
        LabeledStateButton sb = (LabeledStateButton)this.getWidgetImpl(itemIndex);
        this.applyValueToWidget(String.valueOf(this.getItem(itemIndex)), sb);
        Dim2f buffer = Dim2f.fromPool();
        sb.getMinimalSize(buffer);
        float minWidth = buffer.getWidth();
        Dim2f.toPool((Dim2f)buffer);
        return minWidth;
    }

    @Override
    protected LabeledStateButton createWidget() {
        Checkbox checkbox = new Checkbox(100.0f, 16.0f, "StateButton");
        checkbox.setNoBackground();
        return checkbox;
    }

    @Override
    protected void checkWidgetType(Widget widget) {
        if (!(widget instanceof LabeledStateButton)) {
            throw new IllegalArgumentException("The given Widget is not an instanceof LabeledStateButton.");
        }
    }

    public StateButtonListModel(java.util.List<Object> items, LabeledStateButton widget) {
        super(items, widget);
    }

    public StateButtonListModel(java.util.List<Object> items) {
        this(items, null);
    }

    public StateButtonListModel() {
        this(new ArrayList<Object>());
    }
}

