/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.listmodels;

import java.util.ArrayList;
import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listmodels.DefaultAbstractListModel;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextListModel
extends DefaultAbstractListModel {
    private final Widget widget;
    private ArrayList<Colorf> itemColors = null;
    private ArrayList<HUDFont> itemFonts = null;

    @Override
    protected Widget[] getUsedWidgets() {
        return new Widget[]{this.widget};
    }

    @Override
    protected Widget getWidgetImpl(int itemIndex) {
        return this.widget;
    }

    public void setItemColor(int itemIndex, Colorf color) {
        if (this.itemColors == null) {
            if (color == null) {
                return;
            }
            this.itemColors = new ArrayList();
        }
        if (this.itemColors.size() < this.getItemsCount()) {
            for (int i = this.itemColors.size(); i < this.getItemsCount(); ++i) {
                this.itemColors.add(null);
            }
        }
        this.itemColors.set(itemIndex, color);
    }

    public final Colorf getItemColor(int itemIndex) {
        if (this.itemColors == null || itemIndex >= this.itemColors.size()) {
            return null;
        }
        return this.itemColors.get(itemIndex);
    }

    public void setItemFont(int itemIndex, HUDFont font) {
        if (this.itemFonts == null) {
            if (font == null) {
                return;
            }
            this.itemFonts = new ArrayList();
        }
        if (this.itemFonts.size() < this.getItemsCount()) {
            for (int i = this.itemFonts.size(); i < this.getItemsCount(); ++i) {
                this.itemFonts.add(null);
            }
        }
        this.itemFonts.set(itemIndex, font);
    }

    public final HUDFont getItemFont(int itemIndex) {
        if (this.itemFonts == null || itemIndex >= this.itemFonts.size()) {
            return null;
        }
        return this.itemFonts.get(itemIndex);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.itemColors != null) {
            this.itemColors.clear();
        }
        if (this.itemFonts != null) {
            this.itemFonts.clear();
        }
    }

    protected void applyValueToWidget(Object value, TextWidget widget) {
        widget.setText(String.valueOf(value));
    }

    @Override
    protected void prepareWidgetImpl(float listContentWidth, Widget widget, Object item, int itemIndex) {
        Label lbl = (Label)widget;
        if (this.getList() instanceof List) {
            lbl.setAlignment(((List)this.getList()).getAlignment());
        }
        Colorf textColor = this.getItemColor(itemIndex);
        HUDFont font = this.getItemFont(itemIndex);
        if (textColor == null) {
            textColor = ((List)this.getList()).getFontColor();
        }
        if (font == null) {
            font = ((List)this.getList()).getFont();
        }
        lbl.setFontColor(textColor);
        lbl.setFont(font);
        if (this.isSelected(itemIndex) && ((List)this.getList()).getSelectionFontColor() != null) {
            lbl.setFontColor(((List)this.getList()).getSelectionFontColor());
        }
        this.applyValueToWidget(item, lbl);
    }

    @Override
    protected float getItemHeightImpl(int itemIndex) {
        Label lbl = (Label)this.getWidgetImpl(itemIndex);
        this.applyValueToWidget(this.getItem(itemIndex), lbl);
        Dim2f buffer = Dim2f.fromPool();
        lbl.getMinimalSize(buffer);
        float minHeight = buffer.getHeight();
        Dim2f.toPool((Dim2f)buffer);
        return minHeight;
    }

    @Override
    protected float getMinItemWidthImpl(int itemIndex) {
        Label lbl = (Label)this.getWidgetImpl(itemIndex);
        this.applyValueToWidget(this.getItem(itemIndex), lbl);
        Dim2f buffer = Dim2f.fromPool();
        lbl.getMinimalSize(buffer);
        float minWidth = buffer.getWidth();
        Dim2f.toPool((Dim2f)buffer);
        return minWidth;
    }

    protected Widget createWidget() {
        Label label = new Label(100.0f, 16.0f);
        label.setNoBackground();
        return label;
    }

    protected void checkWidgetType(Widget widget) {
    }

    protected TextListModel(java.util.List<Object> items, Widget widget) {
        super(items);
        this.widget = widget == null ? this.createWidget() : widget;
        if (!(this.widget instanceof TextWidget)) {
            throw new IllegalArgumentException("The given Widget is not an instanceof TextWidget.");
        }
        this.checkWidgetType(this.widget);
    }

    public TextListModel(java.util.List<Object> items) {
        this(items, null);
    }

    public TextListModel() {
        this(new ArrayList<Object>());
    }
}

