/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem;

import java.util.HashMap;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.borders.ColoredBorder;
import org.xith3d.ui.hud.layout.BorderLayout;
import org.xith3d.ui.hud.layout.CenterLayout;
import org.xith3d.ui.hud.layout.HullLayout;
import org.xith3d.ui.hud.layout.LayoutManager;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.menusystem.Menu;
import org.xith3d.ui.hud.menusystem.MenuGroup;
import org.xith3d.ui.hud.menusystem.MenuGroupWidget;
import org.xith3d.ui.hud.menusystem.MenuSystem;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.EmptyWidget;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;

public class ButtonsLeftMenusCenterMenuGroupWidget
extends MenuGroupWidget {
    private MenuGroup menuGroup = null;
    private final Panel accessorPanel;
    private final Panel menuPanel;
    private Button saveButton;
    private boolean waitingForSaveButton;
    private Panel westPanel = null;
    private ListLayout.Alignment buttonsAlignment = null;
    private final HashMap<Menu, Widget> menuWrapperMap = new HashMap();
    private final ButtonListener buttonListener = new ButtonListener(){

        public void onButtonClicked(AbstractButton button, Object userObject) {
            if (ButtonsLeftMenusCenterMenuGroupWidget.this.menuGroup != null && ButtonsLeftMenusCenterMenuGroupWidget.this.menuGroup.fireOnMenuActionPerformed((String)userObject)) {
                button.setVisible(false);
            }
        }
    };

    public final WidgetContainer getAccessorPanel() {
        return this.accessorPanel;
    }

    public final WidgetContainer getMenuPanel() {
        return this.menuPanel;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public Button createAccessorWidget(String caption, Button.Description buttonDesc) {
        Button button = buttonDesc == null ? new Button(100.0f, 40.0f, caption) : new Button(100.0f, 40.0f, caption, buttonDesc);
        button.setFocusResponsive(true);
        return button;
    }

    public Button addAccessorWidget(String caption, Button.Description buttonDesc) {
        Button button = this.createAccessorWidget(caption, buttonDesc);
        this.accessorPanel.addWidget(button);
        if (this.accessorPanel.getWidgets().size() == 1) {
            button.requestFocus();
        }
        return button;
    }

    private Widget createMenuWrapper(MenuSystem menuSystem, String caption, Menu menu) {
        ((Widget)((Object)menu)).setBorder(new ColoredBorder(2, menuSystem.getMenuBorderColor()));
        Panel panel = new Panel(0.0f, 0.0f, menuSystem.getMenuBackgroundColor());
        panel.setLayout(new HullLayout(new CenterLayout(CenterLayout.Orientation.VERTICAL), 15.0f));
        panel.setBorder(new ColoredBorder(4, menuSystem.getMenuBorderColor()));
        Label captionLabel = new Label(0.0f, 0.0f, caption, menuSystem.getMenuCaptionFont(), menuSystem.getMenuCaptionFontColor(), TextAlignment.CENTER_CENTER);
        panel.addWidget(captionLabel);
        panel.addWidget(new EmptyWidget(0.0f, 30.0f));
        panel.addWidget((Widget)((Object)menu));
        return panel;
    }

    public void addMenu(MenuSystem menuSystem, String caption, Menu menu) {
        Widget wrapper = this.createMenuWrapper(menuSystem, caption, menu);
        this.menuWrapperMap.put(menu, wrapper);
        wrapper.setVisible(this.menuPanel.getWidgets().size() == 0);
        this.menuPanel.addWidget(wrapper);
    }

    public void setMenuVisible(Menu menu, boolean visible) {
        if (menu == null) {
            return;
        }
        Widget widget = this.menuWrapperMap.get(menu);
        if (widget == null) {
            return;
        }
        widget.setVisible(visible);
    }

    public boolean isMenuVisible(Menu menu) {
        Widget widget = this.menuWrapperMap.get(menu);
        if (widget == null) {
            return false;
        }
        return widget.isVisible();
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.menuGroup = menuGroup;
        if (menuGroup != null && this.waitingForSaveButton) {
            this.saveButton = this.createAccessorWidget("Save", this.getMenuGroup().getMenuSystem().getAccessorDescription());
            this.saveButton.setUserObject("save");
            this.saveButton.setVisible(false);
            if (this.buttonsAlignment.isBottom()) {
                this.westPanel.addWidget(this.saveButton, (Object)BorderLayout.Area.NORTH);
            } else {
                this.westPanel.addWidget(this.saveButton, (Object)BorderLayout.Area.SOUTH);
            }
            this.saveButton.addButtonListener(this.buttonListener);
            this.waitingForSaveButton = false;
            this.westPanel = null;
            this.buttonsAlignment = null;
        }
    }

    public MenuGroup getMenuGroup() {
        return this.menuGroup;
    }

    protected BorderLayout createMainBorderLayout() {
        return new BorderLayout(0.0f, 10.0f);
    }

    protected LayoutManager createWestLayout() {
        return new BorderLayout(50.0f, 0.0f, 50.0f, 50.0f);
    }

    protected LayoutManager createAccessorLayout(ListLayout.Alignment buttonsAlignment, boolean withSaveButton) {
        ListLayout layout = withSaveButton ? new ListLayout(ListLayout.Orientation.VERTICAL, 10.0f) : new ListLayout(ListLayout.Orientation.VERTICAL, 10.0f, 50.0f, 0.0f, 50.0f, 50.0f);
        layout.setAlignment(buttonsAlignment);
        return layout;
    }

    public ButtonsLeftMenusCenterMenuGroupWidget(float width, float height, float resolutionX, float resolutionY, ListLayout.Alignment buttonsAlignment, boolean withSaveButton) {
        super(false, width, height);
        this.setResolution(resolutionX, resolutionY);
        BorderLayout layout = this.createMainBorderLayout();
        this.setLayout(layout);
        if (withSaveButton) {
            Panel westPanel = new Panel(false, 200.0f, height);
            westPanel.setLayout(this.createWestLayout());
            this.accessorPanel = new Panel(false, 0.0f, 0.0f);
            this.accessorPanel.setLayout(this.createAccessorLayout(buttonsAlignment, withSaveButton));
            westPanel.addWidget(this.accessorPanel, (Object)BorderLayout.Area.CENTER);
            this.addWidget(westPanel, (Object)BorderLayout.Area.WEST);
            this.waitingForSaveButton = true;
            this.westPanel = westPanel;
            this.buttonsAlignment = buttonsAlignment;
        } else {
            this.accessorPanel = new Panel(false, 200.0f, height);
            this.accessorPanel.setLayout(this.createAccessorLayout(buttonsAlignment, withSaveButton));
            this.addWidget(this.accessorPanel, (Object)BorderLayout.Area.WEST);
            this.saveButton = null;
            this.waitingForSaveButton = false;
        }
        this.menuPanel = new Panel(false, 0.0f, 0.0f);
        this.menuPanel.setLayout(new CenterLayout());
        this.addWidget(this.menuPanel, (Object)BorderLayout.Area.CENTER);
    }
}

