/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.AbstractInvokableInputAction;
import org.jagatoo.input.actions.InvokableInputAction;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.DigitalDeviceComponent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.menusystem.Menu;
import org.xith3d.ui.hud.menusystem.MenuGroup;
import org.xith3d.ui.hud.menusystem.MenuSystemListener;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;

public class MenuSystem {
    private Button.Description accessorDesc = null;
    private Colorf backgroundColor = Colorf.parseColor((String)"#846D2F");
    private Colorf borderColor = Colorf.DARK_GRAY;
    private HUDFont captionFont = HUDFont.getFont("Baveuse", HUDFont.PLAIN, 24);
    private Colorf captionFontColor = Colorf.ORANGE;
    private final HUD hud;
    private final WidgetContainer parentContainer;
    private final float width;
    private final float height;
    private final int menuZIndex;
    private boolean visible = false;
    private final ArrayList<MenuGroup> menuGroups = new ArrayList();
    private final HashMap<String, MenuGroup> menuGroupsMap = new HashMap();
    private MenuGroup currentMenuGroup = null;
    private final ArrayList<MenuSystemListener> listeners = new ArrayList();
    private DigitalDeviceComponent globalMenuSystemAccessor = null;
    private final InvokableInputAction menuAccessAction = new AbstractInvokableInputAction(0){

        public String invokeAction(InputDevice device, DeviceComponent comp, int delta, int state, long nanoTime) throws InputSystemException {
            if (state == 0) {
                return null;
            }
            if (MenuSystem.this.isVisible()) {
                if (MenuSystem.this.getCurrentMenuGroup() != null && MenuSystem.this.getCurrentMenuGroup().getPreviousMenuGroup() != null) {
                    MenuSystem.this.setCurrentMenuGroup(MenuSystem.this.getCurrentMenuGroup().getPreviousMenuGroup());
                } else {
                    MenuSystem.this.setVisible(false);
                }
            } else {
                MenuSystem.this.setVisible(true);
            }
            return null;
        }
    };

    public void setMenuSystemAccessor(DigitalDeviceComponent accessor) {
        if (this.globalMenuSystemAccessor != null) {
            this.globalMenuSystemAccessor.unbindAction(this.menuAccessAction);
        }
        this.globalMenuSystemAccessor = accessor;
        if (this.globalMenuSystemAccessor != null) {
            this.globalMenuSystemAccessor.bindAction(this.menuAccessAction);
        }
    }

    public final DigitalDeviceComponent getMenuSystemAccessor() {
        return this.globalMenuSystemAccessor;
    }

    public final HUD getHUD() {
        return this.hud;
    }

    public final WidgetContainer getContainer() {
        return this.parentContainer;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final int getMenuZIndex() {
        return this.menuZIndex;
    }

    public void setVisible(boolean visible) {
        boolean wasVisible = this.visible;
        this.visible = visible;
        if (!wasVisible && visible) {
            this.fireOnMenuSystemEntered();
        } else if (wasVisible && !visible) {
            this.fireOnMenuSystemExited();
        }
        if (this.currentMenuGroup != null) {
            this.currentMenuGroup.setVisible(visible);
        }
        if (visible) {
            this.hud.disposeFocus();
            if (this.currentMenuGroup != null) {
                this.currentMenuGroup.getMenuGroupWidget().getAccessorPanel().requestFocus();
            }
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final Colorf getMenuCaptionFontColor() {
        return this.captionFontColor;
    }

    public final void setAccessorDescription(Button.Description desc) {
        this.accessorDesc = desc;
    }

    public final void setMenuBackgroundColor(Colorf color) {
        this.backgroundColor = color;
    }

    public final Colorf getMenuBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setMenuBorderColor(Colorf color) {
        this.borderColor = color;
    }

    public final Colorf getMenuBorderColor() {
        return this.borderColor;
    }

    public final void setMenuCaptionFont(HUDFont font) {
        this.captionFont = font;
    }

    public final HUDFont getMenuCaptionFont() {
        return this.captionFont;
    }

    public final void setMenuCaptionFontColor(Colorf color) {
        this.captionFontColor = color;
    }

    public final Button.Description getAccessorDescription() {
        return this.accessorDesc;
    }

    public void addMenuGroup(MenuGroup group) {
        this.menuGroups.add(group);
        this.menuGroupsMap.put(group.getName(), group);
        if (this.menuGroups.size() == 1) {
            this.setCurrentMenuGroup(group);
        }
        group.init(this);
    }

    public final MenuGroup getMenuGroup(int index) {
        return this.menuGroups.get(index);
    }

    public final MenuGroup getMenuGroup(String name) {
        return this.menuGroupsMap.get(name);
    }

    public final int getMenuGroupsCount() {
        return this.menuGroups.size();
    }

    public void setCurrentMenuGroup(MenuGroup menuGroup) {
        if (menuGroup == null) {
            throw new IllegalArgumentException("menuGroup must not be");
        }
        this.currentMenuGroup = menuGroup;
        for (int i = 0; i < this.menuGroups.size(); ++i) {
            this.menuGroups.get(i).setVisible(false);
        }
        menuGroup.setVisible(this.isVisible());
    }

    public MenuGroup setCurrentMenuGroup(String menuGroupName) {
        MenuGroup menuGroup = this.menuGroupsMap.get(menuGroupName);
        if (menuGroup == null) {
            throw new IllegalArgumentException("MenuGroup \"" + menuGroupName + "\" not found!");
        }
        this.setCurrentMenuGroup(menuGroup);
        return menuGroup;
    }

    public final MenuGroup getCurrentMenuGroup() {
        return this.currentMenuGroup;
    }

    public MenuGroup findMenuGroup(Object menuID) {
        if (menuID == null) {
            return null;
        }
        for (int i = 0; i < this.menuGroups.size(); ++i) {
            MenuGroup mg = this.menuGroups.get(i);
            if (mg.equals(menuID)) {
                return mg;
            }
            if (menuID instanceof NamedObject && mg.getName().equals(menuID)) {
                return mg;
            }
            if (mg.getName().equals(String.valueOf(menuID))) {
                return mg;
            }
            for (int j = 0; j < mg.getMenusCount(); ++j) {
                Menu menu = mg.getMenu(j);
                if (menu.equals(menuID)) {
                    return mg;
                }
                if (menuID instanceof NamedObject && menu.getName().equals(menuID)) {
                    return mg;
                }
                if (!menu.getName().equals(String.valueOf(menuID))) continue;
                return mg;
            }
        }
        return null;
    }

    public Menu findMenu(Object menuID) {
        if (menuID == null) {
            return null;
        }
        for (int i = 0; i < this.menuGroups.size(); ++i) {
            MenuGroup mg = this.menuGroups.get(i);
            for (int j = 0; j < mg.getMenusCount(); ++j) {
                Menu menu = mg.getMenu(j);
                if (menu.equals(menuID)) {
                    return menu;
                }
                if (menu.equals(menuID.toString())) {
                    return menu;
                }
                if (menuID instanceof NamedObject && menu.getName().equals(menuID)) {
                    return menu;
                }
                if (!menu.getName().equals(menuID.toString())) continue;
                return menu;
            }
        }
        return null;
    }

    public final void addMenuSystemListener(MenuSystemListener l) {
        this.listeners.add(l);
    }

    public final void removeMenuSystemListener(MenuSystemListener l) {
        this.listeners.remove(l);
    }

    protected boolean fireBeforeMenuSystemStateChanged(String currentMenu, Object target) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!this.listeners.get(i).beforeMenuStateChanged(this, currentMenu, target)) continue;
            return true;
        }
        return false;
    }

    protected void fireOnMenuSystemStateChanged(String oldMenu, Object target) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onMenuStateChanged(this, oldMenu, target);
        }
    }

    protected void fireOnSettingChanged(Menu menu, String setting, Object value) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onSettingChanged(this, menu, setting, value);
        }
    }

    protected boolean fireOnMenuActionPerformed(MenuGroup menuGroup, Menu menu, String action) {
        boolean consumed = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            consumed = this.listeners.get(i).onMenuActionPerformed(this, menuGroup, menu, action) || consumed;
        }
        return consumed;
    }

    protected void fireOnMenuSystemEntered() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onMenuSystemEntered(this);
        }
    }

    protected void fireOnMenuSystemExited() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onMenuSystemExited(this);
        }
    }

    protected void onOtherMenuRequested(Object menuID) {
        if (menuID == null) {
            this.setVisible(false);
            return;
        }
        MenuGroup currentMG = this.getCurrentMenuGroup();
        Menu currentMenu = currentMG != null ? currentMG.getCurrentActiveMenu() : null;
        MenuGroup mg = this.findMenuGroup(menuID);
        Menu menu = this.findMenu(menuID);
        if (currentMG != mg || currentMenu != menu) {
            if (mg == null && menu == null) {
                if (currentMenu == null && this.fireBeforeMenuSystemStateChanged(currentMG.getName(), menuID)) {
                    return;
                }
                if (currentMenu != null && this.fireBeforeMenuSystemStateChanged(currentMenu.getName(), menuID)) {
                    return;
                }
            } else if (menu == null) {
                if (currentMenu != mg.getCurrentActiveMenu()) {
                    if (currentMenu == null && this.fireBeforeMenuSystemStateChanged(currentMG.getName(), mg.getName())) {
                        return;
                    }
                    if (currentMenu != null && this.fireBeforeMenuSystemStateChanged(currentMenu.getName(), mg.getName())) {
                        return;
                    }
                }
            } else if (currentMenu != menu) {
                if (currentMenu == null && this.fireBeforeMenuSystemStateChanged(currentMG.getName(), menu.getName())) {
                    return;
                }
                if (currentMenu != null && this.fireBeforeMenuSystemStateChanged(currentMenu.getName(), menu.getName())) {
                    return;
                }
            }
        }
        if (mg == null) {
            if (currentMenu == null) {
                this.fireOnMenuSystemStateChanged(currentMG.getName(), menuID);
            } else {
                this.fireOnMenuSystemStateChanged(currentMenu.getName(), menuID);
            }
        } else if (currentMG != mg || currentMenu != menu) {
            if (menu == null) {
                currentMG.setCurrentActiveMenu(null);
                mg.setCurrentActiveMenu(null);
                this.setCurrentMenuGroup(mg);
                if (currentMenu != mg.getCurrentActiveMenu()) {
                    if (currentMenu == null) {
                        this.fireOnMenuSystemStateChanged(currentMG.getName(), mg.getName());
                    } else {
                        this.fireOnMenuSystemStateChanged(currentMenu.getName(), mg.getName());
                    }
                }
            } else {
                currentMG.setCurrentActiveMenu(null);
                mg.setCurrentActiveMenu(menu);
                this.setCurrentMenuGroup(mg);
                if (currentMenu != menu) {
                    if (currentMenu == null) {
                        this.fireOnMenuSystemStateChanged(currentMG.getName(), menu.getName());
                    } else {
                        this.fireOnMenuSystemStateChanged(currentMenu.getName(), menu.getName());
                    }
                }
            }
        }
    }

    public MenuSystem(HUD hud, WidgetContainer parentContainer, float width, float height, int menuZIndex) {
        if (hud == null || parentContainer == null) {
            throw new IllegalArgumentException("Neither hud nor parentContainer must be null");
        }
        this.hud = hud;
        this.parentContainer = parentContainer;
        this.width = width;
        this.height = height;
        this.menuZIndex = menuZIndex;
    }

    public MenuSystem(HUD hud, float width, float height, int menuZIndex) {
        this(hud, hud.getContentPane(), width, height, menuZIndex);
    }

    public MenuSystem(HUD hud, float width, float height) {
        this(hud, hud.getContentPane(), width, height, 1000);
    }

    public MenuSystem(HUD hud) {
        this(hud, hud.getContentPane(), hud.getResX(), hud.getResY(), 1000);
    }
}

