/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem.menus;

import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.layout.BorderSettableLayoutManager;
import org.xith3d.ui.hud.menusystem.Menu;
import org.xith3d.ui.hud.menusystem.MenuGroup;
import org.xith3d.ui.hud.menusystem.MenuSystem;
import org.xith3d.ui.hud.widgets.Panel;

public abstract class MenuBase
extends Panel
implements Menu {
    private final String[] acceptedActions;
    protected boolean minimalHeightSet = false;
    private MenuSystem menuSystem = null;
    private MenuGroup menuGroup = null;

    protected final String[] getAcceptedActions() {
        return this.acceptedActions;
    }

    public void setMenuSystem(MenuSystem menuSystem) {
        this.menuSystem = menuSystem;
    }

    public final MenuSystem getMenuSystem() {
        return this.menuSystem;
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.menuGroup = menuGroup;
    }

    public final MenuGroup getMenuGroup() {
        return this.menuGroup;
    }

    public boolean prepareAction(String action) {
        for (int i = 0; i < this.acceptedActions.length; ++i) {
            if (!action.equals(this.acceptedActions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean onActionConsumed(String action) {
        for (int i = 0; i < this.acceptedActions.length; ++i) {
            if (!action.equals(this.acceptedActions[i])) continue;
            return true;
        }
        return false;
    }

    public void setMinimalHeight() {
        if (!this.isInitialized() && !this.isInitializing()) {
            this.minimalHeightSet = true;
            return;
        }
        this.getContainer().update();
        float borderHeight = this.getBorder() != null ? (float)(this.getBorder().getTopHeight() + this.getBorder().getBottomHeight()) : 0.0f;
        float paddingHeight = this.getLayout() != null && this.getLayout() instanceof BorderSettableLayoutManager ? ((BorderSettableLayoutManager)((Object)this.getLayout())).getBorderBottom() : 0.0f;
        Widget lastWidget = this.getWidgets().get(this.getWidgets().size() - 1);
        this.setSize(this.getWidth(), lastWidget.getTop() + lastWidget.getHeight() + borderHeight + paddingHeight);
    }

    protected abstract void initWidgets();

    protected void init() {
        super.init();
        this.initWidgets();
        if (this.minimalHeightSet) {
            this.minimalHeightSet = false;
            this.setMinimalHeight();
        }
    }

    public MenuBase(float width, float height, String name, String[] acceptedActions) {
        super(false, width, height);
        this.setName(name);
        this.acceptedActions = acceptedActions;
    }

    public MenuBase(float width, String name, String[] acceptedActions) {
        this(width, 0.0f, name, acceptedActions);
        this.setMinimalHeight();
    }
}

