/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem.menus.settings;

import java.util.HashMap;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.ui.hud.base.AbstractList;
import org.xith3d.ui.hud.base.StateButton;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.WidgetEventsReceiverAdapter;
import org.xith3d.ui.hud.menusystem.menus.MenuBase;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Checkbox;
import org.xith3d.ui.hud.widgets.ComboBox;
import org.xith3d.ui.hud.widgets.EmptyWidget;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

public class GraphicsMainSettingsMenu
extends MenuBase {
    public static final String NAME = GraphicsMainSettingsMenu.class.getSimpleName();
    private final Label openGLLayerCaption;
    private final ComboBox openGLLayer;
    private final Label displayModeCaption;
    private final ComboBox displayMode;
    private final Label fsaaCaption;
    private final ComboBox fsaa;
    private final Checkbox vsync;
    private final Checkbox fullscreen;
    private final HashMap<String, DisplayMode> displayModeMap = new HashMap();
    private final HashMap<OpenGLLayer, DisplayMode[]> openGLLayerDisplayModesMap = new HashMap();
    private final WidgetEventsReceiverAdapter eventsHandler = new WidgetEventsReceiverAdapter(){

        public void onListSelectionChanged(AbstractList list, Object oldSelectedItem, Object newSelectedItem, int oldSelectedIndex, int newSelectedIndex) {
            if (list == GraphicsMainSettingsMenu.this.openGLLayer) {
                DisplayMode oldDisplayMode = (DisplayMode)GraphicsMainSettingsMenu.this.displayModeMap.get(String.valueOf(oldSelectedItem) + "-" + GraphicsMainSettingsMenu.this.displayMode.getSelectedItem());
                OpenGLLayer ogl = (OpenGLLayer)newSelectedItem;
                GraphicsMainSettingsMenu.this.refillDisplayModes(oldDisplayMode, ogl);
                GraphicsMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(GraphicsMainSettingsMenu.this, "OpenGLLayer", GraphicsMainSettingsMenu.this.getOpenGLLayer());
            } else if (list == GraphicsMainSettingsMenu.this.displayMode) {
                GraphicsMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(GraphicsMainSettingsMenu.this, "DisplayMode", GraphicsMainSettingsMenu.this.getDisplayMode());
            } else if (list == GraphicsMainSettingsMenu.this.fsaa) {
                GraphicsMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(GraphicsMainSettingsMenu.this, "FSAA", (Object)GraphicsMainSettingsMenu.this.getFSAA());
            }
        }

        public void onButtonStateChanged(StateButton stateButton, boolean state, Object userObject) {
            if (stateButton == GraphicsMainSettingsMenu.this.vsync) {
                GraphicsMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(GraphicsMainSettingsMenu.this, "vsync", GraphicsMainSettingsMenu.this.getVSync());
            } else if (stateButton == GraphicsMainSettingsMenu.this.fullscreen) {
                GraphicsMainSettingsMenu.this.getMenuGroup().fireOnSettingChanged(GraphicsMainSettingsMenu.this, "fullscreenMode", (Object)GraphicsMainSettingsMenu.this.getFullscreenMode());
            }
        }
    };

    private final void refillDisplayModes(DisplayMode oldDisplayMode, OpenGLLayer openGLLayer) {
        this.displayMode.removeSelectionListener(this.eventsHandler);
        this.displayMode.clear();
        this.displayMode.addItems(this.openGLLayerDisplayModesMap.get(openGLLayer));
        DisplayModeSelector dspModeSelector = DisplayModeSelector.getImplementation(openGLLayer);
        int found = 0;
        int selIndex = 0;
        block5: for (int i = 0; i < this.displayMode.getItemsCount(); ++i) {
            String[] modeParts = this.displayMode.getItem(i).toString().split("x");
            int width = Integer.parseInt(modeParts[0]);
            int height = Integer.parseInt(modeParts[1]);
            int bpp = modeParts[2].equals("?") ? 24 : Integer.parseInt(modeParts[2]);
            int freq = modeParts[3].equals("?") ? 75 : Integer.parseInt(modeParts[3]);
            switch (found) {
                case 0: {
                    DisplayMode dm0 = dspModeSelector.getBestMode(width, height);
                    if (dm0.getWidth() != oldDisplayMode.getWidth() || dm0.getHeight() != oldDisplayMode.getHeight()) continue block5;
                    selIndex = i;
                    found = 1;
                    continue block5;
                }
                case 1: {
                    DisplayMode dm1 = dspModeSelector.getBestMode(width, height, bpp);
                    if (dm1.getWidth() != oldDisplayMode.getWidth() || dm1.getHeight() != oldDisplayMode.getHeight() || dm1.getBPP() != oldDisplayMode.getBPP()) continue block5;
                    selIndex = i;
                    found = 2;
                    continue block5;
                }
                case 2: {
                    DisplayMode dm2 = dspModeSelector.getBestMode(width, height, bpp, freq);
                    if (dm2.getWidth() != oldDisplayMode.getWidth() || dm2.getHeight() != oldDisplayMode.getHeight() || dm2.getBPP() != oldDisplayMode.getBPP() || dm2.getFrequency() != oldDisplayMode.getFrequency()) continue block5;
                    selIndex = i;
                    continue block5;
                }
            }
        }
        this.displayMode.addSelectionListener(this.eventsHandler);
        if (this.displayMode.getItemsCount() > 0) {
            this.displayMode.setSelectedIndex(selIndex);
        }
    }

    public void setOpenGLLayer(OpenGLLayer openGLLayer) {
        OpenGLLayer oldOpenGLLayer = this.getOpenGLLayer();
        DisplayMode oldDisplayMode = this.getDisplayMode();
        if (openGLLayer != oldOpenGLLayer) {
            this.openGLLayer.setSelectedIndex(this.openGLLayer.findItem(openGLLayer));
            this.refillDisplayModes(oldDisplayMode, openGLLayer);
        }
    }

    public final OpenGLLayer getOpenGLLayer() {
        return (OpenGLLayer)this.openGLLayer.getSelectedItem();
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode.setSelectedIndex(this.displayMode.findItem(displayMode.toLightString()));
    }

    public final DisplayMode getDisplayMode() {
        return this.displayModeMap.get(this.displayMode.getSelectedItem().toString());
    }

    public void setFSAA(FSAA fsaa) {
        this.fsaa.setSelectedIndex(this.fsaa.findItem((Object)fsaa));
    }

    public final FSAA getFSAA() {
        return (FSAA)((Object)this.fsaa.getSelectedItem());
    }

    public void setVSync(boolean vsync) {
        this.vsync.setState(vsync);
    }

    public final boolean getVSync() {
        return this.vsync.getState();
    }

    public void setFullscreenMode(DisplayMode.FullscreenMode fullscreen) {
        this.fullscreen.setState(fullscreen.isFullscreen());
    }

    public final DisplayMode.FullscreenMode getFullscreenMode() {
        return this.fullscreen.getState() ? DisplayMode.FullscreenMode.FULLSCREEN : DisplayMode.FullscreenMode.WINDOWED;
    }

    public void applyConfig(CanvasConstructionInfo canvasInfo) {
        this.setOpenGLLayer(canvasInfo.getOpenGLLayer());
        this.setDisplayMode(canvasInfo.getDisplayMode());
        this.setFSAA(canvasInfo.getFSAAMode());
        this.setVSync(canvasInfo.isVSyncEnabled());
        this.setFullscreenMode(canvasInfo.getFullscreenMode());
    }

    public void extractConfig(CanvasConstructionInfo canvasInfo) {
        canvasInfo.setOpenGLLayer(this.getOpenGLLayer());
        canvasInfo.setDisplayMode(this.getDisplayMode());
        canvasInfo.setFSAAMode(this.getFSAA());
        canvasInfo.setVSyncEnabled(this.getVSync());
        canvasInfo.setFullscreenMode(this.getFullscreenMode());
    }

    protected float getPickHeight() {
        return this.getHeight() + 100.0f;
    }

    protected void initWidgets() {
        this.addWidget(this.openGLLayerCaption);
        this.addWidget(this.openGLLayer);
        this.addWidget(new EmptyWidget(0.0f, 10.0f));
        this.addWidget(this.displayModeCaption);
        this.addWidget(this.displayMode);
        this.addWidget(new EmptyWidget(0.0f, 10.0f));
        this.addWidget(this.fsaaCaption);
        this.addWidget(this.fsaa);
        this.addWidget(new EmptyWidget(0.0f, 10.0f));
        this.addWidget(this.vsync);
        this.addWidget(new EmptyWidget(0.0f, 10.0f));
        this.addWidget(this.fullscreen);
    }

    private final ComboBox createDisplayModeCombo(OpenGLLayer oglLayer) {
        OpenGLLayer[] ogls;
        ComboBox cb = ComboBox.newTextCombo(0.0f, 20.0f);
        for (OpenGLLayer ogl : ogls = new OpenGLLayer[]{OpenGLLayer.JOGL_AWT, OpenGLLayer.LWJGL}) {
            DisplayMode[] displayModes;
            for (DisplayMode displayMode : displayModes = DisplayModeSelector.getImplementation(ogl).getAvailableModes()) {
                this.displayModeMap.put(ogl.toString() + "-" + displayMode.toLightString(), displayMode);
                if (ogl != oglLayer) continue;
                cb.addItem(displayMode);
            }
            this.openGLLayerDisplayModesMap.put(ogl, displayModes);
        }
        return cb;
    }

    public GraphicsMainSettingsMenu(float width, float height) {
        super(width, height, NAME, new String[]{"save"});
        ListLayout layout = new ListLayout(ListLayout.Orientation.VERTICAL, 2.0f, 10.0f, 10.0f, 10.0f, 10.0f);
        layout.setAlignment(ListLayout.Alignment.CENTER_TOP);
        layout.setOtherSpanCalculated(true);
        this.setLayout(layout);
        HUDFont font = HUDFont.getFont("Verdana", HUDFont.PLAIN, 12);
        OpenGLLayer defaultOGL = OpenGLLayer.JOGL_AWT;
        this.openGLLayerCaption = new Label(0.0f, 0.0f, "OpenGLLayer", font, TextAlignment.BOTTOM_LEFT);
        this.openGLLayer = ComboBox.newTextCombo(0.0f, 20.0f);
        this.openGLLayer.addItem(OpenGLLayer.JOGL_AWT);
        this.openGLLayer.addItem(OpenGLLayer.LWJGL);
        this.displayModeCaption = new Label(0.0f, 0.0f, "Display-Mode", font, TextAlignment.BOTTOM_LEFT);
        this.displayMode = this.createDisplayModeCombo(defaultOGL);
        this.fsaaCaption = new Label(0.0f, 0.0f, "Full Scene Anti-Aliasing", font, TextAlignment.BOTTOM_LEFT);
        this.fsaa = ComboBox.newTextCombo(0.0f, 20.0f);
        this.fsaa.addItem((Object)FSAA.OFF);
        this.fsaa.addItem((Object)FSAA.ON_2X);
        this.fsaa.addItem((Object)FSAA.ON_4X);
        this.fsaa.addItem((Object)FSAA.ON_8X);
        this.fsaa.addItem((Object)FSAA.ON_16X);
        this.vsync = new Checkbox(0.0f, 0.0f, "Vertical-Sync", font, null);
        this.fullscreen = new Checkbox(0.0f, 0.0f, "Fullscreen", font, null);
        this.openGLLayer.setSelectedIndex(0);
        this.displayMode.setSelectedIndex(0);
        this.fsaa.setSelectedIndex(0);
        this.vsync.setState(true);
        this.fullscreen.setState(true);
        this.openGLLayer.addSelectionListener(this.eventsHandler);
        this.displayMode.addSelectionListener(this.eventsHandler);
        this.fsaa.addSelectionListener(this.eventsHandler);
        this.vsync.addStateListener(this.eventsHandler);
        this.fullscreen.addStateListener(this.eventsHandler);
    }

    public GraphicsMainSettingsMenu(float width) {
        this(width, 0.0f);
        this.setMinimalHeight();
    }
}

