/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.openmali.vecmath2.Tuple2f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.WidgetMouseAdapter;
import org.xith3d.ui.hud.utils.WidgetMover;

public class MouseHoverWidgetMover
extends WidgetMover {
    private InputSlave inputSlave = new InputSlave();
    private Interval enteredDelayInterval = null;
    private Interval leftDelayInterval = null;
    private boolean isBlocked = false;

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setMouseEnteredDelay(long delay) {
        if (delay <= 0L) {
            this.enteredDelayInterval = null;
            return;
        }
        if (this.enteredDelayInterval == null) {
            this.enteredDelayInterval = new Interval(delay);
        } else {
            this.enteredDelayInterval.setInterval(delay);
        }
        this.enteredDelayInterval.kill();
    }

    public long getMouseEnteredDelay() {
        if (this.enteredDelayInterval == null) {
            return 0L;
        }
        return this.enteredDelayInterval.getInterval();
    }

    public void setMouseLeftDelay(long delay) {
        if (delay <= 0L) {
            this.leftDelayInterval = null;
            return;
        }
        if (this.leftDelayInterval == null) {
            this.leftDelayInterval = new Interval(delay);
        } else {
            this.leftDelayInterval.setInterval(delay);
        }
        this.leftDelayInterval.kill();
    }

    public long getMouseLeftDelay() {
        if (this.leftDelayInterval == null) {
            return 0L;
        }
        return this.leftDelayInterval.getInterval();
    }

    protected void onMouseEntered() {
        if (this.isBlocked()) {
            return;
        }
        if (this.leftDelayInterval != null && this.leftDelayInterval.isAlive()) {
            this.leftDelayInterval.kill();
            return;
        }
        if (this.isMoving()) {
            this.invert();
        } else if (this.enteredDelayInterval != null) {
            this.getWidget().getHUD().getOperationScheduler().addInterval(this.enteredDelayInterval);
        } else {
            this.startMoving();
        }
    }

    protected void onMouseLeft() {
        if (this.isBlocked()) {
            return;
        }
        if (this.enteredDelayInterval != null && this.enteredDelayInterval.isAlive()) {
            this.enteredDelayInterval.kill();
            return;
        }
        if (this.isMoving()) {
            this.invert();
        } else if (this.leftDelayInterval != null) {
            this.getWidget().getHUD().getOperationScheduler().addInterval(this.leftDelayInterval);
        } else {
            this.startMoving();
        }
    }

    protected void onMovementStopped() {
        super.onMovementStopped();
        this.setDestinationLocation(this.getStartLocationX(), this.getStartLocationY());
    }

    public MouseHoverWidgetMover(Widget widget, float destX, float destY, float speed) {
        super(widget, destX, destY, speed);
        widget.addMouseListener(this.inputSlave);
    }

    public MouseHoverWidgetMover(Widget widget, Tuple2f destLocation, float speed) {
        this(widget, destLocation.getX(), destLocation.getY(), speed);
    }

    public MouseHoverWidgetMover(Widget widget) {
        this(widget, widget.getLeft(), widget.getTop(), 0.0f);
    }

    private class InputSlave
    extends WidgetMouseAdapter
    implements IntervalListener {
        private boolean intervalListenerOnceSet = false;

        private InputSlave() {
        }

        public void onMouseEntered(Widget widget, boolean isTopMost, boolean hasFocus) {
            if (!this.intervalListenerOnceSet) {
                widget.getHUD().getOperationScheduler().addIntervalListener(this);
                this.intervalListenerOnceSet = true;
            }
            MouseHoverWidgetMover.this.onMouseEntered();
        }

        public void onMouseExited(Widget widget, boolean isTopMost, boolean hasFocus) {
            if (!this.intervalListenerOnceSet) {
                widget.getHUD().getOperationScheduler().addIntervalListener(this);
                this.intervalListenerOnceSet = true;
            }
            MouseHoverWidgetMover.this.onMouseLeft();
        }

        public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            if (interval == MouseHoverWidgetMover.this.enteredDelayInterval) {
                interval.kill();
                MouseHoverWidgetMover.this.startMoving();
            } else if (interval == MouseHoverWidgetMover.this.leftDelayInterval) {
                interval.kill();
                MouseHoverWidgetMover.this.startMoving();
            }
        }
    }
}

