/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends AbstractButton
implements TextWidget {
    protected static final boolean DEFAULT_HEAVYWEIGHT = false;
    private int leftWidth;
    private int rightWidth;
    private int topHeight;
    private int bottomHeight;
    private Texture2D texNormal;
    private Texture2D texHovered;
    private Texture2D texPressed;
    private final Label caption;

    public void setTextureNormal(Texture2D texture) {
        if (texture == null) {
            throw new IllegalArgumentException("NORMAL texture must not be null.");
        }
        this.texNormal = texture;
        if (this.getButtonState() == AbstractButton.ButtonState.NORMAL) {
            this.setTextureDirty();
        }
    }

    public final void setTextureNormal(String resource) {
        this.setTextureNormal(HUDTextureUtils.getTexture(resource, true));
    }

    public final Texture2D getTextureNormal() {
        return this.texNormal;
    }

    public void setTextureHovered(Texture2D texture) {
        this.texHovered = texture;
        if (this.getButtonState() == AbstractButton.ButtonState.HOVERED) {
            this.setTextureDirty();
        }
    }

    public final void setTextureHovered(String resource) {
        this.setTextureHovered(HUDTextureUtils.getTexture(resource, true));
    }

    public final Texture2D getTextureHovered() {
        return this.texHovered;
    }

    public void setTexturePressed(Texture2D texture) {
        this.texPressed = texture;
        if (this.getButtonState() == AbstractButton.ButtonState.PRESSED) {
            this.setTextureDirty();
        }
    }

    public final void setTexturePressed(String resource) {
        this.setTexturePressed(HUDTextureUtils.getTexture(resource, true));
    }

    public final Texture2D getTexturePressed() {
        return this.texPressed;
    }

    protected Texture2D getCurrentTexture() {
        if (this.isFocusResponsive() && this.getTextureHovered() != null && this.hasFocus(true)) {
            return this.getTextureHovered();
        }
        if (this.getButtonState() == AbstractButton.ButtonState.HOVERED && this.getTextureHovered() != null) {
            return this.getTextureHovered();
        }
        if (this.getButtonState() == AbstractButton.ButtonState.PRESSED && this.getTexturePressed() != null) {
            return this.getTexturePressed();
        }
        return this.getTextureNormal();
    }

    @Override
    protected void onFocusGained() {
        super.onFocusGained();
        if (this.isFocusResponsive() && this.hasFocus(true) && this.getButtonState() != AbstractButton.ButtonState.HOVERED) {
            this.setTextureDirty();
        }
    }

    @Override
    protected void onFocusLost() {
        super.onFocusLost();
        if (this.isFocusResponsive() && this.hasFocus(true) && this.getButtonState() != AbstractButton.ButtonState.HOVERED) {
            this.setTextureDirty();
        }
    }

    @Override
    public void update() {
        super.update();
        this.setTextureDirty();
    }

    @Override
    public boolean setButtonState(AbstractButton.ButtonState buttonState) {
        boolean result = super.setButtonState(buttonState);
        if (!result) {
            return false;
        }
        if (this.caption != null) {
            if (this.getButtonState() == AbstractButton.ButtonState.PRESSED) {
                this.caption.setTextOffset(1, 1);
            } else {
                this.caption.setTextOffset(0, 0);
            }
        }
        this.setTextureDirty();
        return true;
    }

    @Override
    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        if (this.caption != null) {
            this.caption.setSize(newWidth, newHeight);
        }
    }

    public final boolean hasText() {
        return this.caption != null;
    }

    @Override
    public void setText(String text) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setText(text);
    }

    @Override
    public final String getText() {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getText();
    }

    @Override
    public void setFont(HUDFont font) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setFont(font);
    }

    @Override
    public final HUDFont getFont() {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getFont();
    }

    @Override
    public void setFontColor(Colorf color) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setFontColor(color);
    }

    @Override
    public final Colorf getFontColor() {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getFontColor();
    }

    @Override
    public void setAlignment(TextAlignment align) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setAlignment(align);
    }

    @Override
    public final TextAlignment getAlignment() {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getAlignment();
    }

    public void setIcon(Texture2D icon) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setIcon(icon);
    }

    public void setIcon(String icon) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setIcon(icon);
    }

    public final Texture2D getIcon() {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        return this.caption.getIcon();
    }

    public void setIconGap(int gap) {
        if (this.caption == null) {
            throw new Error("This Button doesn't have a text.");
        }
        this.caption.setIconGap(gap);
    }

    public final int getIconGap() {
        if (this.caption == null) {
            return 0;
        }
        return this.caption.getIconGap();
    }

    @Override
    protected void setEnabledImpl(boolean enabled) {
        if (this.caption != null) {
            this.caption.setEnabled(enabled);
        }
    }

    @Override
    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        Texture2D btex = this.getCurrentTexture();
        TextureImage2D btexImg = btex.getImage0();
        int srcOrgW = HUDTextureUtils.getTextureWidth(btex);
        int srcOrgH = HUDTextureUtils.getTextureHeight(btex);
        int srcBottomH = this.bottomHeight;
        int srcRightW = this.rightWidth;
        int srcTopH = this.topHeight;
        int srcLeftW = this.leftWidth;
        int srcRightLeft = srcOrgW - srcRightW;
        int srcBottomTop = srcOrgH - srcBottomH;
        int trgRightLeft = width - srcRightW;
        int trgBottomTop = height - srcBottomH;
        int srcBodyWidth = srcOrgW - srcLeftW - srcRightW;
        int srcBodyHeight = srcOrgH - srcTopH - srcBottomH;
        int trgBodyWidth = width - srcLeftW - srcRightW;
        int trgBodyHeight = height - srcTopH - srcBottomH;
        TextureImage2D ti = texCanvas.getImage();
        if (drawsSelf) {
            ti.clear(offsetX, offsetY, width, height, true, null);
        }
        if (srcLeftW > 0 && srcBottomH > 0) {
            ti.drawImage(btexImg, 0, srcBottomTop, srcLeftW, srcBottomH, offsetX + 0, offsetY + trgBottomTop, true, null);
        }
        if (srcRightW > 0 && srcBottomH > 0) {
            ti.drawImage(btexImg, srcRightLeft, srcBottomTop, srcRightW, srcBottomH, offsetX + trgRightLeft, offsetY + trgBottomTop, true, null);
        }
        if (srcRightW > 0 && srcTopH > 0) {
            ti.drawImage(btexImg, srcRightLeft, 0, srcRightW, srcTopH, offsetX + trgRightLeft, offsetY, true, null);
        }
        if (srcLeftW > 0 && srcTopH > 0) {
            ti.drawImage(btexImg, 0, 0, srcLeftW, srcTopH, offsetX, offsetY, true, null);
        }
        if (srcBottomH > 0) {
            ti.drawImage(btexImg, srcLeftW, srcBottomTop, srcOrgW - srcLeftW - srcRightW, srcBottomH, offsetX + srcLeftW, offsetY + trgBottomTop, trgBodyWidth, srcBottomH, true, null);
        }
        if (srcRightW > 0) {
            ti.drawImage(btexImg, srcRightLeft, srcTopH, srcRightW, srcOrgH - srcTopH - srcBottomH, offsetX + trgRightLeft, offsetY + srcTopH, srcRightW, trgBodyHeight, true, null);
        }
        if (srcTopH > 0) {
            ti.drawImage(btexImg, srcLeftW, 0, srcOrgW - srcLeftW - srcRightW, srcTopH, offsetX + srcLeftW, offsetY, trgBodyWidth, srcTopH, true, null);
        }
        if (srcLeftW > 0) {
            ti.drawImage(btexImg, 0, srcTopH, srcLeftW, srcOrgH - srcTopH - srcBottomH, offsetX, offsetY + srcTopH, srcLeftW, trgBodyHeight, true, null);
        }
        texCanvas.drawImage(btexImg.getBufferedImage(), offsetX + srcLeftW, offsetY + trgBottomTop, offsetX + trgRightLeft, offsetY + srcTopH, srcLeftW, srcTopH, srcBodyWidth, srcBodyHeight);
    }

    @Override
    public <Dim2f_ extends Dim2f> Dim2f_ getOptimalSize(Dim2f_ buffer) {
        return this.caption.getMinimalSize(buffer);
    }

    @Override
    public String toString() {
        if (this.getText() == null) {
            return this.getClass().getSimpleName() + "( texture: \"" + this.getTextureNormal().getName() + "\" )";
        }
        return super.toString();
    }

    @Override
    protected void init() {
    }

    protected Label createCaptionWidget(String text, Label.Description labelDesc) {
        Label label = new Label(false, this.getWidth(), this.getHeight(), text, labelDesc);
        label.setNoBackground();
        label.setPickable(false);
        label.setClickable(false);
        return new Label(false, this.getWidth(), this.getHeight(), text, labelDesc);
    }

    public Button(boolean isHeavyWeight, float width, float height, String text, Description desc) {
        super(isHeavyWeight, true, width, height);
        this.bottomHeight = desc.getBottomHeight();
        this.rightWidth = desc.getRightWidth();
        this.topHeight = desc.getTopHeight();
        this.leftWidth = desc.getLeftWidth();
        this.texNormal = desc.getTextureNormal();
        this.texHovered = desc.getTextureHovered();
        this.texPressed = desc.getTexturePressed();
        if (text != null) {
            this.caption = this.createCaptionWidget(text, desc.getLabelDescription());
            this.getWidgetAssembler().addWidget(this.caption);
        } else {
            this.caption = null;
        }
    }

    public Button(boolean isHeavyWeight, float width, float height, String text) {
        this(isHeavyWeight, width, height, text, HUD.getTheme().getButtonDescription());
    }

    protected static Description deriveDesc(HUDFont font, Colorf color) {
        Description desc = HUD.getTheme().getButtonDescription();
        if (font != null) {
            desc.getLabelDescription().setFont(font, false);
        }
        if (color != null) {
            desc.getLabelDescription().setFontColor(color, false);
        }
        return desc;
    }

    public Button(boolean isHeavyWeight, float width, float height, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, Button.deriveDesc(font, color));
    }

    public Button(boolean isHeavyWeight, float width, float height, String text, HUDFont font) {
        this(isHeavyWeight, width, height, text, Button.deriveDesc(font, null));
    }

    public Button(boolean isHeavyWeight, float width, float height, String text, Colorf color) {
        this(isHeavyWeight, width, height, text, Button.deriveDesc(null, color));
    }

    public Button(float width, float height, String text, Description desc) {
        this(false, width, height, text, desc);
    }

    public Button(float width, float height, String text) {
        this(false, width, height, text);
    }

    public Button(float width, float height, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, font, color);
    }

    public Button(float width, float height, String text, HUDFont font) {
        this(false, width, height, text, font);
    }

    public Button(float width, float height, String text, Colorf color) {
        this(false, width, height, text, color);
    }

    protected static Description createImageButtonDesc(Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture, HUDFont font, Colorf color) {
        Description desc = new Description(0, 0, 0, 0, normalTexture, hoveredTexture, pressedTexture, font, color);
        if (font != null) {
            desc.getLabelDescription().setFont(font, false);
        }
        if (color != null) {
            desc.getLabelDescription().setFontColor(color, false);
        }
        return desc;
    }

    protected static Description createImageButtonDesc(String normalTexture, String hoveredTexture, String pressedTexture, HUDFont font, Colorf color) {
        Description desc = new Description(0, 0, 0, 0, normalTexture, hoveredTexture, pressedTexture, font, color);
        if (font != null) {
            desc.getLabelDescription().setFont(font, false);
        }
        if (color != null) {
            desc.getLabelDescription().setFontColor(color, false);
        }
        return desc;
    }

    public Button(boolean isHeavyWeight, float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, Button.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public Button(boolean isHeavyWeight, float width, float height, String normalTexture, String hoveredTexture, String pressedTexture, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, Button.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public Button(boolean isHeavyWeight, float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture) {
        this(isHeavyWeight, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public Button(boolean isHeavyWeight, float width, float height, String normalTexture, String hoveredTexture, String pressedTexture) {
        this(isHeavyWeight, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public Button(float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, Button.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public Button(float width, float height, String normalTexture, String hoveredTexture, String pressedTexture, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, Button.createImageButtonDesc(normalTexture, hoveredTexture, pressedTexture, font, color));
    }

    public Button(float width, float height, Texture2D normalTexture, Texture2D hoveredTexture, Texture2D pressedTexture) {
        this(false, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public Button(float width, float height, String normalTexture, String hoveredTexture, String pressedTexture) {
        this(false, width, height, normalTexture, hoveredTexture, pressedTexture, null, null, null);
    }

    public static class Description
    extends Widget.DescriptionBase {
        private int leftWidth;
        private int rightWidth;
        private int topHeight;
        private int bottomHeight;
        private Texture2D texNormal;
        private Texture2D texHovered;
        private Texture2D texPressed;
        private Label.Description labelDesc;

        public void setBottomHeight(int bh) {
            this.bottomHeight = bh;
        }

        public final int getBottomHeight() {
            return this.bottomHeight;
        }

        public void setRightWidth(int rw) {
            this.rightWidth = rw;
        }

        public final int getRightWidth() {
            return this.rightWidth;
        }

        public void setTopHeight(int th) {
            this.topHeight = th;
        }

        public final int getTopHeight() {
            return this.topHeight;
        }

        public void setLeftWidth(int lw) {
            this.leftWidth = lw;
        }

        public final int getLeftWidth() {
            return this.leftWidth;
        }

        public void setTextureNormal(Texture2D texture) {
            if (texture == null) {
                throw new IllegalArgumentException("NORMAL texture must not be null.");
            }
            this.texNormal = texture;
        }

        public final void setTextureNormal(String texture) {
            if (texture == null) {
                this.setTextureNormal((Texture2D)null);
            } else {
                this.setTextureNormal(HUDTextureUtils.getTexture(texture, true));
            }
        }

        public final Texture2D getTextureNormal() {
            return this.texNormal;
        }

        public void setTextureHovered(Texture2D texture) {
            this.texHovered = texture;
        }

        public final void setTextureHovered(String texture) {
            if (texture == null) {
                this.setTextureHovered((Texture2D)null);
            } else {
                this.setTextureHovered(HUDTextureUtils.getTexture(texture, true));
            }
        }

        public final Texture2D getTextureHovered() {
            return this.texHovered;
        }

        public void setTexturePressed(Texture2D texture) {
            this.texPressed = texture;
        }

        public final void setTexturePressed(String texture) {
            if (texture == null) {
                this.setTexturePressed((Texture2D)null);
            } else {
                this.setTexturePressed(HUDTextureUtils.getTexture(texture, true));
            }
        }

        public final Texture2D getTexturePressed() {
            return this.texPressed;
        }

        public void setLabelDescription(Label.Description labelDesc) {
            this.labelDesc = labelDesc;
        }

        public final Label.Description getLabelDescription() {
            return this.labelDesc;
        }

        public void set(Description desc) {
            this.leftWidth = desc.leftWidth;
            this.rightWidth = desc.rightWidth;
            this.topHeight = desc.topHeight;
            this.bottomHeight = desc.bottomHeight;
            this.texNormal = desc.texNormal;
            this.texHovered = desc.texHovered;
            this.texPressed = desc.texPressed;
            this.labelDesc = desc.labelDesc.clone();
        }

        public Description clone() {
            return new Description(this);
        }

        private Description(Description desc) {
            this.set(desc);
        }

        public Description(int bottom, int right, int top, int left, Texture2D texNormal, Texture2D texHovered, Texture2D texPressed) {
            this.bottomHeight = Math.max(0, bottom);
            this.rightWidth = Math.max(0, right);
            this.topHeight = Math.max(0, top);
            this.leftWidth = Math.max(0, left);
            this.setTextureNormal(texNormal);
            this.setTextureHovered(texHovered);
            this.setTexturePressed(texPressed);
            this.labelDesc = HUD.getTheme().getLabelDescription();
        }

        public Description(int bottom, int right, int top, int left, String texNormal, String texHovered, String texPressed) {
            this(bottom, right, top, left, HUDTextureUtils.getTextureOrNull(texNormal, true), HUDTextureUtils.getTextureOrNull(texHovered, true), HUDTextureUtils.getTextureOrNull(texPressed, true));
        }

        public Description() {
            HUD.getTheme().getButtonDescription(this);
        }

        public Description(Texture2D texNormal, Texture2D texHovered, Texture2D texPressed) {
            this();
            this.setTextureNormal(texNormal);
            this.setTextureHovered(texHovered);
            this.setTexturePressed(texPressed);
        }

        public Description(String texNormal, String texHovered, String texPressed) {
            this();
            this.setTextureNormal(texNormal);
            this.setTextureHovered(texHovered);
            this.setTexturePressed(texPressed);
        }

        public Description(int bottom, int right, int top, int left, Texture2D texNormal, Texture2D texHovered, Texture2D texPressed, HUDFont font, Colorf fontColor) {
            this(bottom, right, top, left, texNormal, texHovered, texPressed);
            this.labelDesc.setFont(font, false);
            this.labelDesc.setFont(font != null ? Label.Description.deriveDisabledFont(font) : font, true);
            this.labelDesc.setFontColor(fontColor, false);
            this.labelDesc.setFontColor(HUD.getTheme().getLabelDescription().getFontColor(true), true);
            this.labelDesc.setAlignment(TextAlignment.CENTER_CENTER);
        }

        public Description(int bottom, int right, int top, int left, String texNormal, String texHovered, String texPressed, HUDFont font, Colorf fontColor) {
            this(bottom, right, top, left, HUDTextureUtils.getTextureOrNull(texNormal, true), HUDTextureUtils.getTextureOrNull(texHovered, true), HUDTextureUtils.getTextureOrNull(texPressed, true), font, fontColor);
        }
    }
}

