/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.util.image.ImageUtility;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AutoSizable;
import org.xith3d.ui.hud.base.BackgroundSettableWidget;
import org.xith3d.ui.hud.base.PaddingSettable;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.MultilineText;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
extends BackgroundSettableWidget
implements TextWidget,
PaddingSettable,
Enableable,
AutoSizable {
    protected static final boolean DEFAULT_HEAVYWEIGHT = false;
    private boolean autoSize = false;
    private int paddingBottom = 0;
    private int paddingRight = 0;
    private int paddingTop = 0;
    private int paddingLeft = 0;
    private int textOffsetX = 0;
    private int textOffsetY = 0;
    private TextAlignment alignment;
    private String text;
    private final MultilineText multiLineText = new MultilineText();
    private HUDFont font;
    private HUDFont font_disabled;
    private Colorf fontColor;
    private Colorf fontColor_disabled;
    private Texture2D icon = null;
    private int iconGap = 2;
    private boolean enabled = true;
    private static Texture2D textImage = null;
    private static Texture2DCanvas textGraphics = null;

    @Override
    public boolean setPadding(int paddingBottom, int paddingRight, int paddingTop, int paddingLeft) {
        if (this.paddingBottom == paddingBottom && this.paddingRight == paddingRight && this.paddingTop == paddingTop && this.paddingLeft == paddingLeft) {
            return false;
        }
        this.paddingBottom = paddingBottom;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingLeft = paddingLeft;
        this.multiLineText.setPositionDirty();
        this.updateSizeFactors();
        this.setTextureDirty();
        return true;
    }

    @Override
    public final boolean setPadding(int padding) {
        return this.setPadding(padding, padding, padding, padding);
    }

    @Override
    public final int getPaddingBottom() {
        return this.paddingBottom;
    }

    @Override
    public final int getPaddingRight() {
        return this.paddingRight;
    }

    @Override
    public final int getPaddingTop() {
        return this.paddingTop;
    }

    @Override
    public final int getPaddingLeft() {
        return this.paddingLeft;
    }

    @Override
    public void setAutoSizeEnabled(boolean enabled) {
        this.autoSize = enabled;
    }

    @Override
    public final boolean isAutoSizeEnabled() {
        return this.autoSize;
    }

    protected void updateText() {
        if (this.autoSize && this.isInitialized() && this.getHUD() != null) {
            this.setMinimalSize();
        }
        this.setTextureDirty();
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text must not be null");
        }
        if (this.text == null || !this.text.equals(text)) {
            this.text = text;
            this.updateText();
            this.multiLineText.setText(this.getDisplayedText());
        }
    }

    public void setText(String prefix, float value, char decimalSep, int decPlaces, String postfix) {
        String text;
        if (decimalSep == '\u0000' || decPlaces <= 0) {
            text = String.valueOf((int)value);
        } else if (decimalSep == '.') {
            float p = (float)Math.pow(10.0, decPlaces);
            text = String.valueOf((float)((int)(value * p)) / p);
        } else {
            float p = (float)Math.pow(10.0, decPlaces);
            text = String.valueOf((int)value) + decimalSep + String.valueOf((int)((value - (float)((int)value)) * p));
        }
        if (prefix == null || prefix.length() == 0) {
            if (postfix == null || postfix.length() == 0) {
                this.setText(text);
            } else {
                this.setText(text + postfix);
            }
        } else if (postfix == null || postfix.length() == 0) {
            this.setText(prefix + text);
        } else {
            this.setText(prefix + text + postfix);
        }
    }

    public final void setText(float value) {
        this.setText(null, value, '.', 2, null);
    }

    @Override
    public String getText() {
        return this.text;
    }

    protected String getDisplayedText() {
        return this.getText();
    }

    @Override
    public void setAlignment(TextAlignment alignment) {
        if (this.alignment != alignment) {
            this.alignment = alignment;
            this.multiLineText.setPositionDirty();
            this.setTextureDirty();
        }
    }

    @Override
    public TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public void setFont(HUDFont font) {
        this.font = font;
        if (this.isEnabled()) {
            this.multiLineText.setPositionDirty();
            this.setTextureDirty();
        }
    }

    @Override
    public final HUDFont getFont() {
        return this.font;
    }

    public void setFontDisabled(HUDFont font) {
        this.font_disabled = font;
        if (!this.isEnabled()) {
            this.multiLineText.setPositionDirty();
            this.setTextureDirty();
        }
    }

    public final HUDFont getFontDisabled() {
        return this.font_disabled;
    }

    protected HUDFont getFont(boolean disabled) {
        if (disabled) {
            return this.getFontDisabled();
        }
        return this.getFont();
    }

    @Override
    public void setFontColor(Colorf color) {
        if (!this.fontColor.equals(color)) {
            this.fontColor = color;
            if (this.isEnabled()) {
                this.setTextureDirty();
            }
        }
    }

    @Override
    public final Colorf getFontColor() {
        return this.fontColor.getReadOnly();
    }

    public void setFontColorDisabled(Colorf color) {
        if (!this.fontColor_disabled.equals(color)) {
            this.fontColor_disabled = color;
            if (!this.isEnabled()) {
                this.setTextureDirty();
            }
        }
    }

    public final Colorf getFontColorDisabled() {
        return this.fontColor_disabled.getReadOnly();
    }

    protected Colorf getFontColor(boolean disabled) {
        if (disabled) {
            return this.getFontColorDisabled();
        }
        return this.getFontColor();
    }

    public void setIcon(Texture2D icon) {
        if (this.icon == icon) {
            return;
        }
        this.icon = icon;
        this.setTextureDirty();
    }

    public final void setIcon(String icon) {
        this.setIcon(HUDTextureUtils.getTextureOrNull(icon, true));
    }

    public final Texture2D getIcon() {
        return this.icon;
    }

    public void setIconGap(int gap) {
        if (this.iconGap == gap) {
            return;
        }
        this.iconGap = gap;
        this.setTextureDirty();
    }

    public final int getIconGap() {
        return this.iconGap;
    }

    protected void setEnabledImpl(boolean enabled) {
        this.setTextureDirty();
    }

    public final void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        this.setEnabledImpl(enabled);
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        this.multiLineText.setPositionDirty();
        if (this.getHUD() != null) {
            this.updateTranslation();
        }
    }

    @Override
    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
    }

    @Override
    public <Dim2f_ extends Dim2f> Dim2f_ getMinimalSize(Dim2f_ buffer) {
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        if (this.multiLineText.getNumLines() > 1 || this.multiLineText.getNumLines() == 1 && this.multiLineText.getLine(0).length() > 0) {
            HUDFont fnt = this.isEnabled() ? this.font : this.font_disabled;
            FontMetrics metrics = fnt.getFontMetrics(this.getHUD());
            for (int i = 0; i < this.multiLineText.getNumLines(); ++i) {
                Rectangle2D bounds = metrics.getStringBounds(this.multiLineText.getLine(i), null);
                totalWidth = Math.max(totalWidth, bounds.getWidth());
                totalHeight += bounds.getHeight();
            }
            if (this.getIcon() != null) {
                totalWidth += (double)this.getIconGap();
            }
        }
        if (this.getIcon() != null) {
            totalWidth += (double)HUDTextureUtils.getTextureWidth(this.getIcon());
            totalHeight = Math.max(totalHeight, (double)HUDTextureUtils.getTextureHeight(this.getIcon()));
        }
        totalWidth += (double)(this.getPaddingLeft() + this.getPaddingRight());
        totalHeight += (double)(this.getPaddingTop() + this.getPaddingBottom());
        if (this.getBorder() != null) {
            totalWidth += (double)(this.getBorder().getLeftWidth() + this.getBorder().getRightWidth());
            totalHeight += (double)(this.getBorder().getTopHeight() + this.getBorder().getBottomHeight());
        }
        if (this.getHUD() != null) {
            this.getSizePixels2HUD_((int)totalWidth, (int)totalHeight, buffer);
        } else {
            buffer.set((float)((int)totalWidth), (float)((int)totalHeight));
        }
        return buffer;
    }

    @Override
    public final void setMinimalSize() {
        Dim2f newSize = Dim2f.fromPool();
        this.getMinimalSize(newSize);
        this.setSize((Sized2fRO)newSize);
        Dim2f.toPool((Dim2f)newSize);
    }

    @Override
    public final float getMinimalWidth() {
        Dim2f buffer = Dim2f.fromPool();
        this.getMinimalSize(buffer);
        float minWidth = buffer.getWidth();
        Dim2f.toPool((Dim2f)buffer);
        return minWidth;
    }

    @Override
    public final float getMinimalHeight() {
        Dim2f buffer = Dim2f.fromPool();
        this.getMinimalSize(buffer);
        float minHeight = buffer.getHeight();
        Dim2f.toPool((Dim2f)buffer);
        return minHeight;
    }

    public void setTextOffset(int textOffsetX, int textOffsetY) {
        if (textOffsetX == this.textOffsetX && textOffsetY == this.textOffsetY) {
            return;
        }
        this.textOffsetX = textOffsetX;
        this.textOffsetY = textOffsetY;
        this.setTextureDirty();
    }

    public int getTextOffsetX() {
        return this.textOffsetX;
    }

    public int getTextOffsetY() {
        return this.textOffsetY;
    }

    protected void prepareText(MultilineText multiLineText, Texture2DCanvas texCanvas, int width, int height) {
        if (this.isEnabled()) {
            texCanvas.setColor(this.getFontColor());
            texCanvas.setFont(this.getFont().getAWTFont(this.getHUD()));
        } else {
            texCanvas.setColor(this.getFontColorDisabled());
            texCanvas.setFont(this.getFontDisabled().getAWTFont(this.getHUD()));
        }
        int padLeft = this.getContentLeftPX();
        int padTop = this.getContentTopPX();
        Dim2i tmp = Dim2i.fromPool();
        this.getSizeHUD2Pixels_(this.getWidth(), this.getHeight(), tmp);
        int padRight = tmp.getWidth() - this.getContentLeftPX() - this.getContentWidthPX();
        int padBottom = tmp.getHeight() - this.getContentTopPX() - this.getContentHeightPX();
        Dim2i.toPool((Dim2i)tmp);
        multiLineText.update(texCanvas, width, height, padLeft, padRight, padTop, padBottom, this.getAlignment());
    }

    protected void drawIcon(Texture2D icon, Texture2DCanvas texCanvas, int x, int y) {
        DrawUtils.drawImage(null, icon, null, texCanvas, x, y, HUDTextureUtils.getTextureWidth(icon), HUDTextureUtils.getTextureHeight(icon));
    }

    protected void drawText(MultilineText multiLineText, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        offsetX += this.getTextOffsetX();
        offsetY += this.getTextOffsetY();
        int textX0 = multiLineText.getMinPosX();
        int textY0 = multiLineText.getPosY(0) + multiLineText.getLineOffsetY(0);
        int textTotalWidth = multiLineText.getTotalWidth();
        int textTotalHeight = multiLineText.getTotalHeight();
        if (textImage == null || textImage.getWidth() < textX0 + textTotalWidth || textImage.getHeight() < textTotalHeight) {
            int w = ImageUtility.roundUpPower2((int)(textX0 + textTotalWidth));
            int h = ImageUtility.roundUpPower2((int)textTotalHeight);
            textImage = Texture2D.createDrawTexture(TextureFormat.RGBA, w, h, false);
            textGraphics = textImage.getTextureCanvas();
        }
        textGraphics.getImage().clear(true, null);
        textGraphics.setColor(texCanvas.getColor());
        textGraphics.setFont(texCanvas.getFont());
        for (int i = 0; i < multiLineText.getNumLines(); ++i) {
            textGraphics.drawString(multiLineText.getLine(i), multiLineText.getPosX(i), multiLineText.getPosY(i) - textY0);
        }
        texCanvas.getImage().drawImage(textImage.getImage0(), 0, 0, textX0 + textTotalWidth, textTotalHeight, offsetX, offsetY + textY0, true, null);
    }

    @Override
    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        this.prepareText(this.multiLineText, texCanvas, width, height);
        Texture2D icon = this.getIcon();
        if (this.multiLineText.getNumLines() > 1 || this.multiLineText.getNumLines() == 1 && this.multiLineText.getLine(0).length() > 0) {
            int orgTextOffsetX = this.textOffsetX;
            int orgTextOffsetY = this.textOffsetY;
            if (icon != null) {
                int iconWidth = HUDTextureUtils.getTextureWidth(icon);
                int iconHeight = HUDTextureUtils.getTextureHeight(icon);
                int gap = this.getIconGap();
                if (this.getAlignment().isLeftAligned()) {
                    this.textOffsetX += iconWidth + gap;
                } else if (this.getAlignment().isHCenterAligned()) {
                    this.textOffsetX += (iconWidth + gap) / 2;
                }
                int textX0 = this.multiLineText.getMinPosX();
                int textY0 = this.multiLineText.getPosY(0) + this.multiLineText.getLineOffsetY(0);
                int textTotalHeight = this.multiLineText.getTotalHeight();
                if (iconHeight > textTotalHeight) {
                    if (this.getAlignment().isTopAligned()) {
                        this.textOffsetY += (iconHeight - textTotalHeight) / 2;
                    } else if (this.getAlignment().isBottomAligned()) {
                        this.textOffsetY -= (iconHeight - textTotalHeight) / 2;
                    }
                }
                int y = offsetY + this.textOffsetY + textY0 + (textTotalHeight - iconHeight) / 2;
                switch (this.getAlignment()) {
                    case TOP_LEFT: {
                        this.drawIcon(icon, texCanvas, offsetX, y);
                        break;
                    }
                    case TOP_CENTER: {
                        this.drawIcon(icon, texCanvas, offsetX + textX0 - (iconWidth + gap) / 2, y);
                        break;
                    }
                    case TOP_RIGHT: {
                        this.drawIcon(icon, texCanvas, offsetX + textX0 - (iconWidth + gap), y);
                        break;
                    }
                    case CENTER_LEFT: {
                        this.drawIcon(icon, texCanvas, offsetX, y);
                        break;
                    }
                    case CENTER_CENTER: {
                        this.drawIcon(icon, texCanvas, offsetX + textX0 - (iconWidth + gap) / 2, y);
                        break;
                    }
                    case CENTER_RIGHT: {
                        this.drawIcon(icon, texCanvas, offsetX + textX0 - (iconWidth + gap), y);
                        break;
                    }
                    case BOTTOM_LEFT: {
                        this.drawIcon(icon, texCanvas, offsetX, y);
                        break;
                    }
                    case BOTTOM_CENTER: {
                        this.drawIcon(icon, texCanvas, offsetX + textX0 - (iconWidth + gap) / 2, y);
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        this.drawIcon(icon, texCanvas, offsetX + textX0 - (iconWidth + gap), y);
                    }
                }
            }
            this.drawText(this.multiLineText, texCanvas, offsetX, offsetY, width, height);
            if (icon != null) {
                this.textOffsetX = orgTextOffsetX;
                this.textOffsetY = orgTextOffsetY;
            }
        } else if (icon != null) {
            int iconWidth = HUDTextureUtils.getTextureWidth(icon);
            int iconHeight = HUDTextureUtils.getTextureHeight(icon);
            switch (this.getAlignment()) {
                case TOP_LEFT: {
                    this.drawIcon(icon, texCanvas, offsetX, offsetY);
                    break;
                }
                case TOP_CENTER: {
                    this.drawIcon(icon, texCanvas, offsetX + (width - iconWidth) / 2, offsetY);
                    break;
                }
                case TOP_RIGHT: {
                    this.drawIcon(icon, texCanvas, offsetX + width - iconWidth, offsetY);
                    break;
                }
                case CENTER_LEFT: {
                    this.drawIcon(icon, texCanvas, offsetX, offsetY + (height - iconHeight) / 2);
                    break;
                }
                case CENTER_CENTER: {
                    this.drawIcon(icon, texCanvas, offsetX + (width - iconWidth) / 2, offsetY + (height - iconHeight) / 2);
                    break;
                }
                case CENTER_RIGHT: {
                    this.drawIcon(icon, texCanvas, offsetX + width - iconWidth, offsetY + (height - iconHeight) / 2);
                    break;
                }
                case BOTTOM_LEFT: {
                    this.drawIcon(icon, texCanvas, offsetX, offsetY + height - iconHeight);
                    break;
                }
                case BOTTOM_CENTER: {
                    this.drawIcon(icon, texCanvas, offsetX + (width - iconWidth) / 2, offsetY + height - iconHeight);
                    break;
                }
                case BOTTOM_RIGHT: {
                    this.drawIcon(icon, texCanvas, offsetX + width - iconWidth, offsetY + height - iconHeight);
                }
            }
        }
    }

    @Override
    protected void initSize() {
        if (this.autoSize) {
            this.setMinimalSize();
        }
    }

    @Override
    protected void init() {
        this.updateTranslation();
        this.setTransparency(this.getTransparency());
    }

    protected Label(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height, String text, HUDFont font_enabled, HUDFont font_disabled, Colorf fontColor_enabled, Colorf fontColor_disabled, TextAlignment alignment, Colorf backgroundColor, Texture2D backgroundTexture) {
        super(isHeavyWeight, hasWidgetAssembler, Math.max(0.0f, width), Math.max(0.0f, height), backgroundColor, backgroundTexture, TileMode.STRETCH);
        if (text == null) {
            throw new NullPointerException("text must not be null");
        }
        this.autoSize = width <= 0.0f || height <= 0.0f;
        this.alignment = alignment;
        this.font = font_enabled == null ? HUD.getTheme().getFont(false) : font_enabled;
        this.font_disabled = font_disabled == null ? HUD.getTheme().getFont(true) : font_disabled;
        this.fontColor = fontColor_enabled == null ? HUD.getTheme().getFontColor(false) : fontColor_enabled;
        this.fontColor_disabled = fontColor_disabled == null ? HUD.getTheme().getFontColor(true) : fontColor_disabled;
        this.setText(text);
        this.setFocussable(false);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, HUDFont font_enabled, HUDFont font_disabled, Colorf fontColor_enabled, Colorf fontColor_disabled, TextAlignment alignment, Colorf backgroundColor, Texture2D backgroundTexture) {
        this(isHeavyWeight, false, width, height, text, font_enabled, font_disabled, fontColor_enabled, fontColor_disabled, alignment, backgroundColor, backgroundTexture);
    }

    private static final Description ld(Description desc) {
        if (desc == null) {
            return HUD.getTheme().getLabelDescription();
        }
        return desc;
    }

    protected Label(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height, String text, Description labelDesc) {
        this(isHeavyWeight, hasWidgetAssembler, width, height, text, Label.ld(labelDesc).getFont(false), Label.ld(labelDesc).getFont(true), Label.ld(labelDesc).getFontColor(false), Label.ld(labelDesc).getFontColor(true), Label.ld(labelDesc).getAlignment(), Label.ld(labelDesc).getBackgroundColor(), Label.ld(labelDesc).getBackgroundTexture());
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, Description labelDesc) {
        this(isHeavyWeight, width, height, text, Label.ld(labelDesc).getFont(false), Label.ld(labelDesc).getFont(true), Label.ld(labelDesc).getFontColor(false), Label.ld(labelDesc).getFontColor(true), Label.ld(labelDesc).getAlignment(), Label.ld(labelDesc).getBackgroundColor(), Label.ld(labelDesc).getBackgroundTexture());
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, HUDFont font, Colorf color, TextAlignment alignment) {
        this(isHeavyWeight, width, height, text, font, font == null ? Description.deriveDisabledFont(HUD.getTheme().getFont(false)) : Description.deriveDisabledFont(font), color, null, alignment, null, null);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, TextAlignment alignment) {
        this(isHeavyWeight, width, height, text, null, null, alignment);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, Colorf color, TextAlignment alignment) {
        this(isHeavyWeight, width, height, text, null, color, alignment);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, HUDFont font, Colorf color) {
        this(isHeavyWeight, width, height, text, font, color, TextAlignment.TOP_LEFT);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, Colorf color) {
        this(isHeavyWeight, width, height, text, null, color, TextAlignment.TOP_LEFT);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, HUDFont font) {
        this(isHeavyWeight, width, height, text, font, null, TextAlignment.TOP_LEFT);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text, HUDFont font, TextAlignment alignment) {
        this(isHeavyWeight, width, height, text, font, null, alignment);
    }

    public Label(boolean isHeavyWeight, float width, float height) {
        this(isHeavyWeight, width, height, "", (HUDFont)null, (Colorf)null);
    }

    public Label(boolean isHeavyWeight, float width, float height, String text) {
        this(isHeavyWeight, width, height, text, (HUDFont)null, (Colorf)null);
    }

    public Label(float width, float height, String text, Description labelDesc) {
        this(false, width, height, text, labelDesc);
    }

    public Label(float width, float height, String text, TextAlignment alignment) {
        this(false, width, height, text, alignment);
    }

    public Label(float width, float height, String text, Colorf color, TextAlignment alignment) {
        this(false, width, height, text, color, alignment);
    }

    public Label(float width, float height, String text, HUDFont font, Colorf color, TextAlignment alignment) {
        this(false, width, height, text, font, color, alignment);
    }

    public Label(float width, float height, String text, HUDFont font, Colorf color) {
        this(false, width, height, text, font, color);
    }

    public Label(float width, float height, String text, Colorf color) {
        this(false, width, height, text, color);
    }

    public Label(float width, float height, String text, HUDFont font) {
        this(false, width, height, text, font);
    }

    public Label(float width, float height, String text, HUDFont font, TextAlignment alignment) {
        this(false, width, height, text, font, alignment);
    }

    public Label(float width, float height) {
        this(false, width, height);
    }

    public Label(float width, float height, String text) {
        this(false, width, height, text);
    }

    public static class Description
    extends Widget.DescriptionBase {
        private Colorf backgroundColor;
        private Texture2D backgroundTexture;
        private TextAlignment alignment;
        private HUDFont font;
        private HUDFont font_disabled;
        private Colorf fontColor;
        private Colorf fontColor_disabled;

        public final Texture2D getBackgroundTexture() {
            return this.backgroundTexture;
        }

        public void setBackgroundTexture(Texture2D texture) {
            this.backgroundTexture = texture;
        }

        public void setBackgroundColor(Colorf color) {
            this.backgroundColor = color;
        }

        public Colorf getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundTexture(String texture) {
            if (texture != null) {
                this.setBackgroundTexture(HUDTextureUtils.getTexture(texture, true));
            } else {
                this.setBackgroundTexture((Texture2D)null);
            }
        }

        public void setAlignment(TextAlignment alignment) {
            this.alignment = alignment;
        }

        public TextAlignment getAlignment() {
            return this.alignment;
        }

        public void setFont(HUDFont font, boolean disabled) {
            if (disabled) {
                this.font_disabled = font;
            } else {
                this.font = font;
            }
        }

        public HUDFont getFont(boolean disabled) {
            if (disabled) {
                return this.font_disabled;
            }
            return this.font;
        }

        public void setFontColor(Colorf color, boolean disabled) {
            if (disabled) {
                this.fontColor_disabled = color;
            } else {
                this.fontColor = color;
            }
        }

        public Colorf getFontColor(boolean disabled) {
            if (disabled) {
                if (this.fontColor_disabled == null) {
                    this.fontColor_disabled = HUD.getTheme().getLabelDescription().getFontColor(true);
                }
                return this.fontColor_disabled;
            }
            return this.fontColor;
        }

        public static HUDFont deriveDisabledFont(HUDFont enabledFont) {
            return HUDFont.getFont(enabledFont.getName(), enabledFont.getStyle().makeItalic(), enabledFont.getSize());
        }

        public void set(Description desc) {
            this.backgroundTexture = desc.backgroundTexture;
            this.backgroundColor = desc.backgroundColor;
            this.alignment = desc.alignment;
            this.font = desc.font;
            this.font_disabled = desc.font_disabled;
            this.fontColor = desc.fontColor;
            this.fontColor_disabled = desc.fontColor_disabled;
        }

        public Description clone() {
            return new Description(this);
        }

        protected Description(Description desc) {
            this.set(desc);
        }

        public Description(Colorf backgroundColor, Texture2D backgroundTexture, HUDFont font_enabled, HUDFont font_disabled, Colorf color_enabled, Colorf color_disabled, TextAlignment alignment) {
            this.backgroundColor = backgroundColor;
            this.backgroundTexture = backgroundTexture;
            this.font = font_enabled == null ? HUD.getTheme().getFont(false) : font_enabled;
            this.font_disabled = font_disabled == null ? Description.deriveDisabledFont(this.font) : font_disabled;
            this.fontColor = color_enabled == null ? HUD.getTheme().getFontColor(false) : color_enabled;
            this.fontColor_disabled = color_disabled;
            this.alignment = alignment == null ? TextAlignment.TOP_LEFT : alignment;
        }

        public Description(Colorf backgroundColor, String backgroundTexture, HUDFont font_enabled, HUDFont font_disabled, Colorf color_enabled, Colorf color_disabled, TextAlignment alignment) {
            this(backgroundColor, HUDTextureUtils.getTextureOrNull(backgroundTexture, true), font_enabled, font_disabled, color_enabled, color_disabled, alignment);
        }
    }
}

