/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.util.ArrayList;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.BackgroundSettableWidget;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.ScrollbarListener;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.Button;

public class Scrollbar
extends BackgroundSettableWidget {
    private Direction direction;
    private final AbstractButton decButton;
    private final AbstractButton incButton;
    private Texture2D handleLTTex;
    private Texture2D handleRBTex;
    private Texture2D handleBodyTex;
    private Texture2D handleDecoTex;
    private int sizePX;
    private int currentHandlePosPx = -1;
    private int forcedHandlePosPx = -1;
    private boolean isScrolling = false;
    private float scrollStartMousePos;
    private int scrollStartHandlePos;
    private int minValue = 0;
    private int maxValue = 100;
    private int pageSize = 1;
    private int smallIncrement = 1;
    private int value = 0;
    private boolean smoothScrolling;
    private boolean needsRedrawAfterMouseButtonReleased = false;
    private final ArrayList<ScrollbarListener> scrollbarListeners = new ArrayList();

    public final Direction getDirection() {
        return this.direction;
    }

    private int getHandleSize() {
        Dim2i buffer = Dim2i.fromPool();
        this.getSizeHUD2Pixels_(this.decButton.getWidth(), this.decButton.getHeight(), buffer);
        int decBtnWidth = buffer.getWidth();
        int decBtnHeight = buffer.getHeight();
        this.getSizeHUD2Pixels_(this.incButton.getWidth(), this.incButton.getHeight(), buffer);
        int incBtnWidth = buffer.getWidth();
        int incBtnHeight = buffer.getHeight();
        Dim2i.toPool((Dim2i)buffer);
        int pageSize = this.getPageSize();
        float total = pageSize + this.getMaxValue() - this.getMinValue();
        int handleSize = 32;
        if (this.getDirection() == Direction.HORIZONTAL) {
            float areaWidth = this.getWidthPX() - decBtnWidth - incBtnWidth;
            int handleLeftSize = HUDTextureUtils.getTextureWidth(this.handleLTTex);
            int handleRightSize = HUDTextureUtils.getTextureWidth(this.handleRBTex);
            handleSize = Math.max(handleLeftSize + handleRightSize, (int)((float)pageSize * areaWidth / total));
        } else {
            float areaHeight = this.getHeightPX() - decBtnHeight - incBtnHeight;
            int handleTopSize = HUDTextureUtils.getTextureHeight(this.handleLTTex);
            int handleBottomSize = HUDTextureUtils.getTextureHeight(this.handleRBTex);
            handleSize = Math.max(handleTopSize + handleBottomSize, (int)((float)pageSize * areaHeight / total));
        }
        return handleSize;
    }

    protected int getMousePosition(int currentHandlePosPx, int mouseX, int mouseY) {
        if (this.getDirection() == Direction.HORIZONTAL) {
            if (mouseX < currentHandlePosPx) {
                return -1;
            }
            if (mouseX > currentHandlePosPx + this.getHandleSize()) {
                return 1;
            }
        } else {
            if (mouseY < currentHandlePosPx) {
                return -1;
            }
            if (mouseY > currentHandlePosPx + this.getHandleSize()) {
                return 1;
            }
        }
        return 0;
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (isTopMost && this.getMaxValue() > this.getMinValue()) {
            Widget picked = this.getWidgetAssembler().pick(x, y);
            if (picked == this.decButton) {
                this.setValue(this.getValue() - this.getSmallIncrement());
            } else if (picked == this.incButton) {
                this.setValue(this.getValue() + this.getSmallIncrement());
            } else {
                Dim2i buffer = Dim2i.fromPool();
                this.getSizeHUD2Pixels_(x, y, buffer);
                int localX = buffer.getWidth();
                int localY = buffer.getHeight();
                Dim2i.toPool((Dim2i)buffer);
                if (this.getMousePosition(this.currentHandlePosPx, localX, localY) == 0) {
                    this.bindToGlobalMouseMovement();
                    this.scrollStartHandlePos = this.currentHandlePosPx;
                    if (this.getDirection() == Direction.HORIZONTAL) {
                        this.scrollStartMousePos = x;
                    } else if (this.getDirection() == Direction.VERTICAL) {
                        this.scrollStartMousePos = y;
                    }
                    this.isScrolling = true;
                    this.needsRedrawAfterMouseButtonReleased = true;
                }
            }
        }
    }

    protected void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
        this.isScrolling = false;
        if (this.getSmoothScrolling()) {
            if (this.needsRedrawAfterMouseButtonReleased) {
                this.setTextureDirty();
            }
            this.needsRedrawAfterMouseButtonReleased = false;
        }
    }

    protected void onMouseMoved(float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
        super.onMouseMoved(x, y, buttonsState, when, isTopMost, hasFocus);
        if (this.isScrolling && this.getMaxValue() > this.getMinValue()) {
            int newValue;
            int oldForcedHandlePosPx = this.forcedHandlePosPx;
            if (this.getDirection() == Direction.HORIZONTAL) {
                float dx = x - this.scrollStartMousePos;
                Dim2i buffer = Dim2i.fromPool();
                this.getSizeHUD2Pixels_(this.decButton.getWidth(), this.decButton.getHeight(), buffer);
                int decBtnWidth = buffer.getWidth();
                this.getSizeHUD2Pixels_(this.incButton.getWidth(), this.incButton.getHeight(), buffer);
                int incBtnWidth = buffer.getWidth();
                this.getSizeHUD2Pixels_(this.getWidth(), 0.0f, buffer);
                int widgetWidthPx = buffer.getWidth();
                this.getSizeHUD2Pixels_((float)this.scrollStartHandlePos + dx, 0.0f, buffer);
                int scrollHandlePos = buffer.getWidth();
                Dim2i.toPool((Dim2i)buffer);
                int handleSize = this.getHandleSize();
                int barRestWidth = widgetWidthPx - decBtnWidth - incBtnWidth - handleSize;
                this.forcedHandlePosPx = Math.max(decBtnWidth, Math.min(scrollHandlePos, barRestWidth + decBtnWidth));
                newValue = Math.round((float)((this.forcedHandlePosPx - decBtnWidth) * (this.getMaxValue() - this.getMinValue())) / (float)barRestWidth) + this.getMinValue();
                if (!this.getSmoothScrolling()) {
                    this.forcedHandlePosPx = decBtnWidth + barRestWidth * (newValue - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
                }
            } else {
                float dy = y - this.scrollStartMousePos;
                Dim2i buffer = Dim2i.fromPool();
                this.getSizeHUD2Pixels_(this.decButton.getWidth(), this.decButton.getHeight(), buffer);
                int decBtnHeight = buffer.getHeight();
                this.getSizeHUD2Pixels_(this.incButton.getWidth(), this.incButton.getHeight(), buffer);
                int incBtnHeight = buffer.getHeight();
                this.getSizeHUD2Pixels_(0.0f, this.getHeight(), buffer);
                int widgetHeightPx = buffer.getHeight();
                this.getSizeHUD2Pixels_((float)this.scrollStartHandlePos + dy, 0.0f, buffer);
                int scrollHandlePos = buffer.getWidth();
                Dim2i.toPool((Dim2i)buffer);
                int handleSize = this.getHandleSize();
                int barRestHeight = widgetHeightPx - decBtnHeight - incBtnHeight - handleSize;
                this.forcedHandlePosPx = Math.max(decBtnHeight, Math.min(scrollHandlePos, barRestHeight + decBtnHeight));
                newValue = Math.round((float)((this.forcedHandlePosPx - decBtnHeight) * (this.getMaxValue() - this.getMinValue())) / (float)barRestHeight) + this.getMinValue();
                if (!this.getSmoothScrolling()) {
                    this.forcedHandlePosPx = decBtnHeight + barRestHeight * (newValue - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
                }
            }
            if (newValue != this.getValue()) {
                this.setValue(newValue);
            } else if (this.forcedHandlePosPx != oldForcedHandlePosPx) {
                this.setTextureDirty();
            }
        }
    }

    public void setMinValue(int minValue) {
        if (minValue > this.maxValue) {
            throw new IllegalArgumentException("minValue must never be greater than maxValue.");
        }
        if (this.minValue == minValue) {
            return;
        }
        this.minValue = minValue;
        this.setTextureDirty();
    }

    public final int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < this.minValue) {
            throw new IllegalArgumentException("maxValue must never be less than minValue.");
        }
        if (this.maxValue == maxValue) {
            return;
        }
        this.maxValue = maxValue;
        this.setTextureDirty();
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    public void setMinAndMax(int minValue, int maxValue) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be <= maxValue.");
        }
        if (minValue == this.minValue && maxValue == this.maxValue) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setTextureDirty();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public void setSmallIncrement(int value) {
        this.smallIncrement = value;
    }

    public final int getSmallIncrement() {
        return this.smallIncrement;
    }

    public void setMinMaxAndValue(int minValue, int maxValue, int value, int pageSize) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be <= maxValue.");
        }
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("value must be >= minValue and <= maxValue.");
        }
        if (minValue == this.minValue && maxValue == this.maxValue) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = value;
        this.pageSize = pageSize;
        this.setTextureDirty();
    }

    public final void setMinMaxAndValue(int minValue, int maxValue, int value) {
        this.setMinMaxAndValue(minValue, maxValue, value, (maxValue - minValue) / 5);
    }

    protected void onScrollbarValueChanged(int oldValue, int newValue) {
        for (int i = 0; i < this.scrollbarListeners.size(); ++i) {
            this.scrollbarListeners.get(i).onScrollbarValueChanged(this, newValue);
        }
    }

    public boolean setValue(int value) {
        value = Math.max(this.getMinValue(), Math.min(value, this.getMaxValue()));
        if (value == this.value) {
            return false;
        }
        int oldValue = this.value;
        this.value = value;
        this.setTextureDirty();
        this.onScrollbarValueChanged(oldValue, value);
        return true;
    }

    public final int getValue() {
        return this.value;
    }

    public void addScrollbarListener(ScrollbarListener l) {
        this.scrollbarListeners.add(l);
    }

    public boolean removeScrollbarListener(ScrollbarListener l) {
        return this.scrollbarListeners.remove(l);
    }

    public void setSmoothScrolling(boolean b) {
        this.smoothScrolling = b;
    }

    public final boolean getSmoothScrolling() {
        return this.smoothScrolling;
    }

    public final int getWidthOrHeightInPixels() {
        return this.sizePX;
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        if (this.getDirection() == Direction.HORIZONTAL) {
            if (this.decButton != null) {
                this.decButton.setSize(this.decButton.getWidth(), newHeight);
                if (this.getWidgetAssembler().contains(this.decButton)) {
                    this.getWidgetAssembler().reposition(this.decButton, 0.0f, 0.0f);
                }
            }
            if (this.incButton != null) {
                this.incButton.setSize(this.incButton.getWidth(), newHeight);
                if (this.getWidgetAssembler().contains(this.incButton)) {
                    this.getWidgetAssembler().reposition(this.incButton, newWidth - this.incButton.getWidth(), 0.0f);
                }
            }
        } else {
            if (this.decButton != null) {
                this.decButton.setSize(newWidth, this.decButton.getHeight());
                if (this.getWidgetAssembler().contains(this.decButton)) {
                    this.getWidgetAssembler().reposition(this.decButton, 0.0f, 0.0f);
                }
            }
            if (this.incButton != null) {
                this.incButton.setSize(newWidth, this.incButton.getHeight());
                if (this.getWidgetAssembler().contains(this.incButton)) {
                    this.getWidgetAssembler().reposition(this.incButton, 0.0f, newHeight - this.incButton.getHeight());
                }
            }
        }
    }

    protected int drawHandle(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, Texture2D handleLTTex, Texture2D handleRBTex, Texture2D handleBodyTex, Texture2D handleDecoTex, int forcedHandlePos) {
        int handlePos;
        int handleDecoratorWidth = 0;
        int handleDecoratorHeight = 0;
        if (handleDecoTex != null) {
            handleDecoratorWidth = HUDTextureUtils.getTextureWidth(handleDecoTex);
            handleDecoratorHeight = HUDTextureUtils.getTextureWidth(handleDecoTex);
        }
        if (this.getDirection() == Direction.HORIZONTAL) {
            int handleLeftSize = HUDTextureUtils.getTextureWidth(handleLTTex);
            int handleRightSize = HUDTextureUtils.getTextureWidth(handleRBTex);
            int handleSize = this.getHandleSize();
            handlePos = forcedHandlePos >= 0 ? forcedHandlePos : (width - handleSize) * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
            DrawUtils.drawImage(null, handleLTTex, null, texCanvas, offsetX + handlePos, offsetY, handleLeftSize, height);
            DrawUtils.drawImage(null, handleRBTex, null, texCanvas, offsetX + handlePos + handleSize - handleRightSize, offsetY, handleRightSize, height);
            DrawUtils.drawImage(null, handleBodyTex, TileMode.TILE_X, texCanvas, offsetX + handlePos + handleLeftSize, offsetY, handleSize - handleLeftSize - handleRightSize, height);
            if (handleDecoTex != null && handleSize - handleLeftSize - handleRightSize >= handleDecoratorWidth) {
                DrawUtils.drawImage(null, handleDecoTex, null, texCanvas, offsetX + handlePos + (handleSize - handleDecoratorWidth) / 2, offsetY + (height - handleDecoratorHeight) / 2, handleDecoratorWidth, handleDecoratorHeight);
            }
        } else {
            int handleTopSize = HUDTextureUtils.getTextureHeight(handleLTTex);
            int handleBottomSize = HUDTextureUtils.getTextureHeight(handleRBTex);
            int handleSize = this.getHandleSize();
            handlePos = forcedHandlePos >= 0 ? forcedHandlePos : (height - handleSize) * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
            DrawUtils.drawImage(null, handleLTTex, null, texCanvas, offsetX, offsetY + handlePos, width, handleTopSize);
            DrawUtils.drawImage(null, handleRBTex, null, texCanvas, offsetX, offsetY + handlePos + handleSize - handleBottomSize, width, handleBottomSize);
            DrawUtils.drawImage(null, handleBodyTex, TileMode.TILE_Y, texCanvas, offsetX, offsetY + handlePos + handleTopSize, width, handleSize - handleTopSize - handleBottomSize);
            if (handleDecoTex != null && handleSize - handleTopSize - handleBottomSize >= handleDecoratorHeight) {
                DrawUtils.drawImage(null, handleDecoTex, null, texCanvas, offsetX + (width - handleDecoratorWidth) / 2, offsetY + handlePos + (handleSize - handleDecoratorHeight) / 2, handleDecoratorWidth, handleDecoratorHeight);
            }
        }
        return handlePos;
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        if (this.getMaxValue() > this.getMinValue()) {
            Dim2i buffer = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(this.decButton.getWidth(), this.decButton.getHeight(), buffer);
            int decBtnWidth = buffer.getWidth();
            int decBtnHeight = buffer.getHeight();
            this.getSizeHUD2Pixels_(this.incButton.getWidth(), this.incButton.getHeight(), buffer);
            int incBtnWidth = buffer.getWidth();
            int incBtnHeight = buffer.getHeight();
            Dim2i.toPool((Dim2i)buffer);
            this.currentHandlePosPx = this.getDirection() == Direction.HORIZONTAL ? decBtnWidth + this.drawHandle(texCanvas, offsetX + decBtnWidth, offsetY, width - decBtnWidth - incBtnWidth, height, this.handleLTTex, this.handleRBTex, this.handleBodyTex, this.handleDecoTex, this.isScrolling ? this.forcedHandlePosPx - decBtnWidth : -1) : decBtnHeight + this.drawHandle(texCanvas, offsetX, offsetY + decBtnHeight, width, height - decBtnHeight - incBtnHeight, this.handleLTTex, this.handleRBTex, this.handleBodyTex, this.handleDecoTex, this.isScrolling ? this.forcedHandlePosPx - decBtnHeight : -1);
        }
    }

    protected void init() {
        Dim2f buffer = Dim2f.fromPool();
        this.getSizePixels2HUD_(this.sizePX, this.sizePX, buffer);
        if (this.getWidth() < 0.0f) {
            super.setSize(buffer.getWidth(), this.getHeight());
        } else if (this.getHeight() < 0.0f) {
            this.setSize(this.getWidth(), buffer.getHeight());
        }
        if (this.getDirection() == Direction.HORIZONTAL) {
            this.getSizePixels2HUD_(HUDTextureUtils.getTextureWidth(((Button)this.decButton).getTextureNormal()), 0, buffer);
            this.decButton.setSize(buffer.getWidth(), this.getHeight());
            this.getWidgetAssembler().addWidget(this.decButton, 0.0f, 0.0f);
            this.getSizePixels2HUD_(HUDTextureUtils.getTextureWidth(((Button)this.incButton).getTextureNormal()), 0, buffer);
            this.incButton.setSize(buffer.getWidth(), this.getHeight());
            this.getWidgetAssembler().addWidget(this.incButton, this.getWidth() - this.incButton.getWidth(), 0.0f);
        } else if (this.getDirection() == Direction.VERTICAL) {
            this.getSizePixels2HUD_(0, HUDTextureUtils.getTextureHeight(((Button)this.decButton).getTextureNormal()), buffer);
            this.decButton.setSize(this.getWidth(), buffer.getHeight());
            this.getWidgetAssembler().addWidget(this.decButton, 0.0f, 0.0f);
            this.getSizePixels2HUD_(0, HUDTextureUtils.getTextureHeight(((Button)this.incButton).getTextureNormal()), buffer);
            this.incButton.setSize(this.getWidth(), buffer.getHeight());
            this.getWidgetAssembler().addWidget(this.incButton, 0.0f, this.getHeight() - this.incButton.getHeight());
        }
        Dim2f.toPool((Dim2f)buffer);
        this.setSize(this.getWidth(), this.getHeight(), true);
        this.setTextureDirty();
    }

    public Scrollbar(float width, float height, Description sbDesc) {
        super(false, true, width, height, null, sbDesc.getBackgroundTexture(), TileMode.TILE_BOTH);
        this.direction = sbDesc.getDirection();
        this.decButton = new Button(false, (float)HUDTextureUtils.getTextureWidth(sbDesc.decTexture), (float)HUDTextureUtils.getTextureHeight(sbDesc.decTexture), sbDesc.decTexture, null, null);
        this.incButton = new Button(false, (float)HUDTextureUtils.getTextureWidth(sbDesc.incTexture), (float)HUDTextureUtils.getTextureHeight(sbDesc.incTexture), sbDesc.incTexture, null, null);
        this.handleLTTex = sbDesc.getHandleLeftTopTexture();
        this.handleRBTex = sbDesc.getHandleRightBottomTexture();
        this.handleBodyTex = sbDesc.getHandleBodyTexture();
        this.handleDecoTex = sbDesc.getHandleDecoTexture();
        if (this.getDirection() == Direction.HORIZONTAL) {
            this.sizePX = this.getBackgroundTexture() != null ? HUDTextureUtils.getTextureHeight(this.getBackgroundTexture()) : (sbDesc.getDecrementTexture() != null ? HUDTextureUtils.getTextureHeight(sbDesc.getDecrementTexture()) : (sbDesc.getIncrementTexture() != null ? HUDTextureUtils.getTextureHeight(sbDesc.getIncrementTexture()) : 16));
        } else if (this.getDirection() == Direction.VERTICAL) {
            this.sizePX = this.getBackgroundTexture() != null ? HUDTextureUtils.getTextureWidth(this.getBackgroundTexture()) : (sbDesc.getDecrementTexture() != null ? HUDTextureUtils.getTextureWidth(sbDesc.getDecrementTexture()) : (sbDesc.getIncrementTexture() != null ? HUDTextureUtils.getTextureWidth(sbDesc.getIncrementTexture()) : 16));
        }
        this.smoothScrolling = sbDesc.getSmoothScrolling();
    }

    public Scrollbar(float length, Description sbDesc) {
        this(sbDesc.direction == Direction.HORIZONTAL ? length : -1.0f, sbDesc.direction == Direction.HORIZONTAL ? -1.0f : length, sbDesc);
    }

    private static Description getThemedDesc(Direction direction) {
        if (direction == Direction.HORIZONTAL) {
            return HUD.getTheme().getScrollbarDescriptionHorizontal();
        }
        return HUD.getTheme().getScrollbarDescriptionVertical();
    }

    public Scrollbar(float width, float height, Direction direction) {
        this(width, height, Scrollbar.getThemedDesc(direction));
    }

    public Scrollbar(float length, Direction direction) {
        this(length, Scrollbar.getThemedDesc(direction));
    }

    public static class Description
    extends Widget.DescriptionBase {
        private Direction direction;
        private Texture2D backgroundTexture;
        private Texture2D decTexture;
        private Texture2D incTexture;
        private Texture2D handleLTTexture;
        private Texture2D handleRBTexture;
        private Texture2D handleBodyTexture;
        private Texture2D handleDecoTexture;
        private boolean smoothScrolling;

        public void setDirection(Direction direc) {
            this.direction = direc;
        }

        public final Direction getDirection() {
            return this.direction;
        }

        public void setBackgroundTexture(Texture2D texture) {
            this.backgroundTexture = texture;
        }

        public final void setBackgroundTexture(String texture) {
            this.setBackgroundTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getBackgroundTexture() {
            return this.backgroundTexture;
        }

        public void setIncrementTexture(Texture2D texture) {
            if (texture == null) {
                throw new IllegalArgumentException("texture must not be null");
            }
            this.incTexture = texture;
        }

        public final void setIncrementTexture(String texture) {
            this.setIncrementTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getIncrementTexture() {
            return this.incTexture;
        }

        public void setDecrementTexture(Texture2D texture) {
            if (texture == null) {
                throw new IllegalArgumentException("texture must not be null");
            }
            this.decTexture = texture;
        }

        public final void setDecrementTexture(String texture) {
            this.setDecrementTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getDecrementTexture() {
            return this.decTexture;
        }

        public void setHandleTextures(Texture2D handleLTTexture, Texture2D handleRBTexture, Texture2D handleBodyTexture, Texture2D handleDecoTexture) {
            this.handleLTTexture = handleLTTexture;
            this.handleRBTexture = handleRBTexture;
            this.handleBodyTexture = handleBodyTexture;
            this.handleDecoTexture = handleDecoTexture;
        }

        public final void setHandleTextures(String handleLTTexture, String handleRBTexture, String handleBodyTexture, String handleDecoTexture) {
            this.setHandleTextures(HUDTextureUtils.getTextureOrNull(handleLTTexture, true), HUDTextureUtils.getTextureOrNull(handleRBTexture, true), HUDTextureUtils.getTextureOrNull(handleBodyTexture, true), HUDTextureUtils.getTextureOrNull(handleDecoTexture, true));
        }

        public final Texture2D getHandleLeftTopTexture() {
            return this.handleLTTexture;
        }

        public final Texture2D getHandleRightBottomTexture() {
            return this.handleRBTexture;
        }

        public final Texture2D getHandleBodyTexture() {
            return this.handleBodyTexture;
        }

        public final Texture2D getHandleDecoTexture() {
            return this.handleDecoTexture;
        }

        public void setSmoothScrolling(boolean b) {
            this.smoothScrolling = b;
        }

        public final boolean getSmoothScrolling() {
            return this.smoothScrolling;
        }

        public void set(Description desc) {
            this.direction = desc.direction;
            this.backgroundTexture = desc.backgroundTexture;
            this.decTexture = desc.decTexture;
            this.incTexture = desc.incTexture;
            this.handleLTTexture = desc.handleLTTexture;
            this.handleRBTexture = desc.handleRBTexture;
            this.handleBodyTexture = desc.handleBodyTexture;
            this.handleDecoTexture = desc.handleDecoTexture;
            this.smoothScrolling = desc.smoothScrolling;
        }

        public Description clone() {
            return new Description(this);
        }

        public Description(Description desc) {
            this.set(desc);
        }

        public Description(Direction direction, Texture2D backgroundTexture, Texture2D handleLTTexture, Texture2D handleRBTexture, Texture2D handleBodyTexture, Texture2D handleDecoTexture, Texture2D decTexture, Texture2D incTexture, boolean smoothScrolling) {
            this.direction = direction;
            this.backgroundTexture = backgroundTexture;
            this.decTexture = decTexture;
            this.incTexture = incTexture;
            this.handleLTTexture = handleLTTexture;
            this.handleRBTexture = handleRBTexture;
            this.handleBodyTexture = handleBodyTexture;
            this.handleDecoTexture = handleDecoTexture;
            this.smoothScrolling = smoothScrolling;
        }

        public Description(Direction direction, String backgroundTexture, String handleLTTexture, String handleRBTexture, String handleBodyTexture, String handleDecoTexture, String decTexture, String incTexture, boolean smoothScrolling) {
            this(direction, HUDTextureUtils.getTexture(backgroundTexture, true), HUDTextureUtils.getTexture(handleLTTexture, true), HUDTextureUtils.getTexture(handleRBTexture, true), HUDTextureUtils.getTexture(handleBodyTexture, true), HUDTextureUtils.getTextureOrNull(handleDecoTexture, true), HUDTextureUtils.getTexture(decTexture, true), HUDTextureUtils.getTexture(incTexture, true), smoothScrolling);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

