/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets.assemblies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.jagatoo.commands.AlphabeticalCommandsKeyComparator;
import org.jagatoo.commands.Command;
import org.jagatoo.commands.NoParamCommandBase;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.LogInterface;
import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.__HUD_PrivilegedAccess;
import org.xith3d.ui.hud.base.BackgroundSettableWidget;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.borders.BorderFactory;
import org.xith3d.ui.hud.listeners.TextFieldListener;
import org.xith3d.ui.hud.listeners.WidgetKeyboardAdapter;
import org.xith3d.ui.hud.listmodels.TextListModel;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.PopUpable;
import org.xith3d.ui.hud.utils.ScrollMode;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.utils.WidgetMover;
import org.xith3d.ui.hud.widgets.List;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.hud.widgets.assemblies.ConsoleListener;
import org.xith3d.utility.comparator.IgnoreCaseComparator;
import org.xith3d.utility.comparator.StartsWithIgnoreCaseComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HUDConsole
extends BackgroundSettableWidget
implements PopUpable,
LogInterface {
    private final List list;
    private final float listInputBoxGap;
    private final TextField inputBox;
    private final List commandPreview;
    private boolean isPoppedUp = true;
    private boolean trimMessages = true;
    private final WidgetMover mover = new WidgetMover(this){

        protected void onMovementStopped() {
            if (!HUDConsole.this.isPoppedUp()) {
                HUDConsole.this.setVisible(false);
                if (HUDConsole.this.getHUD() != null) {
                    HUDConsole.this.getHUD().disposeFocus();
                }
            }
        }
    };
    private Boolean initiallyVisible;
    private int logLevel;
    private int channelFilter;
    private final Colorf errorColor;
    private final Colorf warningColor;
    private final Colorf normalColor;
    private final ArrayList<String> enteredCommands = new ArrayList();
    private final HashMap<String, Command> registeredCommands = new HashMap();
    private final ArrayList<ConsoleListener> listeners = new ArrayList();

    public final void addConsoleListener(ConsoleListener l) {
        this.listeners.add(l);
    }

    public final void removeConsoleListener(ConsoleListener l) {
        this.listeners.remove(l);
    }

    private final boolean compare(float v1, float v2) {
        return Math.abs(v2 - v1) < (this.getWidth() + this.getHeight()) / 1000.0f;
    }

    private boolean isCommandPreviewVisible() {
        return this.commandPreview.isVisible() && this.commandPreview.getHUD() != null;
    }

    private void setCommandPreviewListVisible(boolean visible) {
        if (visible) {
            if (this.isCommandPreviewVisible()) {
                return;
            }
            Tuple2f loc = Tuple2f.fromPool();
            this.getHUD().getCoordinatesConverter().getAbsoluteLocationOnHUD(this.inputBox, loc);
            __HUD_PrivilegedAccess.addVolatilePopup(this.getHUD(), this.commandPreview, null, loc.getX() + 10.0f, loc.getY() + this.inputBox.getHeight());
            Tuple2f.toPool((Tuple2f)loc);
        } else {
            if (!this.isCommandPreviewVisible()) {
                return;
            }
            __HUD_PrivilegedAccess.removeVolatilePopup(this.getHUD());
        }
    }

    private final void popUp(boolean p, boolean jump) {
        if (!p) {
            this.setCommandPreviewListVisible(false);
        }
        HUD hud = this.getHUD();
        boolean doIt = false;
        if (!this.mover.isMoving()) {
            if (this.isPoppedUp() && !p) {
                if (this.compare(this.getTop(), 0.0f) && this.compare(this.getLeft(), 0.0f) && this.compare(this.getWidth(), hud.getResX())) {
                    this.mover.setDestinationLocation(0.0f, -this.getHeight());
                    this.mover.setSpeed(this.getHeight() * 2.0f);
                    doIt = true;
                } else if (this.compare(this.getTop(), 0.0f) && this.compare(this.getLeft(), 0.0f) && this.compare(this.getHeight(), hud.getResY())) {
                    this.mover.setDestinationLocation(-this.getWidth(), 0.0f);
                    this.mover.setSpeed(this.getWidth() * 2.0f);
                    doIt = true;
                } else if (this.compare(this.getTop(), hud.getResY() - this.getHeight()) && this.compare(this.getLeft(), 0.0f) && this.compare(this.getWidth(), hud.getResX())) {
                    this.mover.setDestinationLocation(0.0f, hud.getResY());
                    this.mover.setSpeed(this.getHeight() * 2.0f);
                    doIt = true;
                } else if (this.compare(this.getTop(), 0.0f) && this.compare(this.getLeft(), hud.getResX() - this.getWidth()) && this.compare(this.getHeight(), hud.getResY())) {
                    this.mover.setDestinationLocation(hud.getResX(), 0.0f);
                    this.mover.setSpeed(this.getWidth() * 2.0f);
                    doIt = true;
                }
            } else if (!this.isPoppedUp() && p) {
                if (this.getTop() < -(this.getHeight() / 2.0f)) {
                    this.mover.setDestinationLocation(0.0f, 0.0f);
                    this.mover.setSpeed(this.getHeight() * 2.0f);
                    doIt = true;
                } else if (this.getLeft() < -(this.getWidth() / 2.0f)) {
                    this.mover.setDestinationLocation(0.0f, 0.0f);
                    this.mover.setSpeed(this.getWidth() * 2.0f);
                    doIt = true;
                } else if (this.getTop() > hud.getResY() - this.getHeight() / 2.0f) {
                    this.mover.setDestinationLocation(0.0f, hud.getResY() - this.getHeight());
                    this.mover.setSpeed(this.getHeight() * 2.0f);
                    doIt = true;
                } else if (this.getLeft() > hud.getResX() - this.getWidth() / 2.0f) {
                    this.mover.setDestinationLocation(hud.getResX() - this.getWidth(), 0.0f);
                    this.mover.setSpeed(this.getWidth() * 2.0f);
                    doIt = true;
                }
            }
        }
        if (doIt) {
            if (!jump) {
                if (!this.isPoppedUp() && p) {
                    this.setVisible(true);
                    if (this.isInputBoxVisible()) {
                        this.inputBox.requestFocus();
                    } else {
                        this.list.requestFocus();
                    }
                }
                this.mover.startMoving();
            } else {
                this.setLocation(this.mover.getDestinationLocation());
                if (!p) {
                    hud.disposeFocus();
                }
            }
        }
        this.isPoppedUp = p;
    }

    @Override
    public void popUp(boolean p) {
        this.popUp(p, false);
    }

    @Override
    public boolean isPoppedUp() {
        return this.isPoppedUp;
    }

    public void setListFontColor(int logLevel, Colorf color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        switch (logLevel) {
            case -2: {
                this.errorColor.set(color);
                break;
            }
            case -1: {
                this.warningColor.set(color);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.normalColor.set(color);
            }
        }
        throw new IllegalArgumentException("This LogLevel is invalid.");
    }

    public Colorf getListFontColor(int logLevel) {
        switch (logLevel) {
            case -2: {
                return this.errorColor;
            }
            case -1: {
                return this.warningColor;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.normalColor;
            }
        }
        throw new IllegalArgumentException("This LogLevel is invalid.");
    }

    public final void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setChannelFilter(int filter) {
        this.channelFilter = filter;
    }

    public final int getChannelFilter() {
        return this.channelFilter;
    }

    public final boolean acceptsChannel(LogChannel channel) {
        return (this.channelFilter & channel.getID()) > 0;
    }

    public boolean println(String message, Colorf color) {
        if (this.trimMessages) {
            message = message.trim();
        }
        if (message.length() > 0) {
            this.list.addItem(message, color);
            return true;
        }
        return false;
    }

    public final boolean println(int logLevel, String message) {
        return this.println(message, this.getListFontColor(logLevel));
    }

    public final boolean println(String message) {
        return this.println(0, message);
    }

    public final void print(LogChannel channel, int logLevel, String message) {
        if (this.acceptsChannel(channel) && logLevel <= this.logLevel) {
            this.println(logLevel, message);
        }
    }

    public final void println(LogChannel channel, int logLevel, String message) {
        if (this.acceptsChannel(channel) && logLevel <= this.logLevel) {
            this.println(logLevel, message);
        }
    }

    private final int findCommandPreviewIndex(String command) {
        for (int i = 0; i < this.enteredCommands.size(); ++i) {
            int cmp = IgnoreCaseComparator.compareIC(command, this.enteredCommands.get(i));
            if (cmp < 0) {
                return i;
            }
            if (cmp != 0) continue;
            return -1;
        }
        return this.enteredCommands.size();
    }

    private final void addCommandToPreview(String command, String previewString) {
        int index = this.findCommandPreviewIndex(command);
        if (index >= 0) {
            this.enteredCommands.add(index, previewString);
        }
    }

    private static String getCommandSignature(Command command) {
        String[] params = command.getParameterTypes();
        String sig = command.getKey();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sig = i == 0 ? sig + "( " + params[i] : (i == params.length - 1 ? sig + ", " + params[i] + " )" : sig + ", " + params[i]);
            }
        } else {
            sig = sig + "()";
        }
        return sig;
    }

    public void registerCommand(Command command) {
        String sig = HUDConsole.getCommandSignature(command);
        this.addCommandToPreview(command.getKey(), sig);
        this.registeredCommands.put(command.getKey(), command);
    }

    public void registerCommands(Command[] commands) {
        for (int i = 0; i < commands.length; ++i) {
            this.registerCommand(commands[i]);
        }
    }

    public void registerCommands(java.util.List<Command> commands) {
        for (int i = 0; i < commands.size(); ++i) {
            this.registerCommand(commands.get(i));
        }
    }

    public Command[] getRegisteredCommands() {
        Command[] commands = new Command[this.registeredCommands.size()];
        int i = 0;
        for (Command cmd : this.registeredCommands.values()) {
            commands[i++] = cmd;
        }
        Arrays.sort(commands, AlphabeticalCommandsKeyComparator.getInstance());
        return commands;
    }

    public void dumpKnownCommands() {
        for (Command command : this.getRegisteredCommands()) {
            this.println(HUDConsole.getCommandSignature(command));
        }
    }

    protected void onCommandEntered(String commandLine) {
        commandLine = commandLine.trim();
        this.addCommandToPreview(commandLine, commandLine);
        this.setCommandPreviewListVisible(false);
        this.commandPreview.setSelectedIndex(-1);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onCommandEntered(this, commandLine);
        }
    }

    protected void updatePreviewListSize(List previewList) {
        previewList.setSize(previewList.getMinWidthThatFitsItems(), 100.0f);
        previewList.setHeightByItems(Math.min(previewList.getItemsCount(), 5));
    }

    protected void updateTypePreview(String text) {
        if (this.enteredCommands.size() == 0) {
            this.setCommandPreviewListVisible(false);
            return;
        }
        int first = Collections.binarySearch(this.enteredCommands, text, StartsWithIgnoreCaseComparator.INSTANCE);
        if (first < 0) {
            this.setCommandPreviewListVisible(false);
            return;
        }
        while (first > 0 && StartsWithIgnoreCaseComparator.startsWithIC(this.enteredCommands.get(first - 1), text)) {
            --first;
        }
        TextListModel model = (TextListModel)this.commandPreview.getModel();
        model.clear();
        int i = first;
        String ec = this.enteredCommands.get(first);
        do {
            model.addItem(ec);
        } while (++i < this.enteredCommands.size() && StartsWithIgnoreCaseComparator.startsWithIC(ec = this.enteredCommands.get(i), text));
        model.markListDirty();
        this.setCommandPreviewListVisible(true);
        this.updatePreviewListSize(this.commandPreview);
    }

    public void flush() {
    }

    public void close() {
    }

    public void setIgnoredChars(char ... ignoredChars) {
        this.inputBox.setIgnoredChars(ignoredChars);
    }

    public char[] getIgnoredChars() {
        return this.inputBox.getIgnoredChars();
    }

    public void setTrimMessages(boolean trimMessages) {
        this.trimMessages = trimMessages;
    }

    public boolean isTrimMessages() {
        return this.trimMessages;
    }

    public void setInputBoxVisible(boolean visible) {
        this.inputBox.setVisible(visible);
        if (!visible && this.inputBox.hasFocus(true)) {
            this.list.requestFocus();
        }
        this.update();
    }

    public boolean isInputBoxVisible() {
        return this.inputBox.isVisible();
    }

    @Override
    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        if (this.initiallyVisible != null && !this.initiallyVisible.booleanValue()) {
            this.initiallyVisible = null;
            this.popUp(false, true);
        }
    }

    @Override
    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        float innerHeight;
        float innerWidth;
        if (this.getBorder() == null) {
            innerWidth = this.getWidth();
            innerHeight = this.getHeight();
        } else {
            innerWidth = this.getWidth() - (float)this.getBorder().getLeftWidth() - (float)this.getBorder().getRightWidth();
            innerHeight = this.getHeight() - (float)this.getBorder().getTopHeight() - (float)this.getBorder().getBottomHeight();
        }
        float inputBoxHeight = 0.0f;
        if (this.inputBox.isVisible()) {
            this.inputBox.setSize(innerWidth, this.inputBox.getHeight());
            inputBoxHeight = this.inputBox.getHeight();
            if (this.getBorder() != null) {
                this.getWidgetAssembler().reposition(this.inputBox, this.getBorder().getLeftWidth(), this.getHeight() - (float)this.getBorder().getBottomHeight() - this.inputBox.getHeight());
            } else {
                this.getWidgetAssembler().reposition(this.inputBox, 0.0f, this.getHeight() - this.inputBox.getHeight());
            }
            if (this.isCommandPreviewVisible()) {
                this.commandPreview.setLocation(this.commandPreview.getLeft(), this.commandPreview.getTop() + (newHeight - oldHeight));
            }
            float inputBoxLeft = this.getWidgetAssembler().getPositionX(this.inputBox);
            float inputBoxTop = this.getWidgetAssembler().getPositionY(this.inputBox);
            this.getWidgetAssembler().reposition(this.commandPreview, inputBoxLeft + 10.0f, inputBoxTop + this.inputBox.getHeight());
        }
        this.list.setSize(innerWidth, innerHeight - inputBoxHeight - (this.inputBox.isVisible() ? this.listInputBoxGap : 0.0f));
        if (this.getBorder() != null) {
            this.getWidgetAssembler().reposition(this.list, this.getBorder().getLeftWidth(), this.getBorder().getTopHeight());
        } else {
            this.getWidgetAssembler().reposition(this.list, 0.0f, 0.0f);
        }
    }

    @Override
    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    @Override
    protected void init() {
        Dim2f buffer = Dim2f.fromPool();
        this.getSizePixels2HUD_(this.getContentLeftPX(), this.getContentTopPX(), buffer);
        float contentLeft = buffer.getWidth();
        float contentTop = buffer.getHeight();
        float contentBottom = 0.0f;
        if (this.getBorder() != null) {
            this.getSizePixels2HUD_(0, this.getBorder().getBottomHeight(), buffer);
            contentBottom = buffer.getHeight();
        }
        float inputBoxLeft = contentLeft;
        float inputBoxTop = this.getHeight() - contentBottom - this.inputBox.getHeight();
        this.getWidgetAssembler().addWidget(this.inputBox, inputBoxLeft, inputBoxTop);
        this.inputBox.getMinimalSize(buffer);
        float inputBoxHeight = buffer.getHeight();
        Dim2f.toPool((Dim2f)buffer);
        float contentWidth = this.getContentWidth();
        this.inputBox.setSize(contentWidth, inputBoxHeight);
        this.list.setSize(contentWidth, this.getContentHeight() - this.inputBox.getHeight() - this.listInputBoxGap);
        this.getWidgetAssembler().addWidget(this.list, contentLeft, contentTop);
        inputBoxTop = this.getHeight() - contentBottom - this.inputBox.getHeight();
        this.getWidgetAssembler().reposition(this.inputBox, inputBoxLeft, inputBoxTop);
        this.getWidgetAssembler().setKeyEventsDispatched(true);
        this.getWidgetAssembler().setPickDispatched(true);
        this.inputBox.requestFocus();
        this.inputBox.addTextFieldListener(new TextFieldListener(){

            public void onCharTyped(TextField textField, char ch) {
                HUDConsole.this.updateTypePreview(textField.getText());
            }

            public void onCharDeleted(TextField textField) {
                HUDConsole.this.updateTypePreview(textField.getText());
            }

            public void onEscapeHit(TextField textField) {
                HUDConsole.this.setCommandPreviewListVisible(false);
            }

            public void onTabHit(TextField textField) {
            }

            public void onEnterHit(TextField textField) {
                String commandLine;
                if (HUDConsole.this.isCommandPreviewVisible() && HUDConsole.this.commandPreview.getSelectedIndex() >= 0) {
                    commandLine = (String)HUDConsole.this.commandPreview.getSelectedItem();
                    Command command = null;
                    int pos = commandLine.indexOf(40);
                    if (pos >= 0) {
                        command = (Command)HUDConsole.this.registeredCommands.get(commandLine.substring(0, pos));
                    }
                    if (command != null) {
                        if (command.getNumParameters() == 0) {
                            HUDConsole.this.inputBox.setText("");
                            if (command instanceof HelpCommand) {
                                ((HelpCommand)command).execute();
                                HUDConsole.this.setCommandPreviewListVisible(false);
                                HUDConsole.this.commandPreview.setSelectedIndex(-1);
                            } else {
                                HUDConsole.this.onCommandEntered(command.getKey() + "()");
                            }
                        } else {
                            HUDConsole.this.inputBox.setText(command.getKey() + "(  )");
                            HUDConsole.this.inputBox.setCaretPosition(HUDConsole.this.inputBox.getText().length() - 2);
                            HUDConsole.this.updateTypePreview(HUDConsole.this.inputBox.getText());
                        }
                        return;
                    }
                } else {
                    commandLine = textField.getText();
                }
                if (HUDConsole.this.println(commandLine)) {
                    HUDConsole.this.inputBox.setText("");
                    HUDConsole.this.onCommandEntered(commandLine);
                }
            }
        });
        this.inputBox.addKeyboardListener(new WidgetKeyboardAdapter(){

            public void onKeyPressed(Widget widget, Key key, int modifierMask, long when) {
                switch (key.getKeyID()) {
                    case UP: {
                        if (!HUDConsole.this.isCommandPreviewVisible()) break;
                        HUDConsole.this.commandPreview.selectPreviousItem();
                        break;
                    }
                    case DOWN: {
                        if (!HUDConsole.this.isCommandPreviewVisible()) break;
                        HUDConsole.this.commandPreview.selectNextItem();
                    }
                }
            }
        });
    }

    public HUDConsole(float width, float height, int channelFilter, int logLevel, Description desc, boolean initiallyVisible) {
        super(true, true, desc.getBackgroundColor(), desc.getBackgroundTexture(), TileMode.TILE_BOTH);
        this.logLevel = logLevel;
        this.channelFilter = channelFilter;
        this.normalColor = new Colorf(desc.getListFontColorNormal());
        this.warningColor = new Colorf(desc.getListFontColorWarning());
        this.errorColor = new Colorf(desc.getListFontColorError());
        if (desc.getBorderDescription() != null) {
            this.setBorder(BorderFactory.createBorder(desc.getBorderDescription()));
        }
        float innerWidth = this.getWidth();
        float innerHeight = this.getHeight();
        this.listInputBoxGap = desc.getListInputBoxGap();
        this.inputBox = desc.getInputBoxDescription() == null ? new InputBox(innerWidth, 20.0f) : new InputBox(innerWidth, 20.0f, desc.getInputBoxDescription());
        this.inputBox.setAutoSizeEnabled(false);
        this.inputBox.setIgnoredChars('^');
        this.list = desc.getListDescription() == null ? new List(innerWidth, innerHeight - this.inputBox.getHeight() - this.listInputBoxGap, null) : List.newTextList(innerWidth, innerHeight - this.inputBox.getHeight() - this.listInputBoxGap, desc.getListDescription());
        this.list.setFixedToBottom(true);
        this.commandPreview = List.newTextList(true, 120.0f, 100.0f, desc.getPreviewListDescription());
        this.commandPreview.setScrollMode(ScrollMode.NEVER);
        this.commandPreview.setFontColor(this.inputBox.getFontColor());
        this.initiallyVisible = new Boolean(initiallyVisible);
        this.setSize(width, height);
        this.setZIndex(0x7FFFFFF4);
        this.registerCommand((Command)new HelpCommand());
    }

    public HUDConsole(float width, float height, int channelFilter, Description desc, boolean initiallyVisible) {
        this(width, height, channelFilter, 0, desc, initiallyVisible);
    }

    public HUDConsole(float width, float height, Description desc, boolean initiallyVisible) {
        this(width, height, -1, 0, desc, initiallyVisible);
    }

    public HUDConsole(float width, float height, int channelFilter, int logLevel, boolean initiallyVisible) {
        this(width, height, channelFilter, logLevel, new Description(), initiallyVisible);
    }

    public HUDConsole(float width, float height, int channelFilter, boolean initiallyVisible) {
        this(width, height, channelFilter, 0, initiallyVisible);
    }

    public HUDConsole(float width, float height, boolean initiallyVisible) {
        this(width, height, -1, 0, initiallyVisible);
    }

    private class HelpCommand
    extends NoParamCommandBase {
        public String execute(Boolean inputInfo) {
            HUDConsole.this.dumpKnownCommands();
            return "dump known commands.";
        }

        public final String execute() {
            return this.execute(null);
        }

        public HelpCommand() {
            super("help");
        }
    }

    private static final class InputBox
    extends TextField {
        protected boolean blocksFocusMoveDeviceComponent(DeviceComponent dc) {
            if (super.blocksFocusMoveDeviceComponent(dc)) {
                return true;
            }
            if (dc == Keys.UP) {
                return true;
            }
            return dc == Keys.DOWN;
        }

        public InputBox(float width, float height) {
            super(width, height);
        }

        public InputBox(float width, float height, TextField.Description desc) {
            super(width, height, "", desc);
        }
    }

    public static class Description
    extends BackgroundSettableWidget.BackgroundSettableDescriptionBase {
        private Border.Description borderDesc;
        private List.Description listDesc;
        private TextField.Description inputBoxDesc;
        private List.Description previewListDesc;
        private float listInputBoxGap;
        private float inputBoxHeight;
        private HUDFont listFont;
        private Colorf listFontColorNormal;
        private Colorf listFontColorWarning;
        private Colorf listFontColorError;

        public void setBorderDescription(Border.Description borderDesc) {
            this.borderDesc = borderDesc;
        }

        public Border.Description getBorderDescription() {
            return this.borderDesc;
        }

        public void setListFontColorNormal(Colorf color) {
            this.listFontColorNormal = color;
        }

        public Colorf getListFontColorNormal() {
            return this.listFontColorNormal;
        }

        public void setListFontColorWarning(Colorf color) {
            this.listFontColorWarning = color;
        }

        public Colorf getListFontColorWarning() {
            return this.listFontColorWarning;
        }

        public void setListFontColorError(Colorf color) {
            this.listFontColorError = color;
        }

        public Colorf getListFontColorError() {
            return this.listFontColorError;
        }

        public void setListFont(HUDFont listFont) {
            this.listFont = listFont;
        }

        public HUDFont getListFont() {
            return this.listFont;
        }

        public void setListDescription(List.Description listDesc) {
            this.listDesc = listDesc;
        }

        public List.Description getListDescription() {
            return this.listDesc;
        }

        public void setInputBoxDescription(TextField.Description inputBoxDesc) {
            this.inputBoxDesc = inputBoxDesc;
        }

        public TextField.Description getInputBoxDescription() {
            return this.inputBoxDesc;
        }

        public void setPreviewListDescription(List.Description listDesc) {
            this.previewListDesc = listDesc;
        }

        public List.Description getPreviewListDescription() {
            return this.previewListDesc;
        }

        public void setListInputBoxGap(float gap) {
            this.listInputBoxGap = gap;
        }

        public float getListInputBoxGap() {
            return this.listInputBoxGap;
        }

        public void setInputBoxHeight(float height) {
            this.inputBoxHeight = height;
        }

        public float getInputBoxHeight() {
            return this.inputBoxHeight;
        }

        public Description clone() {
            return new Description(this);
        }

        public Description(Description template) {
            super(template.getBackgroundColor(), template.getBackgroundTexture());
            this.borderDesc = template.getBorderDescription().clone();
            this.listFontColorNormal = template.getListFontColorNormal();
            this.listFontColorWarning = template.getListFontColorWarning();
            this.listFontColorError = template.getListFontColorError();
            this.listFont = template.getListFont();
            this.listDesc = template.getListDescription().clone();
            this.inputBoxDesc = template.getInputBoxDescription().clone();
            this.previewListDesc = template.getPreviewListDescription().clone();
            this.listInputBoxGap = template.getListInputBoxGap();
            this.inputBoxHeight = template.getInputBoxHeight();
        }

        public Description(Border.Description borderDesc, Texture2D backgroundTexture, Colorf backgroundColor, Colorf listFontColorNormal, Colorf listFontColorWarning, Colorf listFontColorError, List.Description listDesc, TextField.Description inputBoxDesc, List.Description previewListDesc, float listTextFieldGap, float inputBoxHeight) {
            super(backgroundColor, backgroundTexture);
            this.borderDesc = borderDesc;
            this.listFontColorNormal = listFontColorNormal;
            this.listFontColorWarning = listFontColorWarning;
            this.listFontColorError = listFontColorError;
            this.listDesc = listDesc;
            this.inputBoxDesc = inputBoxDesc;
            this.previewListDesc = previewListDesc;
            this.listInputBoxGap = listTextFieldGap;
            this.inputBoxHeight = inputBoxHeight;
        }

        public Description() {
            super(Colorf.DARK_GRAY, null);
            this.borderDesc = new Border.Description(10, 10, 10, 10);
            this.listFontColorNormal = Colorf.WHITE;
            this.listFontColorWarning = Colorf.ORANGE;
            this.listFontColorError = Colorf.RED;
            this.listDesc = HUD.getTheme().getListDescription();
            this.inputBoxDesc = HUD.getTheme().getTextFieldDescription();
            this.listInputBoxGap = 10.0f;
            this.inputBoxHeight = 20.0f;
            this.listDesc.setBorderDescription(new Border.Description(2, 2, 2, 2, Colorf.LIGHT_GRAY));
            this.listDesc.setBackgroundColor(null);
            this.listDesc.setBackgroundTexture((Texture2D)null);
            this.inputBoxDesc.setBorderDescription(new Border.Description(2, 2, 2, 2, Colorf.LIGHT_GRAY));
            this.inputBoxDesc.setBackgroundColor(null);
            this.inputBoxDesc.setBackgroundTexture((Texture2D)null);
            this.inputBoxDesc.setFontColor(this.listFontColorNormal, false);
            this.inputBoxDesc.setCaretTexture("white");
            this.previewListDesc = this.listDesc.clone();
            this.previewListDesc.setBackgroundColor(this.getBackgroundColor());
            this.previewListDesc.setBackgroundTexture(this.getBackgroundTexture());
        }

        public Description(Texture2D backgroundTexture) {
            this();
            this.setBackgroundColor(null);
            this.setBackgroundTexture(backgroundTexture);
        }

        public Description(Colorf backgroundColor) {
            this();
            this.setBackgroundColor(backgroundColor);
            this.setBackgroundTexture((Texture2D)null);
        }

        public Description(Texture2D backgroundTexture, Colorf listFontColorNormal, Colorf listFontColorWarning, Colorf listFontColorError) {
            this();
            this.setBackgroundColor(null);
            this.setBackgroundTexture(backgroundTexture);
            this.listFontColorNormal = listFontColorNormal;
            this.listFontColorWarning = listFontColorWarning;
            this.listFontColorError = listFontColorError;
            this.inputBoxDesc.setFontColor(listFontColorNormal, false);
        }

        public Description(Colorf backgroundColor, Colorf listFontColorNormal, Colorf listFontColorWarning, Colorf listFontColorError) {
            this();
            this.setBackgroundColor(backgroundColor);
            this.setBackgroundTexture((Texture2D)null);
            this.listFontColorNormal = listFontColorNormal;
            this.listFontColorWarning = listFontColorWarning;
            this.listFontColorError = listFontColorError;
            this.inputBoxDesc.setFontColor(listFontColorNormal, false);
        }
    }
}

