/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.AlphaComposite;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.swingui.UIOverlay;
import org.xith3d.ui.swingui.UISubOverlayBase;
import org.xith3d.utility.logging.X3DLog;

public class UISubOverlayOptimized
extends UISubOverlayBase {
    private final Texture2D tex;

    protected UISubOverlayOptimized(UIOverlay overlay, int lx, int ly, int ux, int uy) {
        super(overlay, lx, ly, ux, uy);
        X3DLog.debug("Sub-overlay : ", this.width, ",", this.height, " -> ", this.texWidth, ",", this.texHeight, " : ", lx, ",", ly, " - ", ux, ",", uy);
        boolean hasAlpha = overlay.getBlendAlpha() || overlay.getClipAlpha();
        this.tex = Texture2D.createDrawTexture(hasAlpha ? TextureFormat.RGBA : TextureFormat.RGB, this.texWidth, this.texHeight, true, true);
        this.tex.setBoundaryModes(TextureBoundaryMode.CLAMP_TO_EDGE, TextureBoundaryMode.CLAMP_TO_EDGE);
        this.tex.setFilter(TextureFilter.POINT);
        this.ap.setTexture(this.tex);
    }

    protected void update(BufferedImage fullImage, Rectangle updateRect) {
        this.dirty = true;
        Rectangle r = updateRect.intersection(this.bounds);
        Texture2DCanvas tc = this.tex.getTextureCanvas();
        int destLX = r.x - this.bounds.x;
        int destLY = this.height - (r.y - this.bounds.y) - r.height;
        int destUX = destLX + r.width;
        int destUY = destLY + r.height;
        --r.y;
        int srcLX = r.x;
        int srcUY = r.y;
        int srcUX = r.x + r.width;
        int srcLY = r.y + r.height;
        tc.setComposite(AlphaComposite.Src);
        tc.drawImage(fullImage, destLX, destLY, destUX, destUY, srcLX, srcLY, srcUX, srcUY);
    }

    public void swap() {
        this.dirty = false;
    }
}

