/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.text2d;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.scenegraph.ASCIITexture;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.ui.text2d.Font2D;

public class Character2D
extends Shape3D {
    private static float fontStretchFactor = 1.0f;
    private static final Map<String, Character2D> characterCache = new HashMap<String, Character2D>(10, 10.0f);
    private Tuple2f size;
    private char character;
    private static Colorf tmpColor = new Colorf();

    public static void setFontStretchFactor(float factor) {
        fontStretchFactor = factor;
    }

    public static float getFontStretchFactor() {
        return fontStretchFactor;
    }

    public char getChar() {
        return this.character;
    }

    public static int numberOfLoadedChars() {
        return characterCache.size();
    }

    public void setColor(float r, float g, float b) {
        this.getAppearance(true).getColoringAttributes(true).setColor(r, g, b);
    }

    public void setColor(Colorf color) {
        this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Colorf getColor() {
        return this.getAppearance(true).getColoringAttributes(true).getColor();
    }

    public Tuple2f getSize() {
        return this.size;
    }

    public float getWidth() {
        return this.size.getX();
    }

    public float getHeight() {
        return this.size.getY();
    }

    public String toString() {
        return super.toString() + " [" + this.getChar() + "]";
    }

    private Character2D(char character, Tuple2f size) {
        this.character = character;
        this.size = size;
    }

    public static Character2D loadCharacter(char character, float r, float g, float b, Font font) {
        tmpColor.set(r, g, b);
        String charId = String.valueOf(character) + "--" + font.hashCode() + "--" + tmpColor.hashCode();
        if (characterCache.containsKey(charId)) {
            Character2D original = characterCache.get(charId);
            Character2D copy = new Character2D(character, original.getSize());
            copy.setGeometry(original.getGeometry());
            copy.setAppearance(original.getAppearance());
            return copy;
        }
        ASCIITexture texture = Font2D.getFontTexture(font);
        Sized2iRO charSize = texture.getCharSize(character);
        if (charSize == null) {
            return null;
        }
        TriangleStripArray geometry = new TriangleStripArray(4, null);
        geometry.setOptimization(Geometry.Optimization.USE_VBOS);
        float[] vertices = new float[]{0.0f, -((float)charSize.getHeight()) * Character2D.getFontStretchFactor(), 0.0f, (float)charSize.getWidth() * Character2D.getFontStretchFactor(), -((float)charSize.getHeight()) * Character2D.getFontStretchFactor(), 0.0f, 0.0f, 0.0f, 0.0f, (float)charSize.getWidth() * Character2D.getFontStretchFactor(), 0.0f, 0.0f};
        geometry.setCoordinates(0, vertices);
        TexCoord2f[] tc = texture.getTextureCoordinates(character);
        float[] texCoords = new float[]{tc[0].getS(), tc[0].getT(), tc[1].getS(), tc[0].getT(), tc[0].getS(), tc[1].getT(), tc[1].getS(), tc[1].getT()};
        geometry.setTextureCoordinates(0, 0, 2, texCoords);
        Appearance app = new Appearance();
        app.setTransparencyAttributes(new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.0f));
        ColoringAttributes ca = new ColoringAttributes(r, g, b, ColoringAttributes.NICEST);
        app.setColoringAttributes(ca);
        app.setTexture(texture);
        Character2D newCharacter = new Character2D(character, new Tuple2f((float)charSize.getWidth() * Character2D.getFontStretchFactor(), (float)charSize.getHeight() * Character2D.getFontStretchFactor()));
        newCharacter.setGeometry(geometry);
        newCharacter.setAppearance(app);
        characterCache.put(charId, newCharacter);
        return newCharacter;
    }

    public static Character2D loadCharacter(char character, Colorf color, Font font) {
        return Character2D.loadCharacter(character, color.getRed(), color.getGreen(), color.getBlue(), font);
    }

    public static Character2D loadCharacter(char character, float r, float g, float b, String fontName, int resolution, int fontFlags) {
        return Character2D.loadCharacter(character, r, g, b, new Font(fontName, fontFlags, resolution));
    }

    public static Character2D loadCharacter(char character, Colorf color, String fontName, int resolution, int fontFlags) {
        return Character2D.loadCharacter(character, color.getRed(), color.getGreen(), color.getBlue(), fontName, fontFlags, resolution);
    }

    protected static Character2D loadCharacter(char character, float r, float g, float b, String charId) {
        StringTokenizer charIdAttributes = new StringTokenizer(charId, "-");
        return Character2D.loadCharacter(character, r, g, b, charIdAttributes.nextToken(), Integer.parseInt(charIdAttributes.nextToken()), Integer.parseInt(charIdAttributes.nextToken()));
    }

    protected static Character2D loadCharacter(char character, Colorf color, String charId) {
        return Character2D.loadCharacter(character, color.getRed(), color.getGreen(), color.getBlue(), charId);
    }
}

