/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.text2d;

import java.awt.Font;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.scenegraph.ASCIITexture;
import org.xith3d.ui.text2d.FontStyle;
import org.xith3d.utility.characters.CharIndex;

public class Font2D {
    private static final String CHARSET = "ISO-8859-1";
    private static final CharIndex cachedCharIndex = CharIndex.createHashOptimizedCharIndex("ISO-8859-1");
    private static HashMap<String, ASCIITexture> textureCache = new HashMap();
    private final FontStyle style;
    private final Font font;
    private final ASCIITexture texture;
    private final boolean isMonospace;

    public static final ASCIITexture getFontTexture(Font font) {
        String texKey = String.valueOf(font.hashCode());
        if (textureCache.containsKey(texKey)) {
            return textureCache.get(texKey);
        }
        ASCIITexture texture = ASCIITexture.create(null, font, cachedCharIndex);
        textureCache.put(texKey, texture);
        return texture;
    }

    public final Font getFont() {
        return this.font;
    }

    public final String getFamily() {
        return this.font.getFamily();
    }

    public final String getName() {
        return this.font.getName();
    }

    public final boolean isPlain() {
        return this.font.isPlain();
    }

    public final boolean isItalic() {
        return this.font.isItalic();
    }

    public final boolean isBold() {
        return this.font.isBold();
    }

    public final boolean isMonospace() {
        return this.isMonospace;
    }

    public final FontStyle getStyle() {
        return this.style;
    }

    public final int getSize() {
        return this.font.getSize();
    }

    public ASCIITexture getTexture() {
        return this.texture;
    }

    public final CharIndex getCharIndex() {
        return this.getTexture().getCharIndex();
    }

    public final Charset getCharset() {
        return this.getCharIndex().getCharset();
    }

    public final Sized2iRO getCharSize(char ch) {
        return this.getTexture().getCharSize(ch);
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Font2D)) {
            return false;
        }
        Font2D font2 = (Font2D)o;
        return font2.getFont().equals(this.getFont());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { family = \"" + this.getFamily() + "\", name = \"" + this.getName() + "\"" + (this.isMonospace() ? " (monospace)" : "") + ", style = " + (Object)((Object)this.getStyle()) + ", size = " + this.getSize() + " }";
    }

    public Font2D(Font font) {
        this.font = font;
        this.style = FontStyle.getFromAWTStyle(font.getStyle());
        this.texture = Font2D.getFontTexture(font);
        this.isMonospace = this.texture.getCharSize('.').getWidth() == this.texture.getCharSize('O').getWidth();
    }

    public Font2D(String fontName, FontStyle style, int size) {
        this(new Font(fontName, style.getAWTStyle(), size));
    }
}

