/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.characters;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.xith3d.utility.characters.CharIndex;

class GCOptimizedCharIndex
extends CharIndex {
    private Charset charset;
    private int[] arrayCache;
    private int numPrintables = -1;

    public final CharIndex.MemoryStrategy getMemoryStrategy() {
        return CharIndex.MemoryStrategy.GC_OPTIMIZED;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getTotalNumberOfCharacters() {
        return 32768;
    }

    public int getNumberOfPrintableChars() {
        return this.numPrintables;
    }

    public int getIndex(char ch) {
        return this.arrayCache[ch];
    }

    private int[] createArrayCache(Charset charset) {
        char c = this.getTotalNumberOfCharacters();
        int[] result = new int[c];
        CharBuffer charBuffer = CharBuffer.allocate(1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        CharsetEncoder encoder = charset.newEncoder();
        this.numPrintables = 0;
        for (char ch = '\u0000'; ch < c; ch = (char)(ch + '\u0001')) {
            if (GCOptimizedCharIndex.isPrintable(ch, encoder, charBuffer, byteBuffer)) {
                ++this.numPrintables;
            } else {
                result[ch] = -1;
            }
            charBuffer.clear();
            byteBuffer.clear();
        }
        return result;
    }

    public GCOptimizedCharIndex(Charset charset) {
        this.charset = charset;
        this.arrayCache = this.createArrayCache(charset);
    }
}

