/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.characters;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import org.xith3d.utility.characters.CharIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashOptimizedCharIndex
extends CharIndex {
    private Charset charset;
    private HashMap<Object, Integer> hashCache;
    private SingletonCharacter singChar = new SingletonCharacter('\u0000');

    @Override
    public final CharIndex.MemoryStrategy getMemoryStrategy() {
        return CharIndex.MemoryStrategy.HASH_OPTIMIZED;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int getTotalNumberOfCharacters() {
        return 32768;
    }

    @Override
    public int getNumberOfPrintableChars() {
        return this.hashCache.size();
    }

    @Override
    public int getIndex(char ch) {
        this.singChar.setChar(ch);
        Integer index = this.hashCache.get(this.singChar);
        if (index == null) {
            return -1;
        }
        return index;
    }

    private HashMap<Object, Integer> createHashCache(Charset charset) {
        char c = this.getTotalNumberOfCharacters();
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        CharBuffer charBuffer = CharBuffer.allocate(1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        CharsetEncoder encoder = charset.newEncoder();
        int numPrintables = 0;
        for (char ch = '\u0000'; ch < c; ch = (char)(ch + '\u0001')) {
            if (HashOptimizedCharIndex.isPrintable(ch, encoder, charBuffer, byteBuffer)) {
                result.put(new Character(ch), new Integer(numPrintables++));
            }
            charBuffer.clear();
            byteBuffer.clear();
        }
        return result;
    }

    public HashOptimizedCharIndex(Charset charset) {
        this.charset = charset;
        this.hashCache = this.createHashCache(charset);
    }

    private static class SingletonCharacter {
        private char ch;

        public void setChar(char ch) {
            this.ch = ch;
        }

        public char getChar() {
            return this.ch;
        }

        public int hashCode() {
            return this.ch;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Character) {
                return this.ch == ((Character)obj).charValue();
            }
            if (obj instanceof SingletonCharacter) {
                return this.ch == ((SingletonCharacter)obj).getChar();
            }
            return false;
        }

        public SingletonCharacter(char ch) {
            this.setChar(ch);
        }
    }
}

