/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.debug;

import java.awt.Window;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.listeners.InputStateListener;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.Updater;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.utility.debug.HelpWindow;
import org.xith3d.utility.sgtree.SGTree;
import org.xith3d.utility.timing.PerformanceStats;

public class DebugCenter
implements Updatable,
InputStateListener {
    private Xith3DEnvironment env;
    private PerformanceStats perf = null;
    private SGTree sgTree = null;
    private boolean sgTreeUpdateScheduled = false;
    private boolean controlPressed;
    private String appendString = " - Xith3D Debug Center Active (Press Ctrl+F1 for help)";
    private Window help;

    public DebugCenter(Xith3DEnvironment env, Updater updater) {
        this.env = env;
        updater.addUpdatable(this);
        InputSystem.getInstance().addInputStateListener((InputStateListener)this);
        this.perf = new PerformanceStats(false);
        updater.addUpdatable(this.perf);
        this.sgTree = new SGTree();
    }

    private void switchHelp() {
        if (this.help == null) {
            this.help = new HelpWindow();
        }
        this.help.setVisible(!this.help.isVisible());
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (!this.env.getCanvas().getTitle().endsWith(this.appendString)) {
            this.env.getCanvas().setTitle(this.env.getCanvas().getTitle() + this.appendString);
        }
        if (this.sgTreeUpdateScheduled) {
            this.sgTreeUpdateScheduled = false;
            assert (this.sgTree != null);
            this.sgTree.updateNodes(this.env);
        }
        Thread.yield();
    }

    public void onInputStateChanged(InputEvent e, DeviceComponent comp, int delta, int state) {
        if (comp == Keys.LEFT_CONTROL) {
            this.controlPressed = state > 0;
            return;
        }
        if (this.controlPressed) {
            if (comp == Keys.T) {
                this.sgTreeUpdateScheduled = true;
            } else if (comp == Keys.F1) {
                this.switchHelp();
            } else if (comp == Keys.S) {
                this.perf.print();
            }
        }
    }
}

