/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.general;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularArray<T> {
    private final T[] array;
    private int top;
    private int end;
    private int size;

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void push(T o) {
        if (this.size == this.array.length) {
            throw new ArrayIndexOutOfBoundsException("The CircularArray is full");
        }
        int pos = ++this.end % this.array.length;
        this.array[pos] = o;
    }

    public final T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.array[this.top];
    }

    public final T pop() {
        if (this.isEmpty()) {
            return null;
        }
        T o = this.peek();
        --this.top;
        if (this.top < 0) {
            this.top = this.array.length - 1;
        }
        return o;
    }

    public CircularArray(int size) {
        this.array = new Object[size];
        this.top = 0;
        this.end = -1;
        this.size = 0;
    }
}

