/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.general;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableList<E extends Comparable<E>>
implements List<E> {
    private Object[] array;
    private int size;
    private SLIterator iterator = new SLIterator();
    private SLListIterator listIterator = new SLListIterator();

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.array.length;
        if (minCapacity > oldCapacity) {
            Object[] oldArray = this.array;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            this.array = new Object[newCapacity];
            System.arraycopy(oldArray, 0, this.array, 0, oldCapacity);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        this.ensureCapacity(index + 1);
        if (index == this.size) {
            this.array[index] = element;
        } else if (index > this.size) {
            Arrays.fill(this.array, this.size, index - 1, null);
            this.array[index] = element;
        } else {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index - 1);
            this.array[index] = element;
        }
        this.size = index + 1;
    }

    @Override
    public boolean add(E element) {
        this.add(this.size, element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        this.ensureCapacity(this.size + coll.size());
        for (Comparable o : coll) {
            this.add((E)o);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        this.ensureCapacity(this.size + coll.size());
        if (index >= this.size) {
            if (index > this.size) {
                Arrays.fill(this.array, this.size, index - 1, null);
                this.size = index;
            }
            for (Comparable o : coll) {
                this.array[this.size++] = o;
            }
        } else {
            System.arraycopy(this.array, index, this.array, index + coll.size(), this.size - index - 1);
            for (Comparable o : coll) {
                this.array[index++] = o;
            }
            this.size += coll.size();
        }
        return coll.size() > 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        int result = 0;
        for (Object o : coll) {
            if (!this.contains(o)) continue;
            ++result;
        }
        return result == coll.size();
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (E)((Comparable)this.array[index]);
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.listIterator.reset();
        return this.listIterator;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public E remove(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object old = this.get(index);
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return (E)old;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        for (Object o : coll) {
            if (!this.remove(o)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result = false;
        for (int i = this.size - 1; i >= 0; --i) {
            if (coll.contains(this.array[i])) continue;
            this.remove(this.array[i]);
            result = true;
        }
        return result;
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object old = this.get(index);
        this.array[index] = element;
        return (E)old;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("not yet implemented.");
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.array, 0, result, 0, this.size());
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        if (a.length > this.size) {
            Arrays.fill(a, this.size, a.length, null);
        }
        return a;
    }

    public Object clone() {
        try {
            SortableList clone = (SortableList)super.clone();
            clone.array = (Comparable[])Array.newInstance(this.array.getClass().getComponentType(), this.array.length);
            System.arraycopy(this.array, 0, clone.array, 0, this.array.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void sort() {
        if (this.size > 1) {
            Arrays.sort(this.array, 0, this.size);
        }
    }

    public SortableList(int initialCapacity) {
        this.array = new Object[initialCapacity];
        this.size = 0;
    }

    public SortableList() {
        this(16);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SLListIterator
    implements ListIterator<E> {
        private int cursor = 0;
        private int lastCursor = -1;

        private SLListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SortableList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            this.lastCursor = this.cursor;
            return SortableList.this.get(this.cursor++);
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E previous() {
            this.lastCursor = this.cursor - 1;
            try {
                return SortableList.this.get(--this.cursor);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ++this.cursor;
                this.lastCursor = this.cursor;
                throw e;
            }
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void add(E e) {
            SortableList.this.add(this.cursor, e);
            ++this.cursor;
        }

        @Override
        public void remove() {
            SortableList.this.remove(this.cursor);
        }

        @Override
        public void set(E e) {
            SortableList.this.set(this.lastCursor, e);
        }

        public void reset() {
            this.cursor = 0;
            this.lastCursor = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SLIterator
    implements Iterator<E> {
        private int cursor = -1;

        private SLIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SortableList.this.size - 1;
        }

        @Override
        public E next() {
            return SortableList.this.get(++this.cursor);
        }

        @Override
        public void remove() {
            SortableList.this.remove(this.cursor);
        }

        public void reset() {
            this.cursor = -1;
        }
    }
}

