/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import java.util.Arrays;
import java.util.TreeSet;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.utility.geometry.VertexData;
import org.xith3d.utility.geometry.nvtristrip.PrimitiveGroup;
import org.xith3d.utility.geometry.nvtristrip.TriStrip;

public class GeometryInfo {
    protected static final int STATE_UNKNOWN = 0;
    protected static final int STATE_SPLIT = 1;
    protected static final int STATE_MERGED = 2;
    protected VertexData[] vertices;
    protected int[] triangles;
    protected int[] smoothGroups;
    private int vertexCacheSize = 16;
    protected int state = 0;

    public void recalculateFlatNormals() {
        this.unweldVertices();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f faceNormal = new Vector3f();
        int numFaces = this.triangles.length / 3;
        for (int face = 0; face < numFaces; ++face) {
            Point3f a = this.vertices[this.triangles[face * 3]].coord;
            Point3f b = this.vertices[this.triangles[face * 3 + 1]].coord;
            Point3f c = this.vertices[this.triangles[face * 3 + 2]].coord;
            v1.sub((TupleNf)b, (TupleNf)a);
            v2.sub((TupleNf)c, (TupleNf)a);
            faceNormal.cross(v1, v2);
            faceNormal.normalize();
            this.vertices[this.triangles[face * 3]].normal = new Vector3f((Tuple3f)faceNormal);
            this.vertices[this.triangles[face * 3 + 1]].normal = new Vector3f((Tuple3f)faceNormal);
            this.vertices[this.triangles[face * 3 + 2]].normal = new Vector3f((Tuple3f)faceNormal);
        }
    }

    public void recalculateSmoothGroupNormals() {
        int i;
        int i2;
        if (this.smoothGroups == null) {
            throw new IllegalStateException("Missing smooth group data");
        }
        for (i2 = 0; i2 < this.vertices.length; ++i2) {
            this.vertices[i2].normal = null;
        }
        this.unweldVertices();
        for (i2 = 0; i2 < this.smoothGroups.length; ++i2) {
            this.vertices[this.triangles[i2 * 3]].smoothGroup = this.smoothGroups[i2];
            this.vertices[this.triangles[i2 * 3 + 1]].smoothGroup = this.smoothGroups[i2];
            this.vertices[this.triangles[i2 * 3 + 2]].smoothGroup = this.smoothGroups[i2];
        }
        this.weldVertices();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f faceNormal = new Vector3f();
        int numFaces = this.triangles.length / 3;
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].normal = new Vector3f();
        }
        for (int face = 0; face < numFaces; ++face) {
            Point3f a = this.vertices[this.triangles[face * 3]].coord;
            Point3f b = this.vertices[this.triangles[face * 3 + 1]].coord;
            Point3f c = this.vertices[this.triangles[face * 3 + 2]].coord;
            v1.sub((TupleNf)b, (TupleNf)a);
            v2.sub((TupleNf)c, (TupleNf)a);
            faceNormal.cross(v1, v2);
            this.vertices[this.triangles[face * 3]].normal.add((TupleNf)faceNormal);
            this.vertices[this.triangles[face * 3 + 1]].normal.add((TupleNf)faceNormal);
            this.vertices[this.triangles[face * 3 + 2]].normal.add((TupleNf)faceNormal);
        }
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].normal.normalize();
            this.vertices[i].smoothGroup = -1;
        }
        this.state = 0;
    }

    public void weldVertices() {
        if (this.state == 2) {
            return;
        }
        TreeSet<VertexData> nverts = new TreeSet<VertexData>();
        for (int i = 0; i < this.vertices.length; ++i) {
            nverts.add(this.vertices[i]);
        }
        Object[] ndata = nverts.toArray(new VertexData[nverts.size()]);
        int[] nTriangles = new int[this.triangles.length];
        for (int i = 0; i < nTriangles.length; ++i) {
            nTriangles[i] = Arrays.binarySearch(ndata, this.vertices[this.triangles[i]]);
        }
        this.vertices = ndata;
        this.triangles = nTriangles;
        this.state = 2;
    }

    public void unweldVertices() {
        if (this.state == 1) {
            return;
        }
        VertexData[] ndata = new VertexData[this.triangles.length];
        for (int i = 0; i < this.triangles.length; ++i) {
            ndata[i] = new VertexData(this.vertices[this.triangles[i]]);
            this.triangles[i] = i;
        }
        this.vertices = ndata;
        this.state = 1;
    }

    public void optimizeTrianglesForCache() {
        TriStrip ts = new TriStrip();
        ts.setCacheSize(this.getVertexCacheSize());
        ts.setListsOnly(true);
        PrimitiveGroup[] pg = ts.generateStrips(this.triangles);
        assert (pg.length == 1);
        assert (pg[0].type == 0);
        this.smoothGroups = null;
        this.triangles = pg[0].getTrimmedIndices();
    }

    public int[] createContinousStrip() {
        TriStrip ts = new TriStrip();
        ts.setCacheSize(this.getVertexCacheSize());
        ts.setListsOnly(false);
        ts.setMinStripSize(0);
        ts.setStitchStrips(true);
        PrimitiveGroup[] pg = ts.generateStrips(this.triangles);
        assert (pg.length == 1);
        assert (pg[0].type == 1);
        return pg[0].getTrimmedIndices();
    }

    public int getVertexCacheSize() {
        return this.vertexCacheSize;
    }

    public void setVertexCacheSize(int vertexCacheSize) {
        this.vertexCacheSize = vertexCacheSize;
    }
}

