/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import org.openmali.spatial.TriangleContainer;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;

public class TangentsFactory {
    public static final TangentsFactory INSTANCE = new TangentsFactory();

    public static TangentsFactory getInstance() {
        return INSTANCE;
    }

    private static final void fixNegativeZero(Vector3f vec) {
        if (vec.getX() == -0.0f) {
            vec.setX(0.0f);
        }
        if (vec.getY() == -0.0f) {
            vec.setY(0.0f);
        }
        if (vec.getZ() == -0.0f) {
            vec.setZ(0.0f);
        }
    }

    public void calculateTangents(Geometry geom, TangentsStoreMode storeMode, int storeIndex1, int storeIndex2, Vector3f[] tangents, Vector3f[] bitangents) {
        if (!geom.hasFeature(2)) {
            throw new IllegalArgumentException("The GeometryArray must have normals.");
        }
        if (tangents == null && bitangents == null && storeMode == null) {
            throw new IllegalArgumentException("storeMode must not be null, if both arrays are null.");
        }
        int vertexCount = geom.getVertexCount();
        TriangleContainer triangCont = (TriangleContainer)geom;
        Vector3f[] tan1 = new Vector3f[vertexCount * 2];
        Vector3f[] tan2 = new Vector3f[vertexCount * 2];
        for (int i = 0; i < tan1.length; ++i) {
            tan1[i] = new Vector3f();
            tan2[i] = new Vector3f();
        }
        int triangleCount = triangCont.getTriangleCount();
        Triangle triangle = new Triangle();
        float[] w1 = new float[4];
        float[] w2 = new float[4];
        float[] w3 = new float[4];
        for (int i = 0; i < triangleCount; ++i) {
            triangCont.getTriangle(i, triangle);
            int i1 = triangle.getVertexIndexA();
            int i2 = triangle.getVertexIndexB();
            int i3 = triangle.getVertexIndexC();
            Point3f v1 = triangle.getVertexCoordA();
            Point3f v2 = triangle.getVertexCoordB();
            Point3f v3 = triangle.getVertexCoordC();
            geom.getTextureCoordinate(0, i1, w1);
            geom.getTextureCoordinate(0, i2, w2);
            geom.getTextureCoordinate(0, i3, w3);
            float x1 = v2.getX() - v1.getX();
            float x2 = v3.getX() - v1.getX();
            float y1 = v2.getY() - v1.getY();
            float y2 = v3.getY() - v1.getY();
            float z1 = v2.getZ() - v1.getZ();
            float z2 = v3.getZ() - v1.getZ();
            float s1 = w2[0] - w1[0];
            float s2 = w3[0] - w1[0];
            float t1 = w2[1] - w1[1];
            float t2 = w3[1] - w1[1];
            float r = 1.0f / (s1 * t2 - s2 * t1);
            Vector3f sdir = new Vector3f((t2 * x1 - t1 * x2) * r, (t2 * y1 - t1 * y2) * r, (t2 * z1 - t1 * z2) * r);
            Vector3f tdir = new Vector3f((s1 * x2 - s2 * x1) * r, (s1 * y2 - s2 * y1) * r, (s1 * z2 - s2 * z1) * r);
            tan1[i1].add((TupleNf)sdir);
            tan1[i2].add((TupleNf)sdir);
            tan1[i3].add((TupleNf)sdir);
            tan2[i1].add((TupleNf)tdir);
            tan2[i2].add((TupleNf)tdir);
            tan2[i3].add((TupleNf)tdir);
        }
        Vector3f normal = new Vector3f();
        Vector3f tmp = new Vector3f();
        Vector3f tmp2 = new Vector3f();
        Vector3f tangent = new Vector3f();
        Vector3f bitangent = new Vector3f();
        TexCoord3f tex = new TexCoord3f();
        Vector3f attrib = new Vector3f();
        for (int i = 0; i < vertexCount; ++i) {
            geom.getNormal(i, normal);
            Vector3f t = tan1[i];
            float d = normal.dot(t);
            tmp.set((TupleNf)normal);
            tmp.scale(d);
            tmp2.set((TupleNf)t);
            tmp2.sub((TupleNf)tmp);
            tangent.set((TupleNf)tmp2);
            tangent.normalize();
            TangentsFactory.fixNegativeZero(tangent);
            bitangent.cross(tangent, normal);
            TangentsFactory.fixNegativeZero(bitangent);
            if (storeMode == TangentsStoreMode.VERTEX_ATTRIBUTES) {
                attrib.set(tangent.getX(), tangent.getY(), tangent.getZ());
                geom.setVertexAttribute(storeIndex1, i, (TupleNf<?>)attrib);
                attrib.set(bitangent.getX(), bitangent.getY(), bitangent.getZ());
                geom.setVertexAttribute(storeIndex2, i, (TupleNf<?>)attrib);
            } else if (storeMode == TangentsStoreMode.TEXTURE_COORDINATES) {
                tex.set(tangent.getX(), tangent.getY(), tangent.getZ());
                geom.setTextureCoordinate(storeIndex1, i, (TexCoordf<?>)tex);
                tex.set(bitangent.getX(), bitangent.getY(), bitangent.getZ());
                geom.setTextureCoordinate(storeIndex2, i, (TexCoordf<?>)tex);
            }
            if (tangents != null) {
                if (tangents[i] == null) {
                    tangents[i] = new Vector3f((Tuple3f)tangent);
                } else {
                    tangents[i].set((TupleNf)tangent);
                }
            }
            if (bitangents == null) continue;
            if (bitangents[i] == null) {
                bitangents[i] = new Vector3f((Tuple3f)bitangent);
                continue;
            }
            bitangents[i].set((TupleNf)bitangent);
        }
    }

    public void calculateTangents(Geometry geom, TangentsStoreMode storeMode, int storeIndex1, int storeIndex2) {
        if (storeMode == null) {
            throw new IllegalArgumentException("storeMode must not be null.");
        }
        this.calculateTangents(geom, storeMode, storeIndex1, storeIndex2, null, null);
    }

    protected TangentsFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TangentsStoreMode {
        TEXTURE_COORDINATES,
        VERTEX_ATTRIBUTES;

    }
}

