/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry.nvtristrip;

public class PrimitiveGroup {
    public static final int PT_LIST = 0;
    public static final int PT_STRIP = 1;
    public static final int PT_FAN = 2;
    public int type = 1;
    public int[] indices;
    public int numIndices;

    public String getTypeString() {
        switch (this.type) {
            case 0: {
                return "list";
            }
            case 1: {
                return "strip";
            }
            case 2: {
                return "fan";
            }
        }
        return "????";
    }

    public String toString() {
        return this.getTypeString() + " : " + this.numIndices;
    }

    public String getFullInfo() {
        if (this.type != 1) {
            return this.toString();
        }
        int[] stripLengths = new int[this.numIndices];
        int prev = -1;
        int length = -1;
        for (int i = 0; i < this.numIndices; ++i) {
            if (this.indices[i] == prev) {
                int n = length;
                stripLengths[n] = stripLengths[n] + 1;
                length = -1;
                prev = -1;
                continue;
            }
            prev = this.indices[i];
            ++length;
        }
        int n = length;
        stripLengths[n] = stripLengths[n] + 1;
        StringBuffer sb = new StringBuffer();
        sb.append("Strip:").append(this.numIndices).append("\n");
        for (int i = 0; i < stripLengths.length; ++i) {
            if (stripLengths[i] <= 0) continue;
            sb.append(i).append("->").append(stripLengths[i]).append("\n");
        }
        return sb.toString();
    }

    public int[] getTrimmedIndices() {
        if (this.indices.length == this.numIndices) {
            return this.indices;
        }
        int[] nind = new int[this.numIndices];
        System.arraycopy(this.indices, 0, nind, 0, this.numIndices);
        return nind;
    }
}

