/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.hud.editor.info;

import java.lang.reflect.Constructor;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.WidgetEventsReceiverAdapter;

public abstract class HEInfo_Widget {
    private Widget widget;
    private final Point2f location;
    private final Dim2f size;

    public HEInfo_Widget(Tuple2f location, Sized2fRO size) {
        this.location = new Point2f(location);
        this.size = new Dim2f(size);
    }

    protected void setWidget(Widget widget) {
        this.widget = widget;
        WidgetEventsReceiverAdapter wera = new WidgetEventsReceiverAdapter(){

            public void onWidgetLocationChanged(Widget widget, float oldLeft, float oldTop, float newLeft, float newTop) {
                HEInfo_Widget.this.location.setX(newLeft);
                HEInfo_Widget.this.location.setY(newTop);
            }

            public void onWidgetSizeChanged(Widget widget, float oldWidth, float oldHeight, float newWidth, float newHeight) {
                HEInfo_Widget.this.size.setWidth(newWidth);
                HEInfo_Widget.this.size.setHeight(newHeight);
            }
        };
        widget.addLocationListener(wera);
        widget.addSizeListener(wera);
    }

    public boolean setLocation(float x, float y) {
        boolean result = x != this.widget.getLeft() || y != this.widget.getTop();
        this.location.set(x, y);
        this.widget.setLocation((Tuple2f)this.location);
        return result;
    }

    public final boolean setLocation(Tuple2f location) {
        return this.setLocation(location.getX(), location.getY());
    }

    public final Point2f getLocation() {
        return this.location;
    }

    public boolean setSize(float width, float height) {
        boolean result = width != this.widget.getWidth() || height != this.widget.getHeight();
        this.size.set(width, height);
        this.widget.setSize((Sized2fRO)this.size);
        return result;
    }

    public final boolean setSize(Sized2fRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    public final Dim2f getSize() {
        return this.size;
    }

    public final Widget getWidget() {
        return this.widget;
    }

    public static HEInfo_Widget newWidget(String clazzName, Tuple2f location, Sized2fRO size) {
        HEInfo_Widget widgetInfo = null;
        try {
            Class<?> infoClazz = Thread.currentThread().getContextClassLoader().loadClass(HEInfo_Widget.class.getPackage().getName() + ".HEInfo_" + clazzName);
            Constructor<?> ic = infoClazz.getConstructor(Tuple2f.class, Tuple2f.class);
            widgetInfo = (HEInfo_Widget)ic.newInstance(location, size);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return widgetInfo;
    }
}

