/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.input;

import org.jagatoo.input.actions.AbstractLabeledInvokableInputAction;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.xith3d.input.FirstPersonInputHandler;

public class MouseYFlipAction
extends AbstractLabeledInvokableInputAction {
    private final FirstPersonInputHandler fpih;
    private final boolean keyStateDependent;

    public String invokeAction(InputDevice device, DeviceComponent comp, int delta, int state, long nanoTime) {
        if (this.keyStateDependent) {
            boolean bool = state > 0;
            float absYSpeed = Math.abs(this.fpih.getMouseYSpeed());
            if (bool) {
                this.fpih.setMouseYSpeed(absYSpeed * -1.0f);
            } else {
                this.fpih.setMouseYSpeed(absYSpeed);
            }
            return bool ? "inverted" : "non-inverted";
        }
        if (delta <= 0) {
            return null;
        }
        this.fpih.flipMouseYAxis();
        return "flipped";
    }

    public MouseYFlipAction(int ordinal, String text, FirstPersonInputHandler fpih, boolean keyStateDependent) {
        super(ordinal, text);
        if (fpih == null) {
            throw new NullPointerException("fpih must not be null");
        }
        this.fpih = fpih;
        this.keyStateDependent = keyStateDependent;
    }

    public MouseYFlipAction(FirstPersonInputHandler fpih, boolean keyStateDependent) {
        this(-1, "Flip Mouse Y", fpih, keyStateDependent);
    }

    public MouseYFlipAction(int ordinal, String text, FirstPersonInputHandler fpih) {
        this(ordinal, text, fpih, false);
    }

    public MouseYFlipAction(FirstPersonInputHandler fpih) {
        this(-1, "Flip Mouse Y", fpih);
    }
}

