/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.launching;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.utility.awt.WindowHelper;

public abstract class DisplayOptions
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1493957380741174538L;
    protected OpenGLLayer currentOGLLayer;
    protected String currentDisplayMode;
    protected DisplayMode.FullscreenMode currentFullscreenMode;
    protected boolean currentVSync;
    protected FSAA currentFSAA;
    private JComboBox oglSelector;
    private Map<OpenGLLayer, Integer> oglCBIndices;
    private JComboBox dspModeSelector;
    private JCheckBox fsCheck;
    private JCheckBox vsyncCheck;
    private JComboBox fsaaSelector;
    private Map<FSAA, Integer> fsaaCBIndices;
    private JButton startButton;
    private boolean isStartRequested = false;

    protected File getPropertiesFileFolder() {
        File userHomeDir = new File((String)System.getProperties().get("user.home"));
        return new File(userHomeDir, ".xith3d");
    }

    protected String getPropertiesFilename() {
        return "displayoptions_selection.properties";
    }

    protected String getPropertiesComment() {
        return "Last selected items in the DisplayOptions";
    }

    protected File findPropertiesFile(boolean forcePathExistance) {
        try {
            File xithTLPropsFile = null;
            File xithPropsDir = this.getPropertiesFileFolder();
            if (!xithPropsDir.exists() && forcePathExistance) {
                xithPropsDir.mkdir();
            }
            if (xithPropsDir.exists()) {
                xithTLPropsFile = new File(xithPropsDir, this.getPropertiesFilename());
            }
            return xithTLPropsFile;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Properties createProperties() {
        Properties props = new Properties();
        props.setProperty("displayoptions.openGLLayer", String.valueOf(this.getCurrentOGLLayer()));
        props.setProperty("displayoptions.displayMode", this.getCurrentDisplayMode().toLightString());
        props.setProperty("displayoptions.fullscreen", String.valueOf((Object)this.getCurrentFullscreenMode()));
        props.setProperty("displayoptions.vsync", String.valueOf(this.getCurrentVSync()));
        props.setProperty("displayoptions.fsaa", String.valueOf((Object)this.getCurrentFSAA()));
        return props;
    }

    private void saveSelections() {
        try {
            File propertiesFile = this.findPropertiesFile(true);
            if (propertiesFile != null) {
                Properties props = this.createProperties();
                props.store(new BufferedOutputStream(new FileOutputStream(propertiesFile)), this.getPropertiesComment());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Properties loadProperties(File propertiesFile) throws IOException {
        Properties props = new Properties();
        if (propertiesFile != null && propertiesFile.exists()) {
            props.load(new BufferedInputStream(new FileInputStream(propertiesFile)));
        }
        return props;
    }

    protected void restoreSelections(Properties props) throws Throwable {
        this.setCurrentOGLLayer(OpenGLLayer.valueOf(props.getProperty("displayoptions.openGLLayer", "LWJGL")));
        this.setCurrentDisplayMode(DisplayMode.parseDisplayMode(this.getCurrentOGLLayer(), props.getProperty("displayoptions.displayMode", "800X600x24x75")));
        this.setCurrentFullscreenMode(DisplayMode.FullscreenMode.valueOf(props.getProperty("displayoptions.fullscreen", "WINDOWED")));
        this.setCurrentVSync(Boolean.valueOf(props.getProperty("displayoptions.vsync", "true")));
        this.setCurrentFSAA(FSAA.valueOf(props.getProperty("displayoptions.fsaa", "OFF")));
    }

    private void restoreSelections() {
        try {
            File propertiesFile = this.findPropertiesFile(false);
            if (propertiesFile != null && propertiesFile.exists()) {
                Properties props = this.loadProperties(propertiesFile);
                this.restoreSelections(props);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected abstract boolean onStartButtonClicked();

    protected void setStartButtonEnabled(boolean enabled) {
        this.startButton.setEnabled(enabled);
    }

    public void requestStart() {
        this.saveSelections();
        this.setVisible(false);
        this.onStartButtonClicked();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            if (e.getActionCommand().startsWith("FULLSCREEN::")) {
                this.currentFullscreenMode = ((JCheckBox)e.getSource()).isSelected() ? DisplayMode.FullscreenMode.FULLSCREEN : DisplayMode.FullscreenMode.WINDOWED;
            } else if (e.getActionCommand().startsWith("VSYNC::")) {
                this.currentVSync = ((JCheckBox)e.getSource()).isSelected();
            }
        } else if (e.getSource() instanceof JComboBox) {
            Object selItem;
            JComboBox cb;
            if (e.getActionCommand().startsWith("OPENGL_LAYER::")) {
                cb = (JComboBox)e.getSource();
                selItem = cb.getSelectedItem();
                this.currentOGLLayer = OpenGLLayer.valueOf((String)selItem);
                this.refillDisplayModeSelector();
            }
            if (e.getActionCommand().startsWith("DISPLAY_MODE::")) {
                cb = (JComboBox)e.getSource();
                selItem = cb.getSelectedItem();
                this.currentDisplayMode = (String)selItem;
            }
            if (e.getActionCommand().startsWith("FSAA::")) {
                cb = (JComboBox)e.getSource();
                selItem = cb.getSelectedItem();
                this.currentFSAA = FSAA.valueOf(((String)selItem).substring(6));
            }
        } else if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("CANCEL")) {
                this.setVisible(false);
                System.exit(0);
            } else if (e.getActionCommand().equals("START")) {
                this.requestStart();
            }
        }
    }

    private static final String[] getValidOpenGLLayersAsString() {
        int n = OpenGLLayer.values().length;
        String[] tmpItems = new String[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            OpenGLLayer ogl = OpenGLLayer.values()[i];
            if (ogl == OpenGLLayer.JOGL_SWT) continue;
            tmpItems[j++] = ogl.name();
        }
        String[] items = new String[j];
        System.arraycopy(tmpItems, 0, items, 0, j);
        return items;
    }

    protected JComponent createOpenGLLayerSelector() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setMinimumSize(new Dimension(1, 20));
        panel.setPreferredSize(new Dimension(1, 20));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        String[] items = DisplayOptions.getValidOpenGLLayersAsString();
        this.oglSelector = new JComboBox<String>(items);
        this.oglSelector.setSelectedIndex(0);
        this.oglSelector.setActionCommand("OPENGL_LAYER::");
        this.oglSelector.addActionListener(this);
        this.oglCBIndices = new HashMap<OpenGLLayer, Integer>();
        for (int i = 0; i < items.length; ++i) {
            this.oglCBIndices.put(OpenGLLayer.valueOf(items[i]), i);
        }
        panel.add(this.oglSelector);
        return panel;
    }

    public void setCurrentOGLLayer(OpenGLLayer oglLayer) {
        int index = this.oglCBIndices.get(oglLayer);
        this.oglSelector.setSelectedIndex(index);
        this.currentOGLLayer = oglLayer;
    }

    public OpenGLLayer getCurrentOGLLayer() {
        return this.currentOGLLayer;
    }

    protected void refillDisplayModeSelector() {
        DisplayMode currDspMode = this.getCurrentDisplayMode();
        DisplayMode[] displayModes = DisplayModeSelector.getImplementation(this.getCurrentOGLLayer()).getAvailableModes();
        Vector<String> modeStrings = new Vector<String>();
        for (DisplayMode displayMode : displayModes) {
            modeStrings.add(displayMode.toLightString());
        }
        this.dspModeSelector.setModel(new DefaultComboBoxModel(modeStrings));
        this.setCurrentDisplayMode(currDspMode);
    }

    protected final JComponent createDisplayModeSelector() {
        this.dspModeSelector = new JComboBox<String>(new String[0]);
        this.dspModeSelector.setMinimumSize(new Dimension(1, 20));
        this.dspModeSelector.setPreferredSize(new Dimension(1, 20));
        this.dspModeSelector.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.dspModeSelector.setActionCommand("DISPLAY_MODE::");
        this.dspModeSelector.addActionListener(this);
        this.refillDisplayModeSelector();
        return this.dspModeSelector;
    }

    public void setCurrentDisplayMode(DisplayMode displayMode) {
        int found = 0;
        int selIndex = 0;
        block5: for (int i = 0; i < this.dspModeSelector.getItemCount(); ++i) {
            String[] modeParts = ((String)this.dspModeSelector.getItemAt(i)).split("x");
            int width = Integer.parseInt(modeParts[0]);
            int height = Integer.parseInt(modeParts[1]);
            int bpp = modeParts[2].equals("?") ? 24 : Integer.parseInt(modeParts[2]);
            int freq = modeParts[3].equals("?") ? 75 : Integer.parseInt(modeParts[3]);
            switch (found) {
                case 0: {
                    DisplayMode dm0 = DisplayModeSelector.getImplementation(this.getCurrentOGLLayer()).getBestMode(width, height);
                    if (dm0.getWidth() != displayMode.getWidth() || dm0.getHeight() != displayMode.getHeight()) continue block5;
                    selIndex = i;
                    found = 1;
                    continue block5;
                }
                case 1: {
                    DisplayMode dm1 = DisplayModeSelector.getImplementation(this.getCurrentOGLLayer()).getBestMode(width, height, bpp);
                    if (dm1.getWidth() != displayMode.getWidth() || dm1.getHeight() != displayMode.getHeight() || dm1.getBPP() != displayMode.getBPP()) continue block5;
                    selIndex = i;
                    found = 2;
                    continue block5;
                }
                case 2: {
                    DisplayMode dm2 = DisplayModeSelector.getImplementation(this.getCurrentOGLLayer()).getBestMode(width, height, bpp, freq);
                    if (dm2.getWidth() != displayMode.getWidth() || dm2.getHeight() != displayMode.getHeight() || dm2.getBPP() != displayMode.getBPP() || dm2.getFrequency() != displayMode.getFrequency()) continue block5;
                    selIndex = i;
                    continue block5;
                }
            }
        }
        if (this.dspModeSelector.getItemCount() > 0) {
            this.dspModeSelector.setSelectedIndex(selIndex);
        }
        this.currentDisplayMode = displayMode.toLightString();
    }

    public DisplayMode getCurrentDisplayMode() {
        String[] modeParts = this.currentDisplayMode.split("x");
        int width = Integer.parseInt(modeParts[0]);
        int height = Integer.parseInt(modeParts[1]);
        int bpp = modeParts[2].equals("?") ? 24 : Integer.parseInt(modeParts[2]);
        int freq = modeParts[3].equals("?") ? 75 : Integer.parseInt(modeParts[3]);
        return DisplayModeSelector.getImplementation(this.getCurrentOGLLayer()).getBestMode(width, height, bpp, freq);
    }

    protected JComponent createFullscreenSelector() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setMinimumSize(new Dimension(1, 20));
        panel.setPreferredSize(new Dimension(1, 20));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.fsCheck = new JCheckBox("Fullscreen", this.currentFullscreenMode.isFullscreen());
        this.fsCheck.setActionCommand("FULLSCREEN::");
        this.fsCheck.addActionListener(this);
        panel.add(this.fsCheck);
        return panel;
    }

    protected JComponent createVSyncSelector() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setMinimumSize(new Dimension(1, 20));
        panel.setPreferredSize(new Dimension(1, 20));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.vsyncCheck = new JCheckBox("V-Sync", this.currentVSync);
        this.vsyncCheck.setActionCommand("VSYNC::");
        this.vsyncCheck.addActionListener(this);
        panel.add(this.vsyncCheck);
        return panel;
    }

    public void setCurrentFullscreenMode(DisplayMode.FullscreenMode fs) {
        this.fsCheck.setSelected(fs.isFullscreen());
        this.currentFullscreenMode = fs;
    }

    public DisplayMode.FullscreenMode getCurrentFullscreenMode() {
        return this.currentFullscreenMode;
    }

    public void setCurrentVSync(boolean vsync) {
        this.vsyncCheck.setSelected(vsync);
        this.currentVSync = vsync;
    }

    public boolean getCurrentVSync() {
        return this.currentVSync;
    }

    protected JComponent createFSAASelector() {
        int i;
        String[] items = new String[FSAA.values().length];
        for (i = 0; i < FSAA.values().length; ++i) {
            items[i] = "FSAA: " + (Object)((Object)FSAA.values()[i]);
        }
        this.fsaaSelector = new JComboBox<String>(items);
        this.fsaaSelector.setMinimumSize(new Dimension(1, 20));
        this.fsaaSelector.setPreferredSize(new Dimension(1, 20));
        this.fsaaSelector.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.fsaaSelector.setActionCommand("FSAA::");
        this.fsaaSelector.addActionListener(this);
        this.fsaaCBIndices = new HashMap<FSAA, Integer>();
        i = 0;
        for (FSAA fsaa : FSAA.values()) {
            this.fsaaCBIndices.put(fsaa, i++);
        }
        return this.fsaaSelector;
    }

    public void setCurrentFSAA(FSAA fsaa) {
        int index = this.fsaaCBIndices.get((Object)fsaa);
        this.fsaaSelector.setSelectedIndex(index);
        this.currentFSAA = fsaa;
    }

    public FSAA getCurrentFSAA() {
        return this.currentFSAA;
    }

    protected JComponent createNorthComponent() {
        return null;
    }

    protected JComponent createCenterComponent() {
        return null;
    }

    protected JComponent createWestComponent() {
        return null;
    }

    protected JComponent createNorthWestComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder(new LineBorder(Color.BLACK, 2), "Configuration"));
        p.add(this.createOpenGLLayerSelector());
        p.add(Box.createVerticalStrut(5));
        p.add(this.createDisplayModeSelector());
        p.add(Box.createVerticalStrut(5));
        p.add(this.createFullscreenSelector());
        p.add(Box.createVerticalStrut(5));
        p.add(this.createVSyncSelector());
        p.add(Box.createVerticalStrut(5));
        p.add(this.createFSAASelector());
        return p;
    }

    protected JComponent createSouthWestComponent() {
        URL location = this.getClass().getClassLoader().getResource("resources/org/xith3d/pictures/Xith3D-Logo.png");
        if (location == null) {
            return null;
        }
        final ImageIcon icon = new ImageIcon(location);
        final double q = (double)icon.getIconWidth() / (double)icon.getIconHeight();
        JComponent logo = new JComponent(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int w = this.getWidth() - 6;
                int h = (int)((double)w / q);
                g.drawImage(icon.getImage(), 3, this.getHeight() - 3 - h, w, h, this);
            }
        };
        logo.setMinimumSize(new Dimension(0, 0));
        logo.setPreferredSize(new Dimension(150, 150 / (int)q));
        logo.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        return logo;
    }

    protected JComponent createEastComponent() {
        return null;
    }

    protected JComponent createNorthEastComponent() {
        return null;
    }

    protected JComponent createSouthEastComponent() {
        return null;
    }

    protected JComponent createSouthComponent() {
        return null;
    }

    protected JComponent createFooterComponent() {
        int height = 41;
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        JPanel comp = new JPanel(fl);
        comp.setMinimumSize(new Dimension(0, 41));
        comp.setPreferredSize(new Dimension(Integer.MAX_VALUE, 41));
        comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, 41));
        comp.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("START");
        this.startButton.addActionListener(this);
        this.setStartButtonEnabled(true);
        comp.add((Component)this.startButton, null);
        JButton cancelButton = new JButton("Close");
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        comp.add((Component)cancelButton, null);
        return comp;
    }

    protected void setIcon() {
        try {
            BufferedImage icon = ImageIO.read(this.getClass().getClassLoader().getResource("resources/org/xith3d/pictures/Xith3D-Icon.png"));
            this.setIconImage(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Dimension buildGUI() {
        int pw2;
        int pw1;
        int mw2;
        int mw1;
        GridBagConstraints gbc;
        Dimension minSize = new Dimension(100, 100);
        Dimension prefSize = new Dimension(100, 200);
        Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        GridBagLayout westGbl = new GridBagLayout();
        GridBagLayout eastGbl = new GridBagLayout();
        JComponent north = this.createNorthComponent();
        JComponent center = this.createCenterComponent();
        JComponent west = this.createWestComponent();
        JComponent east = this.createEastComponent();
        JComponent south = this.createSouthComponent();
        JComponent footer = this.createFooterComponent();
        JPanel p0 = new JPanel(new BorderLayout());
        JPanel p1 = new JPanel(gbl);
        this.getContentPane().add((Component)p0, "Center");
        p0.add((Component)p1, "Center");
        if (north != null) {
            p0.add((Component)north, "North");
            minSize.height += north.getMinimumSize().height;
            prefSize.height += north.getPreferredSize().height;
        }
        if (center != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbl.setConstraints(center, gbc);
            p1.add(center);
            if (center.isMinimumSizeSet()) {
                minSize.width += -100 + center.getMinimumSize().width;
                minSize.height += -100 + center.getMinimumSize().height;
            }
            if (center.isPreferredSizeSet()) {
                prefSize.width += -100 + center.getPreferredSize().width;
                prefSize.height += -200 + center.getPreferredSize().height;
            }
        }
        if (west != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbl.setConstraints(west, gbc);
            p1.add(west);
            minSize.width += west.getMinimumSize().width;
            prefSize.width += west.getPreferredSize().width;
        } else {
            JComponent northWest = this.createNorthWestComponent();
            JComponent southWest = this.createSouthWestComponent();
            mw1 = 0;
            mw2 = 0;
            pw1 = 0;
            pw2 = 0;
            JPanel westPanel = null;
            if (northWest != null || southWest != null) {
                westPanel = new JPanel();
                westGbl = new GridBagLayout();
                westPanel.setLayout(westGbl);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                gbc.anchor = 18;
                gbl.setConstraints(westPanel, gbc);
                p1.add(westPanel);
            }
            if (northWest != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 2;
                gbc.anchor = 18;
                westGbl.setConstraints(northWest, gbc);
                westPanel.add(northWest);
                mw1 = northWest.getMinimumSize().width;
                pw1 = northWest.getPreferredSize().width;
            }
            if (westPanel != null) {
                // empty if block
            }
            if (southWest != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 2;
                gbc.anchor = 16;
                westGbl.setConstraints(southWest, gbc);
                westPanel.add(southWest);
                mw2 = southWest.getMinimumSize().width;
                pw2 = southWest.getPreferredSize().width;
            }
            minSize.width += Math.max(mw1, mw2);
            prefSize.width += Math.max(pw1, pw2);
        }
        if (east != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 13;
            gbl.setConstraints(east, gbc);
            p1.add(east);
            minSize.width += east.getMinimumSize().width;
            prefSize.width += east.getPreferredSize().width;
        } else {
            JComponent northEast = this.createNorthEastComponent();
            JComponent southEast = this.createSouthEastComponent();
            mw1 = 0;
            mw2 = 0;
            pw1 = 0;
            pw2 = 0;
            JPanel eastPanel = null;
            if (northEast != null || southEast != null) {
                eastPanel = new JPanel();
                eastGbl = new GridBagLayout();
                eastPanel.setLayout(eastGbl);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                gbc.anchor = 12;
                gbl.setConstraints(eastPanel, gbc);
                p1.add(eastPanel);
            }
            if (northEast != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 2;
                gbc.anchor = 12;
                eastGbl.setConstraints(northEast, gbc);
                eastPanel.add(northEast);
                mw1 = northEast.getMinimumSize().width;
                pw1 = northEast.getPreferredSize().width;
            }
            if (eastPanel != null) {
                // empty if block
            }
            if (southEast != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 2;
                gbc.anchor = 14;
                eastGbl.setConstraints(southEast, gbc);
                eastPanel.add(southEast);
                mw2 = southEast.getMinimumSize().width;
                pw2 = southEast.getPreferredSize().width;
            }
            minSize.width += Math.max(mw1, mw2);
            prefSize.width += Math.max(pw1, pw2);
        }
        if (south != null) {
            p0.add((Component)south, "South");
            minSize.height += south.getMinimumSize().height;
            prefSize.height += south.getPreferredSize().height;
        }
        if (footer != null) {
            this.getContentPane().add((Component)footer, "South");
            minSize.height += footer.getMinimumSize().height;
            prefSize.height += footer.getPreferredSize().height;
        }
        this.setMinimumSize(minSize);
        this.setPreferredSize(prefSize);
        this.setMaximumSize(maxSize);
        return prefSize;
    }

    protected void waitForStart() {
        this.isStartRequested = false;
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.toFront();
        this.requestFocus();
        while (!this.isStartRequested) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.setVisible(false);
        if (!this.onStartButtonClicked()) {
            this.waitForStart();
        }
    }

    protected DisplayOptions(String title, OpenGLLayer oglLayer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa) {
        super(title);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.currentOGLLayer = oglLayer;
        this.currentDisplayMode = displayMode.toLightString();
        this.currentFullscreenMode = fullscreen;
        this.currentVSync = vsync;
        this.currentFSAA = fsaa;
        this.setIcon();
        this.setSize(this.buildGUI());
        WindowHelper.center(this);
        this.restoreSelections();
        this.waitForStart();
    }

    protected DisplayOptions(String title, OpenGLLayer oglLayer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, FSAA fsaa) {
        this(title, oglLayer, displayMode, fullscreen, DisplayMode.VSYNC_ENABLED, fsaa);
    }

    protected DisplayOptions(String title, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa) {
        this(title, OpenGLLayer.getDefault(), displayMode, fullscreen, vsync, fsaa);
    }

    protected DisplayOptions(String title, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, FSAA fsaa) {
        this(title, OpenGLLayer.getDefault(), displayMode, fullscreen, fsaa);
    }

    protected DisplayOptions(String title, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync) {
        this(title, displayMode, fullscreen, vsync, FSAA.OFF);
    }

    protected DisplayOptions(String title, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen) {
        this(title, displayMode, fullscreen, FSAA.OFF);
    }

    protected DisplayOptions(String title, DisplayMode displayMode) {
        this(title, displayMode, DisplayMode.FullscreenMode.WINDOWED);
    }

    protected DisplayOptions(String title, boolean vsync) {
        this(title, DisplayModeSelector.getImplementation(OpenGLLayer.JOGL_AWT).getBestMode(800, 600), DisplayMode.FullscreenMode.WINDOWED, vsync);
    }

    protected DisplayOptions(String title) {
        this(title, DisplayModeSelector.getImplementation(OpenGLLayer.JOGL_AWT).getBestMode(800, 600));
    }

    protected DisplayOptions(boolean vsync) {
        this("Xith3DApplicationLauncher", vsync);
    }

    protected DisplayOptions() {
        this("Xith3DApplicationLauncher");
    }
}

