/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.launching;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xith3d.utility.logging.X3DLog;

public class Xith3DLauncher {
    private static ClassLoader cl;

    public static void main(String[] args) {
        try {
            String classpathspec = System.getProperty("xith3d.cp", System.getProperty("xith3d.classpath", null));
            String mainclassspec = System.getProperty("xith3d.mc", System.getProperty("xith3d.mainclass", null));
            if (classpathspec == null) {
                throw new IllegalArgumentException("Missing system property 'xith3d.classpath'!");
            }
            if (mainclassspec == null) {
                throw new IllegalArgumentException("Missing system property 'xith3d.mainclass'!");
            }
            ArrayList<URL> classpath = new ArrayList<URL>(8);
            String last = null;
            String current = "";
            StringTokenizer tokenizer = new StringTokenizer(classpathspec, ";:", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equals(":") && !token.equals(";")) {
                    current = current + token;
                    if (token.length() < 3) {
                        last = token;
                        continue;
                    }
                    File location = new File(current);
                    if (!location.exists()) {
                        System.err.println("Warning: classpathspec location '" + current + "' does not exist!");
                        continue;
                    }
                    try {
                        classpath.add(location.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Warning: could not convert location '" + current + "' to an URL!");
                        continue;
                    }
                    current = "";
                    last = null;
                    continue;
                }
                if (last == null) continue;
                current = current + token;
            }
            cl = new IsolationClassLoader(classpath.toArray(new URL[classpath.size()]), Xith3DLauncher.class.getClassLoader());
            Class<?> mainClass = cl.loadClass(mainclassspec);
            mainClass.getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            X3DLog.error("Error starting application: ", e.getMessage());
            X3DLog.error("Stacktrace: ");
            X3DLog.print(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsolationClassLoader
    extends URLClassLoader {
        private ClassLoader parent;

        public IsolationClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, (ClassLoader)null);
            this.parent = parent;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.parent.loadClass(name);
            }
        }
    }
}

