/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.math;

import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.utility.math.Interpolator;

public class InterpolatorTimer
extends ScheduledOperationImpl {
    private Interpolator interpolator;
    private long beginTime;
    private long endTime;
    private long extent;

    public InterpolatorTimer(Interpolator interpolator, long beginTime, long endTime) {
        super(true);
        this.interpolator = interpolator;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.extent = endTime - beginTime;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        long millis = timingMode.getMilliSeconds(gameTime);
        if (millis > this.endTime) {
            this.setAlive(false);
            return;
        }
        this.interpolator.setAlpha((millis - this.beginTime) / this.extent);
    }
}

