/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.math;

import org.jagatoo.util.timing.Time;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.utility.math.Interpolator;

public class TimedInterpolator
extends ScheduledOperationImpl {
    private Time beginTime;
    private Time endTime;
    private Interpolator interpolator;
    private OperationScheduler opSched;

    public TimedInterpolator(Interpolator interpolator, Time beginTime, Time endTime, OperationScheduler opSched) {
        super(true);
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.interpolator = interpolator;
        this.opSched = opSched;
        opSched.scheduleOperation(this);
    }

    public TimedInterpolator(Interpolator interpolator, Time beginTime, double length, OperationScheduler opSched) {
        this(interpolator, beginTime, new Time(beginTime.getValue() + length, beginTime.getUnit()), opSched);
    }

    public TimedInterpolator(Interpolator interpolator, Time length, OperationScheduler opSched) {
        this(interpolator, new Time(-1.0, length.getUnit()), length, opSched);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        long millis = timingMode.getMilliSeconds(gameTime);
        if (this.beginTime.getValue() == -1.0) {
            this.beginTime = new Time((double)millis, 1.0);
            double endTimeMillis = this.endTime.getMilliseconds();
            double realEndTime = endTimeMillis + (double)millis;
            this.endTime = new Time(realEndTime, 1.0);
        }
        if ((double)millis > this.endTime.getMilliseconds()) {
            this.interpolator.setAlpha(1.0f);
            this.opSched.unscheduleOperation(this);
        } else if ((double)millis > this.beginTime.getMilliseconds()) {
            float alpha = (float)(((double)millis - this.beginTime.getMilliseconds()) / (this.endTime.getMilliseconds() - this.beginTime.getMilliseconds()));
            this.interpolator.setAlpha(alpha);
        }
    }

    public Time getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Time beginTime) {
        this.beginTime = beginTime;
    }

    public Time getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Time endTime) {
        this.endTime = endTime;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

