/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.memory;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.xith3d.utility.cache.Cachable;
import org.xith3d.utility.cache.Cache;
import org.xith3d.utility.cache.CacheMatchInterface;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioMemoryBuffer<T>
implements Cachable<T> {
    private static Cache<NioMemoryBuffer<?>> cache = new Cache("NioMemoryBuffers", false);
    private byte[] byteBuffer = null;
    private FloatBuffer floatBuffer = null;
    private ByteBuffer bBuffer = null;
    private IntBuffer intBuffer = null;

    private NioMemoryBuffer(int size) {
        this.byteBuffer = new byte[size];
        this.bBuffer = ByteBuffer.wrap(this.byteBuffer);
        this.intBuffer = this.bBuffer.asIntBuffer();
        this.floatBuffer = this.bBuffer.asFloatBuffer();
        X3DLog.debug("NioMemoryBuffer : ", size);
        X3DLog.debug("  byteBuffer size = ", this.byteBuffer.length);
        X3DLog.debug("  bBuffer capacity = ", this.bBuffer.capacity());
        X3DLog.debug("  intBuffer capacity = ", this.intBuffer.capacity());
        X3DLog.debug("  floatBuffer capacity = ", this.floatBuffer.capacity());
    }

    public static NioMemoryBuffer<?> getInstance(int size) {
        NioMemoryBuffer<?> m = cache.getBest(new Matcher(size));
        if (m != null) {
            return m;
        }
        return new NioMemoryBuffer(size);
    }

    public void returnInstance() {
        cache.put(this);
    }

    public int size() {
        return this.byteBuffer.length;
    }

    public byte[] getByteArray() {
        return this.byteBuffer;
    }

    public FloatBuffer getFloatBuffer() {
        return this.floatBuffer;
    }

    public IntBuffer getIntBuffer() {
        return this.intBuffer;
    }

    @Override
    public long memoryUsed() {
        return this.byteBuffer.length;
    }

    @Override
    public void flush(T o) {
    }

    @Override
    public String getName() {
        return "NioMemoryBuffer";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Matcher
    implements CacheMatchInterface<NioMemoryBuffer<?>> {
        int size;

        public Matcher(int size) {
            this.size = size;
        }

        @Override
        public float match(NioMemoryBuffer<?> o) {
            NioMemoryBuffer<?> m = o;
            if (m.size() == this.size) {
                return 1.0f;
            }
            if (m.size() < this.size) {
                return 0.0f;
            }
            if (m.size() >= this.size * 2) {
                return 0.0f;
            }
            float f = 1 - (m.size() - this.size) / this.size;
            return f;
        }
    }
}

