/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.noise;

import org.xith3d.utility.noise.Noise;

public class Perlin2 {
    public static final int METHOD_BASIC = 1;
    public static final int METHOD_MULTIFRACTAL = 2;
    public static final int METHOD_HETERO_TERRAIN = 3;
    public static final int METHOD_HYBRID_MULTIFRACTAL = 4;
    public static final int METHOD_RIDGED_MULTIFRACTAL = 5;
    public static final int BLACK = 0;
    public static final int BLUE0 = 1;
    public static final int BLUE1 = 9;
    public static final int LAND0 = 10;
    public static final int LAND1 = 18;
    public static final int WHITE = 19;
    public static int[] rtable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 32, 48, 64, 80, 96, 112, 128, 255};
    public static int[] gtable = new int[]{0, 0, 16, 32, 48, 64, 80, 96, 112, 128, 255, 240, 224, 208, 192, 176, 160, 144, 128, 255};
    public static int[] btable = new int[]{0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 4, 8, 12, 16, 20, 24, 28, 32, 255};
    private int method;
    private double H;
    private double lacunarity;
    private double octaves;
    private double offset;
    private double gain;
    private double[] point = new double[2];
    private Noise noise;
    private double[] vec;
    private boolean first_fBm = true;
    private double[] exponent_array;
    public boolean latic;
    public double land;
    public double water;

    public Perlin2() {
        this.method = 1;
        this.H = 0.5;
        this.lacunarity = 2.0;
        this.octaves = 7.0;
    }

    public Perlin2(double hIn, double lacIn, double octIn) {
        this.method = 1;
        this.H = hIn;
        this.lacunarity = lacIn;
        this.octaves = octIn;
        this.noise = new Noise();
    }

    public Perlin2(int methIn, double hIn, double lacIn, double octIn, double offIn, double gainIn, Noise n) {
        this.noise = n;
        switch (methIn) {
            case 2: {
                this.method = 2;
                this.H = hIn;
                this.lacunarity = lacIn;
                this.octaves = octIn;
                this.offset = offIn;
                break;
            }
            case 3: {
                this.method = 3;
                this.H = hIn;
                this.lacunarity = lacIn;
                this.octaves = octIn;
                this.offset = offIn;
                break;
            }
            case 4: {
                this.method = 4;
                this.H = hIn;
                this.lacunarity = lacIn;
                this.octaves = octIn;
                this.offset = offIn;
                break;
            }
            case 5: {
                this.method = 5;
                this.H = hIn;
                this.lacunarity = lacIn;
                this.octaves = octIn;
                this.offset = offIn;
                this.gain = gainIn;
                break;
            }
            default: {
                this.method = 1;
                this.H = hIn;
                this.lacunarity = lacIn;
                this.octaves = octIn;
            }
        }
    }

    public double gain(double a, double b) {
        double p = Math.log(1.0 - b) / Math.log(0.5);
        if (a < 0.001) {
            return 0.0;
        }
        if (a > 0.999) {
            return 1.0;
        }
        if (a < 0.5) {
            return Math.pow(2.0 * a, p) / 2.0;
        }
        return 1.0 - Math.pow(2.0 * (1.0 - a), p) / 2.0;
    }

    public double turbulence(double[] v, double freq) {
        if (this.vec == null) {
            this.vec = new double[2];
        }
        double t = 0.0;
        while (freq >= 1.0) {
            this.vec[0] = freq * v[0];
            this.vec[1] = freq * v[1];
            t += Math.abs(this.noise.noise2(this.vec)) / freq;
            freq /= 2.0;
        }
        return t;
    }

    public double fBm(double[] point, double H, double lacunarity, double octaves) {
        int i;
        double frequency;
        if (this.first_fBm) {
            this.exponent_array = new double[(int)octaves + 1];
            frequency = 1.0;
            i = 0;
            while ((double)i <= octaves) {
                this.exponent_array[i] = Math.pow(frequency, -H);
                frequency *= lacunarity;
                ++i;
            }
            this.first_fBm = false;
        }
        double value = 0.0;
        frequency = 1.0;
        i = 0;
        while ((double)i < octaves) {
            value += this.noise.noise2(point) * this.exponent_array[i];
            point[0] = point[0] * lacunarity;
            point[1] = point[1] * lacunarity;
            ++i;
        }
        double remainder = octaves - (double)((int)octaves);
        if (remainder != 0.0) {
            value += remainder * this.noise.noise2(point) * this.exponent_array[i];
        }
        return value;
    }

    public double multifractal(double[] point, double H, double lacunarity, double octaves, double offset) {
        int i;
        double frequency;
        if (this.first_fBm) {
            this.exponent_array = new double[(int)octaves + 1];
            frequency = 1.0;
            i = 0;
            while ((double)i <= octaves) {
                this.exponent_array[i] = Math.pow(frequency, -H);
                frequency *= lacunarity;
                ++i;
            }
            this.first_fBm = false;
        }
        double value = 1.0;
        frequency = 1.0;
        i = 0;
        while ((double)i < octaves) {
            value *= offset * frequency * this.noise.noise2(point);
            point[0] = point[0] * lacunarity;
            point[1] = point[1] * lacunarity;
            ++i;
        }
        double remainder = octaves - (double)((int)octaves);
        if (remainder != 0.0) {
            value += remainder * this.noise.noise2(point) * this.exponent_array[i];
        }
        return value;
    }

    public double Hetero_Terrain(double[] point, double H, double lacunarity, double octaves, double offset) {
        double increment;
        int i;
        if (this.first_fBm) {
            this.exponent_array = new double[(int)octaves + 1];
            double frequency = 1.0;
            i = 0;
            while ((double)i <= octaves) {
                this.exponent_array[i] = Math.pow(frequency, -H);
                frequency *= lacunarity;
                ++i;
            }
            this.first_fBm = false;
        }
        double value = offset + this.noise.noise2(point);
        point[0] = point[0] * lacunarity;
        point[1] = point[1] * lacunarity;
        i = 1;
        while ((double)i < octaves) {
            increment = this.noise.noise2(point) + offset;
            increment *= this.exponent_array[i];
            value += (increment *= value);
            point[0] = point[0] * lacunarity;
            point[1] = point[1] * lacunarity;
            ++i;
        }
        double remainder = octaves - (double)((int)octaves);
        if (remainder != 0.0) {
            increment = (this.noise.noise2(point) + offset) * this.exponent_array[i];
            value += remainder * increment * value;
        }
        return value;
    }

    public double HybridMultifractal(double[] point, double H, double lacunarity, double octaves, double offset) {
        double result;
        int i;
        if (this.first_fBm) {
            this.exponent_array = new double[(int)octaves + 1];
            double frequency = 1.0;
            i = 0;
            while ((double)i <= octaves) {
                this.exponent_array[i] = Math.pow(frequency, -H);
                frequency *= lacunarity;
                ++i;
            }
            this.first_fBm = false;
        }
        double weight = result = (this.noise.noise2(point) + offset) * this.exponent_array[0];
        point[0] = point[0] * lacunarity;
        point[1] = point[1] * lacunarity;
        i = 1;
        while ((double)i < octaves) {
            if (weight > 1.0) {
                weight = 1.0;
            }
            double signal = (this.noise.noise2(point) + offset) * this.exponent_array[i];
            result += weight * signal;
            weight *= signal;
            point[0] = point[0] * lacunarity;
            point[1] = point[1] * lacunarity;
            ++i;
        }
        double remainder = octaves - (double)((int)octaves);
        if (remainder != 0.0) {
            result += remainder * this.noise.noise2(point) * this.exponent_array[i];
        }
        return result / 2.0 - 1.0;
    }

    public double RidgedMultifractal(double[] point, double H, double lacunarity, double octaves, double offset, double gain) {
        double signal;
        int i;
        if (this.first_fBm) {
            this.exponent_array = new double[(int)octaves + 1];
            double frequency = 1.0;
            i = 0;
            while ((double)i <= octaves) {
                this.exponent_array[i] = Math.pow(frequency, -H);
                frequency *= lacunarity;
                ++i;
            }
            this.first_fBm = false;
        }
        if ((signal = this.noise.noise2(point)) < 0.0) {
            signal = -signal;
        }
        signal = offset - signal;
        signal *= signal;
        double result = signal;
        double weight = 1.0;
        i = 1;
        while ((double)i < octaves) {
            point[0] = point[0] * lacunarity;
            point[1] = point[1] * lacunarity;
            weight = signal * gain;
            if (weight > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            if ((signal = this.noise.noise2(point)) < 0.0) {
                signal = -signal;
            }
            signal = offset - signal;
            signal *= signal;
            result += (signal *= weight) * this.exponent_array[i];
            ++i;
        }
        return (result - 1.0) / 2.0;
    }

    public void setScaling(double M, double W, double H) {
    }

    public double value(double x, double z) {
        this.point[0] = x;
        this.point[1] = z;
        switch (this.method) {
            case 1: {
                return this.fBm(this.point, this.H, this.lacunarity, this.octaves);
            }
            case 2: {
                return this.multifractal(this.point, this.H, this.lacunarity, this.octaves, this.offset);
            }
            case 3: {
                return this.Hetero_Terrain(this.point, this.H, this.lacunarity, this.octaves, this.offset);
            }
            case 4: {
                return this.HybridMultifractal(this.point, this.H, this.lacunarity, this.octaves, this.offset);
            }
            case 5: {
                return this.RidgedMultifractal(this.point, this.H, this.lacunarity, this.octaves, this.offset, this.gain);
            }
        }
        return 0.0;
    }
}

