/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.platform;

public class OSInfo {
    private static OSInfo instance = null;
    private final Category category;
    private final CategoryDetail categoryDetail;

    public static OSInfo getInstance() {
        if (instance == null) {
            instance = new OSInfo();
        }
        return instance;
    }

    public Category getCategory() {
        return this.category;
    }

    public CategoryDetail getCategoryDetail() {
        return this.categoryDetail;
    }

    public String toString() {
        return "O/S Category: " + (Object)((Object)this.getCategory()) + " (" + (Object)((Object)this.getCategoryDetail()) + ")";
    }

    private OSInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        if (osName.startsWith("Mac OS X")) {
            this.category = Category.MAC_OSX;
            this.categoryDetail = osVersion.startsWith("10.5") ? CategoryDetail.MAC_OSX_105 : (osVersion.startsWith("10.4") ? CategoryDetail.MAC_OSX_104 : (osVersion.startsWith("10.3") ? CategoryDetail.MAC_OSX_103 : (osVersion.startsWith("10.2") ? CategoryDetail.MAC_OSX_102 : (osVersion.startsWith("10.1") ? CategoryDetail.MAC_OSX_101 : (osVersion.startsWith("10.0") ? CategoryDetail.MAC_OSX_100 : CategoryDetail.UNKNOWN)))));
        } else if (osName.startsWith("Win")) {
            this.category = Category.WINDOWS;
            this.categoryDetail = CategoryDetail.UNKNOWN;
        } else if (osName.startsWith("Linux")) {
            this.category = Category.LINUX;
            this.categoryDetail = osVersion.startsWith("2.6") ? CategoryDetail.LINUX_26_KERNEL : (osVersion.startsWith("2.4") ? CategoryDetail.LINUX_24_KERNEL : CategoryDetail.UNKNOWN);
        } else {
            this.category = Category.UNKNOWN;
            this.categoryDetail = CategoryDetail.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CategoryDetail {
        WINDOWS_98,
        WINDOWS_ME,
        WINDOWS_2K,
        WINDOWS_NT4,
        WINDOWS_XP1,
        WINDOWS_XP2,
        WINDOWS_VISTA,
        LINUX_24_KERNEL,
        LINUX_26_KERNEL,
        MAC_OSX_100,
        MAC_OSX_101,
        MAC_OSX_102,
        MAC_OSX_103,
        MAC_OSX_104,
        MAC_OSX_105,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        WINDOWS,
        MAC_OSX,
        LINUX,
        UNKNOWN;

    }
}

