/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import java.util.ArrayList;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.HashSpace;
import net.java.dev.joode.space.OctTreeSpace;
import net.java.dev.joode.space.SimpleSpace;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollideableGroupBase;
import org.xith3d.physics.collision.CollideableGroupType;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollisionEngine;
import org.xith3d.physics.joode.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoodeCollideableGroup
extends CollideableGroupBase
implements JoodeCollideable,
CollideableGroup {
    private static final ArrayList<CollideableGroupType> types = new ArrayList();
    private final Space joodeGeom = JoodeCollideableGroup.newSpace(this.getGroupType());
    private Matrix3 rotMatrix3 = null;

    static {
        types.add(new CollideableGroupType(){

            public String getInfo() {
                return "A Simple Space, using naive O(n^2) algorithm";
            }

            public String getName() {
                return "Simple";
            }

            public Class<?> getGroupClass() {
                return SimpleSpace.class;
            }
        });
        types.add(new CollideableGroupType(){

            public String getInfo() {
                return "A Hash Space, which uses some kind of hashing algorithm to categorizethe Geom's levels, which makes collision detection a lot faster..";
            }

            public String getName() {
                return "Hash";
            }

            public Class<?> getGroupClass() {
                return HashSpace.class;
            }
        });
        types.add(new CollideableGroupType(){

            public String getInfo() {
                return "An OcTree Space, which divides space recursively in 8 boxes, which makes collision detection a lot faster..";
            }

            public String getName() {
                return "OcTree";
            }

            public Class<?> getGroupClass() {
                return OctTreeSpace.class;
            }
        });
        types.add(new CollideableGroupType(){

            public String getInfo() {
                return "An OcTree Space, which divides space recursively in 8 boxes, which makes collision detection a lot faster..";
            }

            public String getName() {
                return "OctTree";
            }

            public Class<?> getGroupClass() {
                return OctTreeSpace.class;
            }
        });
    }

    JoodeCollideableGroup(JoodeCollisionEngine engine, String typeString) throws Exception {
        super((CollisionEngine)engine, JoodeCollideableGroup.getType(typeString));
        this.init(engine, (Geom)this.joodeGeom);
    }

    public static final ArrayList<CollideableGroupType> getTypes() {
        return types;
    }

    private static CollideableGroupType getType(String typeString) throws Exception {
        CollideableGroupType t;
        int i = 0;
        while (i < types.size()) {
            t = types.get(i);
            if (t.getName().equalsIgnoreCase(typeString)) {
                return t;
            }
            ++i;
        }
        i = 0;
        while (i < types.size()) {
            t = types.get(i);
            if (t.getName().equals("Simple")) {
                return t;
            }
            ++i;
        }
        throw new Error("No \"Simple\" type defined!");
    }

    private static Space newSpace(CollideableGroupType type) throws Exception {
        Space space = (Space)type.getGroupClass().getConstructors()[0].newInstance(new Object[]{null});
        return space;
    }

    public void addCollideable(Collideable c) {
        JoodeCollideable jc = (JoodeCollideable)c;
        jc.setParent(this);
        this.joodeGeom.add(jc.getJOODEGeom());
        super.addCollideable(c);
    }

    public void removeCollideable(Collideable c) {
        JoodeCollideable jc = (JoodeCollideable)c;
        jc.setParent(null);
        this.joodeGeom.remove(jc.getJOODEGeom());
        super.removeCollideable(c);
    }

    private final void init(JoodeCollisionEngine engine, Geom geom) {
        boolean cfr_ignored_0 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setPosition(Convert.toJOODE((Tuple3f)this.getWorldPos()));
        }
        boolean cfr_ignored_1 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setRotation(Convert.toJOODE(this.getWorldRotMat()));
        }
        geom.setUserData((Object)this);
    }

    public void finalize() {
        this.joodeGeom.setUserData(null);
    }

    @Override
    public JoodeCollisionEngine getEngine() {
        return (JoodeCollisionEngine)super.getEngine();
    }

    public final Space getJOODEGeom() {
        return this.joodeGeom;
    }

    @Override
    public void setParent(CollideableGroup parent) {
        super.setParent(parent);
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEGeom().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEGeom().isEnabled();
    }

    protected void applyWorldRotation(Matrix3f worldRot) {
        if (this.rotMatrix3 == null) {
            this.rotMatrix3 = new Matrix3();
        }
        Convert.toJOODE(worldRot, this.rotMatrix3);
        this.joodeGeom.setRotation(this.rotMatrix3);
    }

    protected void applyWorldPosition(Tuple3f worldPos) {
        this.joodeGeom.setPosition(worldPos.getX(), worldPos.getY(), worldPos.getZ());
    }
}

