/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.TriMesh;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollisionEngine;
import org.xith3d.physics.joode.Convert;

public class JoodeTriMeshCollideable
extends TriMeshCollideable
implements JoodeCollideable {
    private final TriMesh joodeGeom;
    private Matrix3 rotMatrix3 = null;

    public JoodeTriMeshCollideable(JoodeCollisionEngine eng, Vector3[] vertices, int[] indices) {
        super((CollisionEngine)eng);
        this.joodeGeom = new TriMesh(null, true, vertices, indices);
        this.init(eng, (Geom)this.joodeGeom);
    }

    public float[] getVerticesFloats() {
        Vector3[] vertices = this.joodeGeom.getVertices();
        float[] verts = new float[vertices.length * 3];
        int i = 0;
        while (i < vertices.length) {
            System.arraycopy(vertices[i].m, 0, verts, i * 3, 3);
            ++i;
        }
        return verts;
    }

    public int getVertexCount() {
        return this.joodeGeom.getVertices().length;
    }

    public void getVertex(int i, Tuple3f coord) {
        Vector3 vertex = this.joodeGeom.getVertices()[i];
        coord.set(vertex.getX(), vertex.getY(), vertex.getZ());
    }

    public Point3f[] getVertices() {
        if (this.joodeGeom != null) {
            Vector3[] vertices = this.joodeGeom.getVertices();
            Point3f[] verts = new Point3f[vertices.length];
            int i = 0;
            while (i < vertices.length) {
                verts[i] = new Point3f(vertices[i].m[0], vertices[i].m[1], vertices[i].m[2]);
                ++i;
            }
            return verts;
        }
        return null;
    }

    public int getIndexCount() {
        return this.joodeGeom.getIndices().length;
    }

    public int getIndex(int i) {
        return this.joodeGeom.getIndices()[i];
    }

    public int[] getIndices() {
        if (this.joodeGeom != null) {
            return this.joodeGeom.getIndices();
        }
        return null;
    }

    private final void init(JoodeCollisionEngine engine, Geom geom) {
        boolean cfr_ignored_0 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setPosition(Convert.toJOODE((Tuple3f)this.getWorldPos()));
        }
        boolean cfr_ignored_1 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setRotation(Convert.toJOODE(this.getWorldRotMat()));
        }
        geom.setUserData((Object)this);
    }

    public void finalize() {
        this.joodeGeom.setUserData(null);
    }

    public JoodeCollisionEngine getEngine() {
        return (JoodeCollisionEngine)super.getEngine();
    }

    public final TriMesh getJOODEGeom() {
        return this.joodeGeom;
    }

    public void setParent(CollideableGroup parent) {
        super.setParent(parent);
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEGeom().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEGeom().isEnabled();
    }

    protected void applyWorldRotation(Matrix3f worldRot) {
        if (this.rotMatrix3 == null) {
            this.rotMatrix3 = new Matrix3();
        }
        Convert.toJOODE(worldRot, this.rotMatrix3);
        this.joodeGeom.setRotation(this.rotMatrix3);
    }

    protected void applyWorldPosition(Tuple3f worldPos) {
        this.joodeGeom.setPosition(worldPos.getX(), worldPos.getY(), worldPos.getZ());
    }
}

