/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation.joode.joints;

import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointHinge;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.physics.joode.Convert;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.JointLimitMotor;
import org.xith3d.physics.simulation.joints.HingeJoint;
import org.xith3d.physics.simulation.joode.JoodeBody;
import org.xith3d.physics.simulation.joode.JoodeJoint;
import org.xith3d.physics.simulation.joode.JoodeSimulationWorld;

public class JoodeHingeJoint
extends HingeJoint
implements JoodeJoint {
    protected JointHinge joodeJoint;
    private final Point3f anchor = new Point3f();
    private final Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Matrix3f initialRotation = new Matrix3f();
    private static final Vector3 tmpVec = new Vector3();
    private static final Matrix3 tmpMat3 = new Matrix3();
    private static final Quaternion4f tmpQuat = new Quaternion4f();
    private final JoodeSimulationWorld world;

    protected void initJoint(Joint joodeJoint) {
        net.java.dev.joode.Body jBody1 = this.getBody1() == null ? null : ((JoodeBody)this.getBody1()).getJOODEBody();
        net.java.dev.joode.Body jBody2 = this.getBody2() == null ? null : ((JoodeBody)this.getBody2()).getJOODEBody();
        joodeJoint.attach(jBody1, jBody2);
    }

    public JoodeHingeJoint(JoodeSimulationWorld world, Body body1, Body body2) {
        super(body1, body2);
        this.world = world;
        World jWorld = world.getJOODEWorld();
        net.java.dev.joode.joint.JointLimitMotor jLimot = new net.java.dev.joode.joint.JointLimitMotor(jWorld);
        this.joodeJoint = new JointHinge(null, jLimot);
        this.initJoint((Joint)this.joodeJoint);
        this.limot = world.newJointLimitMotor();
    }

    public final JointHinge getJOODEJoint() {
        return this.joodeJoint;
    }

    public void setAnchor(float x, float y, float z) {
        this.anchor.set(x, y, z);
        this.joodeJoint.setAnchor(x, y, z);
        Convert.toXith(this.joodeJoint.getInitialRotation(), tmpQuat);
        this.initialRotation.set(tmpQuat);
    }

    public final Point3f getAnchor() {
        return this.anchor.getReadOnly();
    }

    public void setAxis(float x, float y, float z) {
        this.axis.set(x, y, z);
        this.joodeJoint.setAxis(x, y, z);
        Convert.toXith(this.joodeJoint.getInitialRotation(), tmpQuat);
        this.initialRotation.set(tmpQuat);
    }

    public final Vector3f getAxis() {
        return this.axis.getReadOnly();
    }

    public final void setInitialRotation(Matrix3f initialRotation) {
        this.initialRotation.set(initialRotation);
        Convert.toJOODE(this.initialRotation, tmpMat3);
        this.joodeJoint.setInitialRotation(tmpMat3);
    }

    public void setInitialRotation(float x, float y, float z) {
        MatrixUtils.eulerToMatrix3f((float)x, (float)y, (float)z, (Matrix3f)this.initialRotation);
        Convert.toJOODE(this.initialRotation, tmpMat3);
        this.joodeJoint.setInitialRotation(tmpMat3);
    }

    public final Matrix3f getInitialRotation() {
        return this.initialRotation.getReadOnly();
    }

    public void setLimitMotorImpl(JointLimitMotor limot) {
        if (limot == null) {
            this.joodeJoint.setLimitMotor(null);
        } else {
            if (this.joodeJoint.getLimitMotor() == null) {
                World joodeWorld = this.getWorld().getJOODEWorld();
                this.joodeJoint.setLimitMotor(new net.java.dev.joode.joint.JointLimitMotor(joodeWorld));
            }
            Convert.toJOODE(limot, this.joodeJoint.getLimitMotor());
        }
    }

    protected void refresh() {
        this.joodeJoint.getAbsAnchor(tmpVec);
        Convert.toXith(tmpVec, (Tuple3f)this.anchor);
        super.refresh();
    }

    public JoodeSimulationWorld getWorld() {
        return this.world;
    }

    public void finalize() {
        if (this.getJOODEJoint().getWorld() != null) {
            this.getJOODEJoint().getWorld().removeJoint((Joint)this.getJOODEJoint());
        }
    }
}

