/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Sphere;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollisionEngine;
import org.xith3d.physics.joode.Convert;

public class JoodeSphereCollideable
extends SphereCollideable
implements JoodeCollideable {
    private final Sphere joodeGeom;
    private Matrix3 rotMatrix3 = null;

    public JoodeSphereCollideable(JoodeCollisionEngine eng, float radius) {
        super((CollisionEngine)eng, radius);
        this.joodeGeom = new Sphere(null, radius);
        this.init(eng, (Geom)this.joodeGeom);
    }

    public void setRadius(float radius) {
        super.setRadius(radius);
        this.joodeGeom.setRadius(radius);
    }

    private final void init(JoodeCollisionEngine engine, Geom geom) {
        boolean cfr_ignored_0 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setPosition(Convert.toJOODE((Tuple3f)this.getWorldPos()));
        }
        boolean cfr_ignored_1 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setRotation(Convert.toJOODE(this.getWorldRotMat()));
        }
        geom.setUserData((Object)this);
    }

    public void finalize() {
        this.joodeGeom.setUserData(null);
    }

    public JoodeCollisionEngine getEngine() {
        return (JoodeCollisionEngine)super.getEngine();
    }

    public final Sphere getJOODEGeom() {
        return this.joodeGeom;
    }

    public void setParent(CollideableGroup parent) {
        super.setParent(parent);
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEGeom().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEGeom().isEnabled();
    }

    protected void applyWorldRotation(Matrix3f worldRot) {
        if (this.rotMatrix3 == null) {
            this.rotMatrix3 = new Matrix3();
        }
        Convert.toJOODE(worldRot, this.rotMatrix3);
        this.joodeGeom.setRotation(this.rotMatrix3);
    }

    protected void applyWorldPosition(Tuple3f worldPos) {
        this.joodeGeom.setPosition(worldPos.getX(), worldPos.getY(), worldPos.getZ());
    }
}

